
######################################################################
## $Id: Date.pm 3681 2006-03-13 19:55:12Z spadkins $
######################################################################

package App::Widget::JSApp::Date;
$VERSION = (q$Revision: 3681 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App::Widget::JSApp;
@ISA = ( "App::Widget::JSApp" );

use strict;

=head1 NAME

App::Widget::JSApp::Date - A date widget

=head1 SYNOPSIS

   use App::Widget::JSApp::Date;

   ...

=cut

sub html {
    my $self = shift;
    my $name = $self->{name};

    $self->init_jsapp();

    my $context = $self->{context};
    my $value = $context->so_get($name);
    $value = "" if (!defined $value);

    my $html = <<EOF;
<script type="text/javascript">
  context.widget("$name", {
    "serviceClass" : "DateWidget",
    "submittable" : 1,
    "default" : "$value"
  }).write();
</script>
EOF

    return($html);
}

1;

