/* buffer-2.test.c - check for pgg_buffer_insert() function
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pggtest.h>



int main()
{
    INIT_STD_TEST(PggBuffer, buffer)
    
    pgg_buffer_append(buffer, "bbbb", 4, errenv);
    pgg_buffer_append(buffer, "dddd", 4, errenv);
    pgg_buffer_insert(buffer, 0, "aaaa", 4, errenv);
    pgg_buffer_insert(buffer, 8, "cccc", 4, errenv);
    pgg_buffer_insert(buffer, 16, "eeee", 4, errenv);
    pgg_buffer_append(buffer, "", 1, errenv);
    
    expect_success();
    
    if (pgg_buffer_get_size(buffer, NULL) != 21)
        return 1;
    
    if (strcmp((char *)pgg_buffer_get_data(buffer, NULL), "aaaabbbbccccddddeeee"))
        return 1;
    
    return 0;
}


