/* ************************************************************ *
 *								*
 *		CMD-FILECMDS.C					*
 *								*
 *	A part of main piece of mail (and other) servers.	*
#
#  Copyright 1990-1993   Matti.Aarnio @ FUNET.FI
#  This software is free under similar rules as BSD copyrights.
#  (Definitely this is NOT Public Domain.  "Just" FREELY AVAILABLE.
#   Don't clain you did this..)
#  You can use this, but you shall not held us liable for anything.
#  You must not use our name in marketing, in case you decide to
#  use this.  We do appreciate bug-reports  -> mailserver-owner@nic.funet.fi
#  for improving this piece of software.
 *								*
 * ************************************************************ */

#include <sys/param.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <dirent.h>
#include <sys/resource.h>
#include <varargs.h>
#include "proto.h"	/* Prototypes.. */
#include "config.h"

#if	HAS_FILESTORE	/* from config.h */

#define MAX_FILE_SIZE 256000 /* NOT 256k! */
#define SIZE_SEMI_INFINITE "1000000" /* A STRING! for METAMAIL's splitmail */

extern int errno;
extern int ftp_uid;
extern int ftp_gid;
extern char ftp_home[MAXPATHLEN];
extern int ftp_home_len;

#ifdef	sun
# ifndef BSD
#  define BSD
# endif
#endif

#ifndef BSD
#define getwd getcwd
#endif

#ifndef	S_ISDIR
#define S_ISDIR(mode)	((S_IFMT & (mode)) == S_IFDIR)
#endif
#ifndef	S_ISREG
#define S_ISREG(mode)	((S_IFMT & (mode)) == S_IFREG)
#endif

#include "input.h"
#include "filestats.h"

extern char *strchr(), *strrchr();
extern char *malloc();
extern void  free();
extern int  errno;
extern char *sys_errlist[];


char CurDir[MAXPATHLEN] = "/";

static char *MsrvTempName = "/tmp/msrv.XXXXXX";

static int  PrevFilePartSize = 0;
static int  FilePartSize = 65000;
	/* File delivery part sizes vary greatly with encoding etc...
	   size:   BITNET/NETDATA	  anything/mail
	     0:	      whole file 	   <=60k (depending size of last line)
	    >0:	      BITSEND (file bytes)  limit in chars for each piece
					    (minus chars on last line)
	 */

static long MailQuota = 1024000;
	/* Maximum file delivery at one request mail -- unless altered.. */
static long MailedBytes = 0;
	/* To keep track for breaking */
static int CanDoMime = 0;
	/* If can do mime, use  do_splitmail() to split it mime-vice */

enum FileEncodings {
	Fe_RAW,		/*  0,	plain raw file		*/
	Fe_UUENCODE,	/*  1,	uuencode, UNIX std one	*/
	Fe_XXENCODE,	/*  2,	uuencode XX version (bitnet) */
	/* After RSCSENCODE only encoders which take full path to a file */
	Fe_RSCSENCODE,	/*  3,	uuencode for RSCS (clarkson.. */
	Fe_OBTOA,	/*  4,	btoa, very useful.. */
	Fe_BTOA,	/*  4,	btoa, very useful.. */
	Fe_NETDATA,	/*  5,  BITNET only... */
	/* BASE64 is the first MIME encoder */
	Fe_BASE64,	/*  6,  MIME Base64 */
	Fe_QPRINT	/*  7,  MIME Quoted-Printable */
};
struct EncoderS {
	enum FileEncodings code;
	char *name;
	char *encoder;	/* Prgm to execute for encoding this.. */
	char *comment;
	char *xferencode;
} EncoderSet [] = {
  {Fe_RAW,	"RAW",		NULL,			"Default encoder",	"8BIT"},
  {Fe_BASE64,	"BASE64",	_MMENCODE_PATH" -b  %S","MIME BASE-64",		"Base64"},
  {Fe_BASE64,	"MIME",		_MMENCODE_PATH" -b  %S","MIME BASE-64",		"Base64"},
  {Fe_QPRINT,	"QPRINT",	_MMENCODE_PATH" -q  %S","MIME Quoted-Printable", "Quoted-Printable"},
  {Fe_UUENCODE,	"UUENCODE",	"uuencode %S < %S",	"Basic USENET UUE",	"7BIT"},
  {Fe_UUENCODE,	"UUE",		"uuencode %S < %S",	"Basic USENET UUE",	"7BIT"},
  {Fe_XXENCODE,	"XXENCODE",	"xxencode %S < %S",	"BITNET XXENCODE"	"7BIT"},
  {Fe_XXENCODE,	"XXE",		"xxencode %S < %S",	"BITNET XXENCODE"	"7BIT"},
  {Fe_RSCSENCODE, "RSCS",	"rscsencode < %S",	"Clarkson.Edu RSCS encode", "7BIT"},
  {Fe_BTOA,	"BTOA",		"btoa < %S",		"Usenet btoa (5.2) encode",	"7BIT"},
  {Fe_OBTOA,	"OBTOA",	"btoa -o < %S",		"Usenet btoa (pre 5.2) encode",	"7BIT"},
  {Fe_NETDATA,	"NETDATA",	"/usr/local/bin/sendfile %S -u MAILSERV@FINFILES -bin %S",		"BITNET NETDATA",	"8BIT"},
  {Fe_NETDATA,	"ND",		"/usr/local/bin/sendfile %S -U MAILSERV@FINFILES -bin %S",		"BITNET NETDATA",	"8BIT"},
  {0,		NULL,		NULL,		NULL,		NULL}
};


static struct EncoderS * FileEncoding = &EncoderSet[0];
/*static enum FileEncodings FileEncoding = Fe_RAW; */
static char *HypeMime = "* Can you accept MIME ?  Ask \"HELP MIME\" for more information.\n";
static char *HypePARTS = "* Check PARTS command if you need to partially retry the request.";
static char *FileContentType;
static char *FileContentType = NULL;
static char *FileContentType0 = "TEXT/PLAIN; charset=ISO-8859-1";
static char *MultiPartHeaderContent = "MULTIPART/MIXED;\n\tBOUNDARY=\"MiXeDOctEtStReAm\"";
static char *MimeBoundary = "MiXeDOctEtStReAm";

static int recogn_jpeg(); /* Two NAME recognizer for MIME */
static int recogn_mpeg(); /* Two NAME recognizer for MIME */
static int recogn_gif();

static void hypemime(outfile)
FILE *outfile;
{
	if(!HypeMime)return;
	fprintf(outfile,HypeMime);
	HypeMime = NULL;
}
static int hypeparts(outfile)
FILE *outfile;
{
	if(!HypePARTS)return 0;
	fprintf(outfile,"%s\n",HypePARTS);
	HypePARTS = NULL;
	return 1;
}

/* ****************************************************************
 *
 *  do_partsize()  -- setup FilePartSize info
 *
 * **************************************************************** */
	
int
do_partsize(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	int rc,size;
	char *nextarg;
	char c;

	if (ftp_home_len == 0) {
	  fprintf(outfile,"** Sorry, doesn't have file store enabled!\n");
	  return 64;
	}

	hypemime(outfile);
	if (*argstr == 0) {
	  fprintf(outfile,"\
* Part size value is `%d' which meaning depends upon\n\
* how file is encoded for transmission.\n",FilePartSize);
	} else {

	  nextarg = pick_nextarg(argstr);

	  size = 0; c = 0;
	  rc = sscanf(argstr,"%d%c",&size,&c);

/* fprintf(outfile,"rc = %d,  %%d = %d, %%c = %c (%d)\n",rc,size,c,c); */

	  if (nextarg != NULL) {
	    fprintf(outfile,"\
* Extra argument(s) to %s  Only one accepted!\n\
* See HELP %s for details.\n",Cmd->name,Cmd->name);
	    return 1;
	  }
	  if (rc < 1) {
	    fprintf(outfile,"\
* %s command expects its argument to be NUMERIC with one\n\
* possible defining character.\n\
* See HELP %s for further info.\n",
		     Cmd->name,Cmd->name);
	    return 1;
	  } else if (rc == 1) {
	    /* Plain numeric value.. */
	    if (size != 0 && size < 5000) {
	      fprintf(outfile,"\
* Come on...  %s %d   is ridiculous.\n\
* Minimal value for argument is 5000 (bytes).  It has been assumed.\n",Cmd->name,size);
	      size = 5000;
	    }
	    FilePartSize = size;
	  } else {
	    if (c == 'k' || c == 'K') {
	      if (size < 5) {
		fprintf(outfile,"\
* Come on...  %s %dkB   is ridiculous.  (1k = 1000)\n\
* Minimal value for argument is 5K (bytes).  It has been assumed.\n",
			Cmd->name,size);
		size = 5;
	      }
	      size *= 1000;
	    } else if (c == 'm' || c == 'M') {
	      if (size < 1 || size > 50) {
		fprintf(outfile,"\
* Come on...  %s %dMB   is ridiculous.\n\
* Value for argument with M-qualifier must be in range 1..50 (Mbytes).\n\
* Value  1M  has been assumed.  (Our `M' is 1 000 000 !)\n",Cmd->name,size);
		size = 1;
	      }
	      size *= 1000000L;
	    } else if (c == 'l' || c == 'L' ||
		       c == 'r' || c == 'R') {
	      size = -size;
	      if (size > -60 /* Negative you remember ? */ ) {
		if (c == 'l' || c == 'L')
		  fprintf(outfile,"\
* Come on... %s %dLines   is ridiculous!\n\
* Minimum value for lines count is 60.  It has been assumed.\n",
			  Cmd->name, -size);
		else
		  fprintf(outfile,"\
* Come on... %s %dRecords   is ridiculous!\n\
* Minimum value for records count is 60.  It has been assumed.\n",
			  Cmd->name, -size);
		size = -60;	/* 60 records/lines */
	      }
	    } else {
	      fprintf(outfile,"\
* `%s %d%c'  has unrecognized quality denotation character.\n",Cmd->name,size,c);
	      fprintf(outfile,"\
* Recognized ones are: `k' (kilos)  `r' (records) and `l' (lines).\n\
* They are handled case insensitive.\n");
	      return 1;
	    }
	  }
	  if (size < 0) size *= -78; /* Convert lines to chars.. */
	  if (size == 0) {
	    fprintf(outfile,"\
* So you have asked for semi-infinite part size.  Know that this value\n\
* will be lowered by the management, if we get too many bounces due to\n\
* people asking this..  Current true value: %s\n",SIZE_SEMI_INFINITE);
	  }
	  if (size > MAX_FILE_SIZE && PrevFilePartSize == 0) {
	    fprintf(outfile,"\
* Sorry, I don't believe you can successfully receive very large mails.\n");
	    size = MAX_FILE_SIZE;
	  }
	  if (size > MAX_FILE_SIZE && PrevFilePartSize != 0)
	    fprintf(outfile,"\
* Sorry, experience is that users are unable to receive very large monolithic\n\
*  files via mail.  Max part size is 64k,\n");

	  PrevFilePartSize = FilePartSize;
	  FilePartSize = size;
	  fprintf(outfile,"* Now %s has value: %d\n",Cmd->name,size);
	}
	return 0;
}


/* ****************************************************************
 *
 *  do_mailquota()  -- setup MailQuota limit
 *
 * **************************************************************** */
	
int
do_mailquota(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	int rc;
	long size;
	char *nextarg;
	char c;

	if (ftp_home_len == 0) {
	  fprintf(outfile,"** Sorry, doesn't have file store enabled!\n");
	  return 64;
	}

	hypemime(outfile);
	if (*argstr == 0) {
	  fprintf(outfile,"\
* MailQuota value is `%d' which limits the total amount of mail\n\
* this server will send to you with this request file\n",MailQuota);
	} else {

	  nextarg = pick_nextarg(argstr);

	  size = 0L; c = 0;
	  rc = sscanf(argstr,"%d%c",&size,&c);

/* fprintf(outfile,"rc = %d,  %%d = %d, %%c = %c (%d)\n",rc,size,c,c); */

	  if (nextarg != NULL) {
	    fprintf(outfile,"\
* Extra argument(s) to %s  Only one accepted!\n\
* See HELP %s for details.\n",Cmd->name,Cmd->name);
	    return 1;
	  }
	  if (rc < 1) {
	    fprintf(outfile,"\
* %s command expects its argument to be NUMERIC with one\n\
* possible defining character.\n\
* See HELP %s for further info.\n",
		     Cmd->name,Cmd->name);
	    return 1;
	  } else if (rc == 1) {
	    /* Plain numeric value.. */
	    if (size > 50000000L) {
	      fprintf(outfile,"\
* Come on...  %s %ld   is ridiculous.\n\
* Absolute max value for argument is 50 Million (bytes).\n\
* It has been assumed.  (Expect it to be chopped futher!\n",Cmd->name,size);
	      size = 50000000L;
	    }
	    MailQuota = size;
	  } else {
	    if (c == 'k' || c == 'K') {
	      if (size < 20 || size > 50000L ) {
		fprintf(outfile,"\
* Come on...  %s %dkB   is ridiculous.\n\
* Value for argument with K-qualifier must be in range 20..50000 (kbytes).\n\
* Value  20k  has been assumed.  (1k = 1000)\n",
			Cmd->name,size);
		size = 20;
	      }
	      size *= 1000L;
	    } else if (c == 'm' || c == 'M') {
	      if (size < 1 || size > 50) {
		fprintf(outfile,"\
* Come on...  %s %dMB   is ridiculous.\n\
* Value for argument with M-qualifier must be in range 1..50 (Mbytes).\n\
* Value  1M  has been assumed.  (1M = 1 000 000)\n",Cmd->name,size);
		size = 1;
	      }
	      size *= 1000000L;
	    } else {
	      fprintf(outfile,"\
* `%s %d%c'  has unrecognized quality denotation character.\n",Cmd->name,size,c);
	      fprintf(outfile,"\
* Recognized ones are: `k' (kilos)  and `M' (megas)\n\
* They are handled case insensitive. (1k = 1000, 1M = 1000 000)\n");
	      return 1;
	    }
	  }
	  MailQuota = size;
	  fprintf(outfile,"* Now %s has value: %d\n",Cmd->name,size);
	}
	return 0;
}



/* ****************************************************************
 *
 * do_encoding() -- setup encoding info
 *
 * **************************************************************** */


int
do_encoding(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	struct EncoderS *ES = EncoderSet;
	char *nextarg;

	if (ftp_home_len == 0) {
	  fprintf(outfile,"** Sorry, doesn't have file store enabled!\n");
	  return 64;
	}

	if (*argstr == 0) {
	  fprintf(outfile,"* Current value of encoding is `%s', info `%s'\n",
		  FileEncoding->name,FileEncoding->comment);
	  hypemime(outfile);
	  return 0;
	}

	nextarg = pick_nextarg(argstr);

	if (nextarg != NULL) {
	  fprintf(outfile,"* %s -command accepts only one argument!\n",
		  Cmd->name);
	  return 1;
	}
	upperstr(argstr);
	while (ES->name != NULL) {
	  if (strcasecmp(argstr,ES->name) == 0) break; /* FOUND! */
	  ++ES;
	}
	if (ES->name) {
	  FileEncoding = ES;
	  fprintf(outfile,"* New encoder has comment: `%s'\n",ES->comment);
	  if (ES->code < Fe_BASE64)
	    hypemime(outfile);
	  else
	    CanDoMime = 1;
	} else {
	  fprintf(outfile,"\
* %s %s -- unrecognized encoding.  See HELP ENCODE for info.\n\
*   No change of encoder.\n",
		  Cmd->name,argstr);
	  return 1;
	}

	return 0;
}


 /* ****************************************************************
 *
 *  char * canon_path(ftphome,curdir,testdir,argstr);
 *
 *  return the result in the "testdir" buffer.
 *
 * *************************************************************** */
static char *
canon_path(ftphome,curdir,testdir,argstr)
char *ftphome, *curdir, *argstr;
char *testdir; /* XX: if this should malloc it ? */
{
	char *s, *ss;

	strcpy(testdir,ftphome);	/* "/ftproot" */
	if (*argstr != '/') {		/* Absolute ? */
	  if (*curdir != '/') {		/* No, relative calls for `CurDir' */
	    strcat(testdir,"/");
	    strcat(testdir,curdir);
	  } else
	    strcat(testdir,curdir);
	  s = strrchr(testdir,'/');
	  if (s && s[1] != 0)		/* Make sure it ends with '/' */
	    strcat(testdir,"/");
	} else
	  ++argstr;			/* Skip initial `/' */

	while (argstr && *argstr) {	/* Canonalize path... */
	  char *dirslash = s = strchr(argstr,'/');
	  if (s)
	    *s++ = 0;
	  if (s && *argstr == 0) {	/* A `//' perhaps ? */
	    argstr = s;
	    if (dirslash) *dirslash = '/';
	    continue;
	  }
	  if (strcmp(".",argstr)==0) {
	    argstr = s;
	    if (dirslash) *dirslash = '/';
	    continue; /* Current dir... */
	  }
	  if (strcmp("..",argstr)==0) {	/* Previous dir */
	    argstr = s;
	    if (dirslash) *dirslash = '/';
	    s = strrchr(testdir,'/');
	    if (s) *s = 0;
	    continue;
	  }
	  /* Right, anything...
	     Lets test if proposed dir/file can be reached! */
	  ss = strrchr(testdir,'/');
	  if (!ss || ss[1] != 0)
	    strcat(testdir,"/");
	  strcat(testdir,argstr);
	  if (dirslash) *dirslash = '/';
	  argstr = s;
	  /* Oops, this is CANONIZATION routine, we test nothing! */
	} /* while( *argstr ) */

	return testdir;
}


 /* ****************************************************************
 *
 *   int filepath_is_valid(*stats,testdir)
 * rc:
 *   0 == invalid
 *   1 == file
 *   2 == directory
 *
 * The "testdir" argument is supposed to be a result from  canon_path().
 *
 * **************************************************************** */

int
filepath_is_valid(stats,testdir)
struct stat *stats;
char testdir[MAXPATHLEN];	/* What we claim to test */
{
	char *s, *ss;
	int rc;

	if (!testdir || *testdir == 0) {
	  return 0;
	}

	stats->st_mode = 0;		/* init... */

	if (strncmp(testdir,ftp_home,ftp_home_len) != 0) {
	  return 0;
	}

	s = testdir;
	if (*s == '/') ++s;
	while((ss = strchr(s,'/'))) {
	  /* Scan all parts of the path, and make sure they are reachable! */
	  *ss = 0; /* Zap the '/' */

	  rc = stat(testdir,stats);	/* We do NOT detect symlinks. We follow them! */
	  if (rc != 0) {
	    *ss= '/';
	    return 0;			/* Well, failed... */
	  }
	  if (!(S_ISDIR(stats->st_mode) &&
		(stats->st_mode & S_IXOTH)) && /* Not accessible */
	      !(S_ISREG(stats->st_mode) &&
		(stats->st_mode & S_IROTH))) /* Not readable */ {
	    *ss = '/';
	    return 0;
	  }
	  /* Previous segment was dir or regular, and plainly readable. */
	  *ss = '/';
	  s = ++ss;
	}

	/* Test again, otherwise "cd /" fails.. */
	rc = stat(testdir,stats);	/* We do NOT detect symlinks. We follow them! */
	if (rc != 0) return 0;			/* Well, failed... */
	if (S_ISDIR(stats->st_mode)) return 2;
	return 1;
	/* Path validated: Dir = 2, regular file: 1 */
}


 /* ****************************************************************
 *
 * do_chdir() -- change current working dir to something else.
 *
 * **************************************************************** */

int
do_chdir(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	char workdir[MAXPATHLEN];	/* Where work is done */
	char testdir[MAXPATHLEN];	/* What we claim to test */
	char checkdir[MAXPATHLEN];	/* What we test */
	int  rc, filerc;
	struct stat stats;

	if (ftp_home_len == 0) {
	  fprintf(outfile,"** Sorry, doesn't have file store enabled!\n");
	  return 64;
	}

	if (*argstr == 0) {		/* No argument for CHDIR ! */
	  fprintf(outfile,"* Current directory is: `%s'\n",CurDir);
	  return 0;
	}

	getwd(workdir);			/* Real work dir */

	canon_path(ftp_home,CurDir,testdir,argstr);
	filerc = filepath_is_valid(&stats,testdir);

	if (filerc == 2 /* valid directory */ ) {
	  goto found_dir;
	}
	if (filerc == 1 /* regular file! */ ) {
	  fprintf(outfile,
		  "* File in %s path is not directory: `%s'\n",
		  Cmd->name, testdir+ftp_home_len);
	  chdir(workdir);
	  return 64;
	}
	fprintf(outfile,
		"* Directory validity sense reported error on `%s'\n",
		testdir+ftp_home_len);
	return 64;


found_dir:

	/* Now, whole argstr is used. Lets see what we have gotten. */
	rc = chdir(testdir);

	if (rc != 0) {
	  fprintf(outfile,"\
*** BUG ? Failed to move to directory while its parsing went smoothly ???\n\
* Dir: `%s'\n",testdir);
	  chdir(workdir);
	  return 255;
	}
	if (getwd(checkdir) != 0) {
	  if (strncmp(checkdir,ftp_home,ftp_home_len) != 0) {
	    fprintf(outfile,"\
*** BUG ?  Directory went outside `%s'. Root assumed! `%s'\n",
		    ftp_home,checkdir);
	    strcpy(CurDir,"/");
	    rc = 255;
	  } else {
	    /* Everything checked ok! */
	    strcpy(CurDir,testdir+ftp_home_len);
	    rc = 0;
	  }
	} else {
	  /* Can't getwd() */
	  fprintf(outfile, "\
*** BUG ?  Can't getwd() ! errno=%d, error=`%s', Msg: `%s'\n",
		  errno, strerror(errno), checkdir);
	  rc = 255;
	}

	chdir(workdir);

	if (*CurDir == 0)		/* Empty dir ? */
	  strcpy(CurDir,"/");

	if (rc == 0)
	  fprintf(outfile,"* %s successfull. Current dir: `%s'\n",
		  Cmd->name,CurDir);
	return rc;
}

/* ****************************************************************
 *
 * do_parts() -- specify parts to be sent with next  mail_reply()
 *
 * **************************************************************** */

char *PartBits = NULL;
int PartBitsCnt = 0;

void
zap_part_def()
{
	if (PartBits)
	  free(PartBits);
	PartBits = NULL;
	PartBitsCnt = 0;
}

int
do_parts(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	char *a = argstr;
	int i1,i2;

	if (ftp_home_len == 0) {
	  fprintf(outfile,"** Sorry, doesn't have file store enabled!\n");
	  return 64;
	}

	zap_part_def();

	while (*a && (*a == ' ' || *a == '\t')) ++a;
	if (*a == 0) {
	  fprintf(outfile,"* %s -command must have an argument, see HELP %s\n",
		  Cmd->name,Cmd->name);
	  return 4;
	}

#define SETBIT(b) \
	  if (b >= PartBitsCnt) {			\
	    int pbc = PartBitsCnt + (16<<3);		\
	    PartBits = realloc(PartBits,pbc >> 3);	\
	    memset(PartBits+(PartBitsCnt>>3),0,16);	\
	    PartBitsCnt = pbc;				\
	  }						\
	  *((unsigned char*)PartBits + (b >> 3)) |= (1 << (b & 07))


	PartBitsCnt= 16<<3; /* 8 bits per byte! */
	PartBits   = malloc(PartBitsCnt >> 3);
	memset(PartBits,0,PartBitsCnt >> 3);
	i1 = i2 = 0;
	while (*a) {
	  if (isdigit(*a)) {
	    i1 = 0;
	    while (isdigit(*a)) {
	      i1 *= 10;
	      i1 += (*a - '0');
	      ++a;
	    }
	  }
	  if (!*a) break;
	  if (i1 && i2) {
	    /* Bit range */
	    for ( ; i2 <= i1; ++i2 ) {
	      SETBIT(i2);
	    }
	    i2 = i1 = 0;
	    continue;
	  }
	  if (*a == '-') {
	    i2 = i1;
	    i1 = 0;
	    ++a;
	    continue;
	  }
	  SETBIT(i1);
	  i2 = i1 = 0;
	  ++a; /* Whatever character, skip it.. */
	}
	/* End of arguments! Check if a range was last.. */
	if (i1 && i2) {
	  /* Bit range */
	  for ( ; i2 <= i1; ++i2 ) {
	    SETBIT(i2);
	  }
	  i2 = i1 = 0;
	}
	if (i1) {
	  SETBIT(i1);
	}

	fprintf(outfile,"* scanned bits, result: ");
	i2 = 0; /* where range began */
	i1 = 1;
	while (i1 < PartBitsCnt) {
	  /* At first, hunt 1st set bit */
	  while (i1 < PartBitsCnt) {
	    if (send_this_part(i1))
	      break;
	    ++i1;
	  }
	  if (i1 >= PartBitsCnt) break; /* Didn't find. */
	  /* Ok, 1st 1 bit found */
	  if (i2)
	    fprintf(outfile,","); /* Already something before this */
	  fprintf(outfile,"%d",i1);
	  i2 = i1;
	  ++i1;
	  if (send_this_part(i1)) {
	    /* Two bits after each other */
	    fprintf(outfile,"-");
	    ++i1;
	  } else { /* No bit set! */
	    continue; /* Loop back to begin */
	  }
	  /* Scan until no more set bits */
	  while (i1 < PartBitsCnt) {
	    if (!send_this_part(i1)) break;
	    ++i1;
	  }
	  fprintf(outfile,"%d",i1-1);
	  /* Range-end */
	}
	fprintf(outfile,"\n");
	return 0;
}

int
send_this_part(partnum)
const int partnum;
{
	unsigned char *pb = (unsigned char *)PartBits;
	if (!PartBits) return 1;
	if (PartBitsCnt < partnum) return 0;
	if (partnum < 1) {
	  fprintf(stderr,"## send_this_part() called with non-positive argument: %d\n",partnum);
	  return 0;
	}
	pb += (partnum >> 3); /* 8 bits per char */
	return ((1 << (partnum & 07)) & *pb);
}


/* ****************************************************************
 *
 *  do_locate() -- do directory/file search over local archive.
 *
 * **************************************************************** */


int
do_locate(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
#if DOES_LOCATE
	FILE	*tmpfil;
	FILE	*infile;
	char	inpline[MAXPATHLEN];
	char	SubjBuffer[200];
	char	matchexpr[MAXPATHLEN];
	char	template[40];
	register int rc;
	register int count = 0;
	char *s;

	if (ftp_home_len == 0) {
	  fprintf(outfile,"** Sorry, doesn't have file store enabled!\n");
	  return 64;
	}

	s = argstr;
	while (*s && (*s == ' ' || *s == '\t')) ++s;
	if (*s == 0) {
	  /* No argument! */
	  fprintf(outfile,"*** %s -command must have an argument!\n",Cmd->name);
	  zap_part_def();
	  return 4;
	}

	argstr = s;

	sprintf(SubjBuffer,"%s `%s' result",Cmd->name,argstr);
	SubjBuffer[60] = 0;		/* Truncate.. */


	sprintf(matchexpr,"-d %s %s",_FTP_LOCATEDB,argstr);
	infile = rootcmdpopen(ftp_home,"/",ftp_uid,ftp_gid,_PATH_LOCATE,matchexpr,"rG",NULL);
	if (infile == NULL) {
	  fprintf(outfile,"*** Couldn't open `locate' grepper, Report to maintance!\n");
	  zap_part_def();
	  return 127;
	}
	strcpy(template,MsrvTempName);
	tmpfil = fdopen(mkstemp(template),"w+");
	if (tmpfil == NULL) {
	  fprintf(outfile,"\
* OUCH!!  Couldn't create temporary file!\n\
* You will get first 60 matches printed, rest are only counted.\n\
* Report to maintance!\n");
	}
	fprintf(outfile,"* Matching for regexpr: `%s'\n",argstr);
	while (!feof(infile) && !ferror(infile)) {
	  *inpline = 0;
	  if( fgets(inpline,sizeof inpline,infile) == NULL) break;
	  if (*inpline == 0) break;
	  ++count;
	  if (tmpfil == NULL) {
	    /* Right, show first 60 on responce mail */
	    if (count <= 60)
	      fputs(inpline,outfile);
	  } else {
	    /* Store to tmpfile */
	    fputs(inpline,tmpfil);
	  }
	}
	fprintf(outfile,"* Found %d matches.\n",count);
	fclose(infile);
	if (!tmpfil) {
	  zap_part_def();
	  return 127;
	}
	fflush(tmpfil);

	if (count < 60) {
	  /* Reply right away */
	  register int c;
	  char *ss = "* ----------------\n*:";
	  fseek(tmpfil,0,0);	/* rewind() */
	  fputs(ss,outfile);
	  while (!feof(tmpfil) && !ferror(tmpfil)) {
	    if ((c = getc(tmpfil)) == -1) break;
	    putc(c,outfile);
	    if (c == '\n') fputs("*:",outfile);
	  }
	  fclose(tmpfil);
	  fputs(ss,outfile);
	  unlink(template);
	  zap_part_def();
	  return 0;
	}
	fclose(tmpfil);
	rc = mail_reply(template,Cmd,Hdr,outfile,count,SubjBuffer);
	unlink(template);
	zap_part_def();
	return rc;
#else
	fprintf(outfile,"Sorry, doesn't do the LOCATE service. Not configured.\n");
	return  64;
#endif
}



/* ****************************************************************
 *
 * mail_reply() -- send reply in mail
 *
 * **************************************************************** */

int
mail_reply(filename,Cmd,Hdr,outfile,lines,Subject)
char *filename;
struct command *Cmd;
struct headers *Hdr;
FILE *outfile;
int lines;
char *Subject;
{
	extern char myhostname[];

	long tmpsize;
	int sentpieces = 0, sentpiecescnt = 0;
	FILE *tmpfil;
	struct stat sbuf;
	char MessageId[256];
	static int MonoSeq = 0; /* Monotonically increasing... */

	stat(filename,&sbuf);
	tmpsize = sbuf.st_size;
	tmpfil  = fopen(filename,"r+");

	fseek(tmpfil,0,0);	/* rewind() */

	if (MailedBytes+tmpsize > MailQuota) {
	      fprintf(outfile,
		      "** ERROR: This file together with your (possible) previous requests on this\n"
		      "**        request file will exceed your  MailQuota  limit on %d kilobytes\n"
		      "**        To increase it, issue command:  MAILQUOTA nnK\n",
		      MailQuota/1024);
	      zap_part_def();
	      return 128;
	    }

	if (CanDoMime) {
	  /* Lets do it MIME-way.. */
	  char *tmpprefix;
	  char splitsize[10];
	  char buf[512];
	  FILE *mailfile;

	  mkdir("/tmp/msrv.out",0755);
	  tmpprefix = tempnam("/tmp/msrv.out/","MiMe");

	  if (!tmpprefix) {
	    fprintf(outfile,"* Mimeoid tempnam() failed :-(  Aargh!\n");
	    return 128;
	  }
	  mailfile = tmpfile();
	  if (!FileContentType) FileContentType = FileContentType0;
	  sprintf(MessageId,"%s-%d-MIME@%s",
		  Hdr->ReplyMsgId,++MonoSeq,myhostname);
	  Create_Mail_Header(mailfile,Hdr,Subject,MultiPartHeaderContent,NULL,MessageId);


	  fprintf(mailfile,"> THIS MESSAGE IS IN `MIME' FORMAT (RFC 1341).\n");
	  fprintf(mailfile,"> If you are reading this, your mail reader might not support MIME.\n");
	  fprintf(mailfile,"> Some parts of this message will be readable as plain text.\n\n");
	  fprintf(mailfile,
		  "--%s\nContent-Type: %s\nContent-Transfer-Encoding: %s\n\n",
		  MimeBoundary, FileContentType, FileEncoding->xferencode);

	  while (!feof(tmpfil) && !ferror(mailfile) && !ferror(tmpfil)) {
	    int len = fread(buf,1,sizeof(buf),tmpfil);
	    if (len < 1) break;
	    fwrite(buf,len,1,mailfile);
	  }
	  fclose(tmpfil);
	  fprintf(mailfile,"\n\n--%s\n",MimeBoundary);

	  sprintf(splitsize,"%d",FilePartSize);
	  if (FilePartSize==0)  /* Infinity for MIME is now set at 1 Meg */
	    strcpy(splitsize,SIZE_SEMI_INFINITE);
	  do_splitmail(mailfile,outfile,tmpprefix,splitsize);
	  unlink(filename);
	  fclose(mailfile);
	  do_mailpieces(outfile,tmpprefix);
	  free(tmpprefix);
	  zap_part_def();
	  return 0;
	}


	unlink(filename);

	{		/* Count in bytes */
	  int parts;
	  int leftover;
	  int partbytes;
	  int partfree = 0;
	  int mypartsize = FilePartSize;

	  /* At first:  Lower estimate of parts.  True parts can be this if
	     `leftover' == 0.	*/

	  if (FilePartSize <5000)
	    mypartsize = 65000;
	  if (FilePartSize == 0) { /* Document says: Size 0, don't split! */
	    mypartsize = 1000000; /* I say, "don't split" is 1MB */
	    if (tmpsize > mypartsize)
	      fprintf(outfile,"* Sorry, forced split at 1MB\n");
	  }
	  
	  parts = tmpsize / mypartsize;
	  /* ...and how much this leaves `leftover' ? */
	  leftover = tmpsize - parts * mypartsize;
	  /*   partfree tells about that tail to be filled.. */
	  if (leftover) /* But only if it wasn't even.. */
	    partfree = mypartsize - leftover;
	  /*   upper estimate of `partbytes'  */
	  partbytes = mypartsize;

	  /*fprintf(outfile,"*+ debug tmpsize=%d, parts=%d, partfree=%d, partbytes=%d\n",
	    tmpsize,parts,partfree,partbytes);fflush(outfile); */

	  if (leftover > 0) ++parts;
	  if (parts == 0) ++parts; /* should not happen */

	  if (partfree > 0) {	/* Usual situation... */
	    /* XX: Same as earlier..  Get it more even somehow.. */
	    partbytes = parts + tmpsize / parts;
	    leftover  = tmpsize -  parts * partbytes;
	    partfree  = partbytes - leftover;
	  }

	  sentpieces = 0; /* First to be tested is 1.. */
	  while (1) {
	    register int c;
	    register int bytecnt = partbytes;
	    register int outbytes = 0;
	    register int linecnt;

	    ++sentpieces;
	    if (send_this_part(sentpieces)) {
	      FILE *mailfile = tmpfile();

	      if (!mailfile) {
		fprintf(outfile,"** FATAL: Can't create tmpfile() for mail slicing!\n");
		exit(127);
	      }

	      if (!FileContentType) FileContentType = FileContentType0;
	      sprintf(MessageId,"%s-%d-%d@%s",
		      Hdr->ReplyMsgId,++MonoSeq,sentpieces,myhostname);
	      Create_Mail_Header(mailfile,Hdr,NULL,FileContentType,
				 FileEncoding->xferencode,MessageId);
	      fprintf(mailfile,"Subject:   part %d of %d - %s\n\n",
		      sentpieces,parts,Subject);

	      linecnt = 0;
	      while ((c = getc(tmpfil)) != EOF &&
		     MailedBytes < MailQuota) {
		putc(c,mailfile);
		--bytecnt;
		++outbytes;
		++MailedBytes;
		if (c == '\n') {
		  ++linecnt;
		  ++MailedBytes;
		  if (bytecnt <= 0) break;
		}
	      }
	      tmpsize -= outbytes;
	      fseek(mailfile,0,0); /* rewind() */
	      if (outbytes) {
		do_sendmail(mailfile,outfile);
		++sentpiecescnt;
		fprintf(outfile,
			"* mailed out a piece of it, %d bytes/%d lines of contents\n",
			outbytes,linecnt);
	      }
	      fclose(mailfile);
	    } else {
	      /* Skip this file part.. */
	      linecnt = 0;
	      while ((c = getc(tmpfil)) != EOF) {
		--bytecnt;
		++outbytes;
		if (c == '\n') {
		  ++linecnt;
		  if (bytecnt <= 0) break;
		}
	      }
	      tmpsize -= outbytes;
	      fprintf(outfile,
		      "* skipped piece nbr %d of it, %d bytes/%d lines of contents\n",
		      sentpieces,outbytes,linecnt);
	    }
	    if (MailedBytes >= MailQuota) {
	      fprintf(outfile,
		      "** ERROR: Exceeded your  MailQuota  limit on %d kilobytes\n"
		      "**        To increase it, issue command:  MAILQUOTA nnK\n",
		      MailQuota/1024);
	      fclose(tmpfil);
	      zap_part_def();
	      return 128;
	    }
	    if (c == EOF) break;
	  }
	  fclose(tmpfil);
	}
	fprintf(outfile,"* Mailed out %d piece(s) of results.\n",sentpiecescnt);

	zap_part_def();
	return 0;
}


/* ****************************************************************
 *
 * do_filedir() -- mail out list of files using FTP /bin/ls
 *
 * **************************************************************** */

int
do_filedir(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	FILE *tmpfil, *lspipe;
	int lines = 0;
	int dirbytes;
	int dirquota;
#if Freak_FTP_LS
	char tmpstr[MAXPATHLEN*8];
#endif
	char tmpstr2[MAXPATHLEN*8];
	char tempname[MAXPATHLEN];
	char workdir[MAXPATHLEN];

	if (ftp_home_len == 0) {
	  fprintf(outfile,"** Sorry, doesn't have file store enabled!\n");
	  return 64;
	}
	
	getwd(workdir);

	dirquota = MailQuota - MailedBytes;
	dirbytes = 0;

#if	Freak_FTP_LS
	if (strlen(argstr) > (sizeof(tmpstr) -5))
	  argstr[sizeof(tmpstr)-5] = 0; /* Truncate! */
	sprintf(tmpstr,"-Z %s",argstr);
	argstr = tmpstr;
#endif
	lspipe = rootcmdpopen(ftp_home,CurDir,ftp_uid,ftp_gid,
			      _PATH_FTP_LS,argstr,
			      "r",NULL);
	/* Pipe forks LS in proper directory.  Let it run there... */

	if (lspipe == NULL) {
	  fprintf(outfile,"** Failed to start LS program!\n\n");
	  return 63;
	}

	strcpy(tempname,MsrvTempName);
	tmpfil = fdopen(mkstemp(tempname),"w+");
	if (tmpfil == NULL) {
	  fprintf(outfile,"\
** Ouch!  Can't create temporary file!\n\
** You get only first 60 lines, rest will be flushed!\n");
	  while (lines < 60 && !feof(lspipe) && !ferror(lspipe)) {
	    register int c = getc(lspipe);
	    if (c == EOF) break;
	    putc(c,outfile);
	    if (c == '\n') ++lines;
	  }
	  rootcmdpclose(lspipe);
	  fprintf(outfile,"** Done with it -- without tmp file%s\n",
		  lines >= 60 ? ", chopped at 60 lines" : "");
	} else {
	  /* We have temp file.  Lets see what we do... */
	  register int c;
	  while (!feof(lspipe) && !ferror(lspipe) && !ferror(tmpfil) &&
		 dirbytes < dirquota) {
	    if ( (c = getc(lspipe)) == EOF ) break;
	    putc(c,tmpfil);
	    if (c == '\n') ++lines;
	    ++dirbytes;
	  }
	  rootcmdpclose(lspipe);
	  fflush(tmpfil);
	  if (lines < 60) {
	    fprintf(outfile,"*## Short listing, %d lines:\n*:",lines);
	    fseek(tmpfil,0,0);		/* rewind() */
	    while (!feof(tmpfil) && !ferror(tmpfil)) {
	      if ((c = getc(tmpfil)) == EOF) break;
	      putc(c,outfile);
	      if (c == '\n') fputs("*:",outfile);
	    }
	    fprintf(outfile,"*## end of listing\n");
	  } else {
	    if (dirbytes >= dirquota) {
	      fputs("*!! Quota left for mail output exceeded while scanning directory\n*!! Aborting directory listing.  See  HELP MAILQUOTA\n",outfile);
	    }

	    /* Big.. Mail it in pieces.. */
	    if (strlen(argstr) > (sizeof(tmpstr2) -5))
	      argstr[sizeof(tmpstr2)-5] = 0; /* Truncate! */
	    sprintf(tmpstr2,"DIR %s",argstr);
	    mail_reply(tempname,Cmd,Hdr,outfile,lines,tmpstr2);
	  }
	}
	if (tmpfil) fclose(tmpfil);
	unlink(tempname);

	AccessLogging("CM %d %s '%s' %d %s %s", getpid(),
		      Hdr->Reply,
		      CurDir,
		      dirbytes,
		      "/bin/ls",
		      argstr );
		    
	if (dirbytes >= dirquota) return 63;
	return 0;
}


/* ****************************************************************
 *
 *  do_shopmark()  --  Mark up files for later sending...
 *
 * **************************************************************** */

int
do_shopmark(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	char *nextarg;
	int rc = 0, filerc, workcnt = 0;
	struct stat stats;
	char testdir[MAXPATHLEN];
	char workdir[MAXPATHLEN];
	register char *cp;
	FILE *iop;
	int argc, gargc;
	char **pop, *argv[100], *gargv[1000], *vv[2];
	extern char *strtok();
	int testdirlen;

	if (ftp_home_len == 0) {
	  fprintf(outfile,"** Sorry, doesn't have file store enabled!\n");
	  return 64;
	}

*(int *)(testdir+1) = 0; /* SIGBUS ! */
*(int*)NULL = 0;	 /* SIGSEGV on machines that don't barf on mis-align..*/

	getwd(workdir);
	strcpy(testdir,ftp_home);	/* "/ftproot" */
	if (*argstr != '/') {		/* Absolute ? */
	  if (*CurDir != '/') {		/* No, relative calls for `CurDir' */
	    strcat(testdir,"/");
	    strcat(testdir,CurDir);
	  } else
	    strcat(testdir,CurDir);
	} else
	  ++argstr;			/* Skip initial `/'	*/
	testdirlen = strlen(testdir);
/*XX: "/ftproot" || "/curdir" || "/" || RelativeGlobToken	*/
/*XX: "/ftproot" || AbsoluteGlobToken				*/

	/* break up string into pieces */
	argv[0] = "<GLOBBED>";
	for (argc = 1-1, cp = argstr; ++argc; cp = NULL) {
	  char *s;
	  if (!(s = strtok(cp, " \t\n"))) break;
	  canon_path(ftp_home,CurDir,testdir,s);
	  argv[argc] = malloc(strlen(testdir)+2);	/* XX: Remember to free()! */
	  strcpy(argv[argc],testdir);
	}
	argv[argc] = NULL;

	iop = NULL;
	/* glob each piece */
	gargv[0] = argv[0];
	for (gargc = argc = 1; argv[argc]; argc++) {
		if (!(pop = glob(argv[argc]))) { /* globbing failed */
			vv[0] = argv[argc];
			vv[1] = NULL;
			pop = copyblk(vv);
		}
		argv[argc] = (char *)pop;	/* save to free later */
		while (*pop && gargc < 1000)
			gargv[gargc++] = *pop++;
	}
	gargv[gargc] = NULL;

	/* Process all globbed entries */
	/* Need to estabilish the existence of file/directory */

	for (argc = 1; gargv[argc]; ++argc) {
	  ++workcnt;
	  filerc = filepath_is_valid(&stats,gargv[argc]);
	  switch (filerc) {
	    case 1:
		/* Plain file */
		fprintf(outfile,"\
* Sorry, shop tagging is not yet fully implemented.\n");
		fprintf(outfile,
			"Your file `%s' has size of %d Bytes (%dkB)\n",
			gargv[argc]+ftp_home_len, stats.st_size,
			(stats.st_size+1023)/1024);
		break;
	    case 2:
		fprintf(outfile,"\
* Whole directories (`%s' is directory)\n\
* are not yet available for shop marking\n",gargv[argc]+ftp_home_len);
		rc |= 2;
		/* Directory */
		break;
	    case 0:
		/* Failure! */
		fprintf(outfile,"\
* Shop marking of file `%s'\n\
* failed for file/dir unavailability.",gargv[argc]+ftp_home_len);
		/*if (nextarg)
		  fprintf(outfile,"Others will be attempted for marking...\n");*/
		rc |= 1;
		break;
	    default:	;
	  }	/* switch () */
	} /* for ( argc ++ ) */
	

	for (argc = 1; argv[argc] != NULL; argc++)
		blkfree((char **)argv[argc]);

	if (workcnt == 0) {
	  fprintf(outfile,"\
** %s command requires file(/dir) path arguments\n\
* See  HELP %s  for further info\n",
		  Cmd->name,Cmd->name);
	  rc |= 1;
	}

	fprintf(outfile,"*** Not yet fully implemented...  Sorry !***\n");

	return rc;
}


/* ****************************************************************
 *
 * do_filesend()  (dm@itumic.Itumic.FI)
 *
 * **************************************************************** */

/* Minor utility to build  /bin/sh (via popen(3)) parameter strings.. */

void Fsprintf(buf,fmt,va_alist)
char *buf, *fmt;
va_dcl
{
	va_list ap;
	char *a;

	va_start(ap);
	while(*fmt) {
	  if (*fmt != '%') {
	    *buf++ = *fmt++;
	  } else {
	    ++fmt;
	    switch (*fmt) {
	      case '%':
		  *buf++ = '%';
		  break;
	      case 's':
		  a = va_arg(ap, char*);
		  while (*a) {
		    if (*a == '\"' || *a == '\\')
		      *buf++ = '\\';
		    *buf++ = *a++;
		  }
		  break;
	      case 'S':
		  a = va_arg(ap, char*);
		  *buf++ = '\'';
		  while (*a) {
		    if (*a == '\'') {
		      *buf++ = *a;	/*  'xxxx '\''xxx' -> "xxxx 'xxx" */
		      *buf++ = '\\';
		      *buf++ = *a;
		    }
		    *buf++ = *a++;
		  }
		  *buf++ = '\'';
		  break;
	    }
	    ++fmt;
	  }
	}
	*buf = 0; /* Terminate output string! */
	va_end(ap);
}

int
do_filesend(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	int rc = 0, piperc;
    	int lines;
	char *nextarg;
	int filerc, workcnt = 0;
	struct stat stats;
	char testdir[MAXPATHLEN];
	char workdir[MAXPATHLEN];
	static char ContentBuf[MAXPATHLEN+40];
	char tempname[MAXPATHLEN];
	register char *cp;
	FILE *tmpfil, *data = NULL;
	int argc, gargc;
	char **pop, *argv[100], *gargv[1000], *vv[2];
	extern char *strtok();

	if (ftp_home_len == 0) {
	  fprintf(outfile,"** Sorry, doesn't have file store enabled!\n");
	  return 64;
	}

	getwd(workdir);

/*XX: "/ftproot" || "/curdir" || "/" || RelativeGlobToken	*/
/*XX: "/ftproot" || AbsoluteGlobToken				*/

	/* break up string into pieces */
	argv[0] = "<GLOBBED>";
	for (argc = 1-1, cp = argstr; ++argc; cp = NULL) {
	  char *s;
	  if (!(s = strtok(cp, " \t\n"))) break;
	  canon_path(ftp_home,CurDir,testdir,s);
	  argv[argc] = malloc(strlen(testdir)+2);	/* XX: Remember to free()! */
	  strcpy(argv[argc],testdir);
	}
	argv[argc] = NULL;

	/* glob each piece */
	gargv[0] = argv[0];
	for (gargc = argc = 1; argv[argc]; argc++) {
		if (!(pop = glob(argv[argc]))) { /* globbing failed */
			vv[0] = argv[argc];
			vv[1] = NULL;
			/* XX: free(argv[argc]); ?? */
			pop = copyblk(vv);
		}
		argv[argc] = (char *)pop;	/* save to free later */
		while (*pop && gargc < 1000)
			gargv[gargc++] = *pop++;
	}
	gargv[gargc] = NULL;

	/* Process all globbed entries */
	/* Need to estabilish the existence of file/directory */

	(void) hypeparts();

	for (argc = 1; gargv[argc]; ++argc) {
#ifdef	NO_GIFS_NOW
	  if (recogn_gif(gargv[argc]) || recogn_jpeg(gargv[argc]) ||
	      recogn_mpeg(gargv[argc])) {
	    fprintf(outfile,"* Sorry, at the moment we do not send out JPEGs, MPEGs, nor GIFs.\n");
	    continue;
	  }
#endif
	  ++workcnt;

	  filerc = filepath_is_valid(&stats,gargv[argc]);
	  /*fprintf(outfile,
	    "*+ debug validity rc= %d, FileEncoding->comment=%s\n",
	    filerc,FileEncoding->comment);*/
	  switch (filerc) {
	    case 1:
		/* Plain file */
		fprintf(outfile,
			"* Your file `%s' has size of %d Bytes (%dkB)\n",
			gargv[argc]+ftp_home_len, stats.st_size,
			(stats.st_size+1023)/1024);

		if (FileEncoding->code == Fe_NETDATA) {
		  /* BITNET stuff is special! */
		  char args[MAXPATHLEN];

		  args[MAXPATHLEN-1] = 0;

		  Fsprintf(args,FileEncoding->encoder,
			   Hdr->Reply,
			   gargv[argc]);

		  rc = system(args);
		  if (rc != 0)
		    fprintf(outfile,"** Ouch, something wrong! Delivery execution error code: %d\n",rc);
		  else
		    AccessLogging("RB %d %s '%s' %d %ld %s", getpid(),
				  Hdr->Reply,
				  CurDir,
				  stats.st_size,
				  1,
				  gargv[argc]+ftp_home_len);
		  break; /* Ok, that was BITNET */
		}

		strcpy(tempname,MsrvTempName);
		unlink(tempname);
		tmpfil = fdopen(mkstemp(tempname),"r+");
		if (tmpfil == NULL) {
		  fprintf(outfile,"** Ouch!  Can't create temporary file!\n");
		  fprintf(outfile,"** Sorry, can't send you file %s!\n",
			  gargv[argc]+ftp_home_len);
		  rc |= 4;
		} else if(FileEncoding->code == Fe_RAW) {
		  /* Send file without encoding! */
		  if((data = fopen(gargv[argc], "r")) == NULL) {
		    fprintf(outfile,"** Sorry, can't open file %s!\n\
** File un-retrievable.\n",gargv[argc]+ftp_home_len);
		    fclose(tmpfil);
		    rc |= 4;
		  }
		} else {
		  char args[MAXPATHLEN];

		  args[MAXPATHLEN-1] = 0;

		  /* Build command line argument for encoder */
		  if (FileEncoding->code >= Fe_RSCSENCODE)
		    Fsprintf(args,
			     FileEncoding->encoder,
			     gargv[argc]);
		  else
		    Fsprintf(args,
			     FileEncoding->encoder,
			     basename(gargv[argc]),
			     gargv[argc]);

		  if (FileEncoding->code == Fe_BASE64) {
		    if (recogn_gif(gargv[argc]))
		      Fsprintf(ContentBuf,
			       "IMAGE/GIF;\n\tname=\"%s\"",
			       basename(gargv[argc]));
		    else if (recogn_jpeg(gargv[argc]))
		      Fsprintf(ContentBuf,
			       "IMAGE/JPEG;\n\tname=\"%s\"",
			       basename(gargv[argc]));
		    else
		      Fsprintf(ContentBuf,
			       "APPLICATION/octet-stream;\n\tname=\"%s\"",
			       basename(gargv[argc]));
		    FileContentType = ContentBuf;
		  } else if (FileEncoding->code == Fe_QPRINT) {
		    Fsprintf(ContentBuf,
			     "TEXT/PLAIN; charset=US-ASCII;\n\tname=\"%s\"",
			     basename(gargv[argc]));
		    FileContentType = ContentBuf;
		  } else {
		    FileContentType = FileContentType0;
		  }
		    
		  fprintf(outfile, "* Running file through command \"%s\"\n",args);
		  /* Send file with specified encoding */
		  if((data = popen(args,"r")) == NULL) {
		    fprintf(outfile,"** Sorry, unable to feed %s through %s!\n** File un-retrievable.\n",FileEncoding->encoder, gargv[argc]+ftp_home_len);
		    fclose(tmpfil);
		    rc |= 4;
		  }
		}
		if (data != NULL) {
		  /* We have a temp file and a data file.
		     Lets attempt to send it using proper encoding... */
		  register int c, cnt = 0;
		  int status = 0;
		    
		  lines = 0;
		  while (!feof(data) && !ferror(data) && !ferror(tmpfil)) {
		    if ( (c = getc(data)) == EOF ) break;
		    ++cnt;

		    /* Check for binary data! */ 
		    if(c > 127) /* check for CTRL-characters? */ {
		      if(FileEncoding->code == Fe_RAW) {
			fprintf(outfile, "** HELP - file contains binary data and no encoding is specified!\n");
			fprintf(outfile, "** Please define encoding.\n");
		      } else {
			fprintf(outfile, "** Encoding with %s failed FATALLY.  Please try a different encoder.\n",FileEncoding->name);
		      }
		      fprintf(outfile, "** I cannot send you this through mail!\n");
		      rc |= 1;
		      status = 1;
		      break;
		    }
		    putc(c,tmpfil);
		    if (c == '\n') ++lines;
		  }
		  if(FileEncoding->code == Fe_RAW) {
		    status |= fclose(data);
		  } else {
		    if((piperc = pclose(data)) != 0) {
		      fprintf(outfile, "** Encoding FAILED! PipeRC=0x%x   Copied over %d characters.\n** Unable to send the requested file. ",piperc,cnt);
		      /*if (nextarg)
			fprintf(outfile,"Will attempt to send others...\n");*/
		      status = -1;
		    }
		  }

		  fflush(tmpfil);
		  if(status == 0) {
		    char tmpstr[800];
		    /* Mail it in pieces.. */
		    sprintf(tmpstr,"SEND %s",gargv[argc]+ftp_home_len);
		    mail_reply(tempname,Cmd,Hdr,outfile,lines,tmpstr);
		    
		    AccessLogging("RM %d %s '%s' %d %ld %s", getpid(),
				  Hdr->Reply,
				  CurDir,
				  stats.st_size,
				  1,
				  gargv[argc]+ftp_home_len);
		    
		  }
		}
	        if(tmpfil != NULL)
		  fclose(tmpfil);
		unlink(tempname);
		break;
	    case 2:
		fprintf(outfile,"* Whole directories (`%s' is a directory)\n* are not yet available for retrieving\n",gargv[argc]+ftp_home_len);
		rc |= 2;
		/* Directory */
		break;
	    case 0:
		/* Failure! */
		fprintf(outfile,"* Retrieving of file `%s' failed.  File not available.\n",gargv[argc]+ftp_home_len);
		/*if (nextarg)
		  fprintf(outfile,"Will attempt to retrieve others...\n");*/
		rc |= 1;
		break;
	    default:	;
	  }	/* switch () */
	} /* for ( argc ++ ) */

	for (argc = 1; argv[argc] != NULL; argc++)
		blkfree((char **)argv[argc]);

	if (workcnt == 0) {
	  fprintf(outfile,"** %s command requires file(/dir) path arguments\n* See  HELP %s  for further info\n",
		  Cmd->name,Cmd->name);
	  rc |= 1;
	}

	return rc;
}

static int
recogn_gif(fname)
const char *fname;
{
  int len = strlen(fname);
  return (len > 4 && strcasecmp(fname+len-4,".gif")==0);
}

static int
recogn_jpeg(fname)
const char *fname;
{
  int len = strlen(fname);
  if (len > 4 && strcasecmp(fname+len-4,".jpg")==0)
    return 1;
  return (len > 5 && strcasecmp(fname+len-5,".jpeg")==0);
}


static int
recogn_mpeg(fname)
const char *fname;
{
  int len = strlen(fname);
  if (len > 4 && strcasecmp(fname+len-4,".mpg")==0)
    return 1;
  return (len > 5 && strcasecmp(fname+len-5,".mpeg")==0);
}


#else /* HAS_FILESTORE == 0 */
/* ****************************************************************
 *
 *  DUMMY ROUTINES
 *
 *  do_partsize()  -- setup FilePartSize info
 *  do_encoding() -- setup encoding info
 *  do_chdir() -- change current working dir to something else.
 *  do_locate() -- do directory/file search over local archive.
 *  do_filedir() -- mail out list of files using FTP /bin/ls
 *  do_shopmark()  --  Mark up files for later sending...
 *  do_filesend()  (dm@itumic.Itumic.FI)
 *
 * **************************************************************** */
int do_partsize(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	fprintf(outfile,"* Sorry, no FILESTORE related commands compiled in.\n");
	return 1;
}
int do_encoding(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	fprintf(outfile,"* Sorry, no FILESTORE related commands compiled in.\n");
	return 1;
}
int do_chdir(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	fprintf(outfile,"* Sorry, no FILESTORE related commands compiled in.\n");
	return 1;
}
int do_locate(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	fprintf(outfile,"* Sorry, no FILESTORE related commands compiled in.\n");
	return 1;
}
int do_filedir(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	fprintf(outfile,"* Sorry, no FILESTORE related commands compiled in.\n");
	return 1;
}
int do_shopmark(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	fprintf(outfile,"* Sorry, no FILESTORE related commands compiled in.\n");
	return 1;
}
int do_filesend(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	fprintf(outfile,"* Sorry, no FILESTORE related commands compiled in.\n");
	return 1;
}

#endif /* HAS_FILESTORE */
