/* ****************************************************************
 *
 *  Mail Utils - some utility functions
#
#  Copyright 1990-1993   Matti.Aarnio @ FUNET.FI
#  This software is free under similar rules as BSD copyrights.
#  (Definitely this is NOT Public Domain.  "Just" FREELY AVAILABLE.
#   Don't clain you did this..)
#  You can use this, but you shall not held us liable for anything.
#  You must not use our name in marketing, in case you decide to
#  use this.  We do appreciate bug-reports  -> mailserver-owner@nic.funet.fi
#  for improving this piece of software.
 *
 * **************************************************************** */


#include <sys/param.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <dirent.h>
#include <stdarg.h>

extern int errno;

#ifndef	S_ISDIR
#define S_ISDIR(mode)	((S_IFMT & (mode)) == S_IFDIR)
#endif
#ifndef	S_ISREG
#define S_ISREG(mode)	((S_IFMT & (mode)) == S_IFREG)
#endif

#include "config.h"
#include "input.h"

extern char *strchr(), *strrchr();
extern char *malloc();
extern void  free();
extern int  errno;
extern char *sys_errlist[];


/* ****************************************************************
 *
 * Create_Mail_Header() -- print mail header tags..
 *
 * **************************************************************** */

static char *mail_target_addr = "nobody";
	/* Theory: this is valid at the same value as header, when
	           do_sendmail() is called */

int
Create_Mail_Header(mailfile,Hdr,Subject,MimeContentType,MimeXferEncoding,MessageId)
FILE *mailfile;
struct headers *Hdr;
char *Subject, *MimeContentType, *MimeXferEncoding, *MessageId;
{
	int BugCC = 0;

	if (!Hdr->Reply) { Hdr->Reply = "nobody"; BugCC = 1; }
	if (!Hdr->MessageId) { Hdr->MessageId = "No-Msg-Id"; BugCC = 1; }
	mail_target_addr = Hdr->Reply;
	fprintf(mailfile,"From:        %s\n",MAIL_IDENTITY );
	fprintf(mailfile,"Errors-To:   mailserver-owner\n");
	fprintf(mailfile,"To:          %s\n",Hdr->Reply );
	fprintf(mailfile,"In-Reply-To: <%s>\n",Hdr->MessageId );
	if (Subject)
	  fprintf(mailfile,"Subject:     %s\n",Subject );
	if (BugCC)
	  fprintf(mailfile,"Bcc:          mea\n"); /* Hunt header bugs! */
	if (MessageId)
	  fprintf(mailfile,"Message-Id: <%s>\n",MessageId );
	fprintf(mailfile,"MIME-Version: 1.0\n");
	if (MimeContentType)
	  fprintf(mailfile,"Content-Type: %s\n",MimeContentType);
	if (MimeXferEncoding)
	  fprintf(mailfile,"Content-Transfer-Encoding: %s\n",MimeXferEncoding);
	if (Subject)
	  fprintf(mailfile,"\n");


	return 0;
}


/* ****************************************************************
 *
 *  do_sendmail()   -- run SENDMAIL as subprocess...
 *
 * **************************************************************** */

void
do_sendmail(mailfile,outfile)
FILE *mailfile, *outfile;
{
	fflush(mailfile);
	fseek(mailfile,0,0);
	(void) do_runsubproc(mailfile,outfile,
			     _SENDMAIL_PATH,"sendmail","-f",MAIL_IDENTITY,
			     mail_target_addr,NULL);
}

/* ****************************************************************
 *
 *  do_splitmail()   -- run MetaMail's  splitmail(1)  as subprocess...
 *
 * **************************************************************** */

void
do_splitmail(mailfile,outfile,prefix,splitsize)
FILE *mailfile, *outfile;
char *prefix, *splitsize;
{
	fseek(mailfile,0,0);
	(void) do_runsubproc(mailfile,outfile,
			     _SPLITMAIL_PATH,"splitmail","-s",splitsize,
			     "-p",prefix,NULL);
}



/* ****************************************************************
 *
 *  do_mailpieces()   -- Send out pieces of messages
 *
 * **************************************************************** */

void
do_mailpieces(FILE *outfile, char *prefix)
{
	FILE *mailfile = outfile; /* Non-null value for starters */
	char filename[MAXPATHLEN];
	int number;
	int piececount = 0;
	struct stat statdat;

	for (number = 1;; ++number) {
	  sprintf(filename,"%s%d",prefix,number);
	  if (stat(filename,&statdat) < 0) break; /* No more files.. */
	  if (send_this_part(number)) {
	    mailfile = fopen(filename,"r");
	    if (mailfile)
	      do_sendmail(mailfile,outfile);
	    fclose(mailfile);
	    ++piececount;
	  }
	  unlink(filename);
	}
	fprintf(outfile,"* Sent %d piece(s) out of original %d\n",
		piececount,number-2);
}


/* ****************************************************************
 *
 *  do_runsubproc()   -- Generic sub-process runner
 *
 * **************************************************************** */

int
do_runsubproc(FILE *mailfile, FILE *outfile, char *progpath,
	      char *argv0, ...)
{
	va_list pvar;
	int pid = fork();
	int rc;
	int status;
	int argc = 0;
	const char *argv[100];

	if (pid < 0) {
	  fprintf(outfile,"Wow!  fork() FAILED!  Err: %d (%s)\n",
		  errno,strerror(errno));
	  return errno;
	}

	va_start(pvar,argv0);
	argv[argc] = argv0;
	argv[++argc] = va_arg(pvar,char*);
	  while (argv[argc])
	    argv[++argc] = va_arg(pvar,char*);
	va_end(pvar);
	if (pid == 0) {		/* CHILD */
	  /* Pipe it to program... */
	  dup2(fileno(mailfile),0);
	  dup2(fileno(outfile),1);
	  dup2(fileno(outfile),2);
	  rc = execvp(progpath,argv);
	  _exit(rc);
	}
	       /* Parent */
	do {
	  rc = wait(&status);
	} while(rc == -1 && errno == EINTR);
	if (WIFEXITED(status)) {
	  if (WEXITSTATUS(status) != 0)
	    fprintf(outfile,
		    "Program \"%s\" exited with ERROR status: %d\n",argv[0],
		    WEXITSTATUS(status));
	} else if (WIFSIGNALED(status))
	  fprintf(outfile,
		  "Program \"%s\" terminated ABNORMALLY on signal: %d (%s)\n",
		  argv[0], WTERMSIG(status),strsignal(WTERMSIG(status)));
#ifdef BSD
	else if (WIFSTOPPED(status)) {
	  fprintf(outfile,
		  "What -- Child \"%s\" STOPPED on signal %d (%s) What ?\n",
		  argv[0],WSTOPSIG(status),strsignal(WSTOPSIG(status)));
	} 
#endif
    	else {
    	    fprintf(outfile,
		  "What ?  Child process (%s) exited without good reason ?  status=0x%X\n",
		  argv[0],status);
	}
	return status;
}


/* ****************************************************************
 *
 *   match_myaddr() -- true if entered address matches this host's
 *		       identity
 *
 * **************************************************************** */

char *my_aliases[] = { MY_ALIASES, NULL };

int
match_myaddr(addr)
const char *addr;
{
	char **alias = my_aliases;

	if (*addr == 0) return 1;	/* Void address -> local */

	while (*alias) {
	  if (strcasecmp(*alias,addr) == 0) return 1;
	  ++alias;
	}
	return 0;
}
