/*
  Modified for mailserver@nic.funet.fi  by  Matti Aarnio <mea@nic.funet.fi>
  18-Feb-1991
 */
/*
 * Copyright (c) 1988 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software written by Ken Arnold and
 * published in UNIX Review, Vol. 6, No. 8.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * static char sccsid[] = "@(#)popen.c	5.7 (Berkeley) 9/1/88";
 */

#ifndef lint
static char sccsid[] = "@(#)popen.c	5.2 (Berkeley) 9/22/88";
#endif /* not lint */

#include <sys/types.h>
#if	defined(USG) && !defined(sun)
#include <sys/bsdtypes.h>
#define bzero(s,n)	memset(s,0,n)
#endif
#include <sys/signal.h>
#include <stdio.h>

#include <errno.h>
extern int errno; extern char *sys_errlist[];

/*
 * Special version of popen which avoids call to shell.  This insures no-one
 * may create a pipe to a hidden program as a side effect of a list or dir
 * command.
 */
static pid_t *pids;
static int fds;
int rootcmdpstat;

FILE *
rootcmdpopen(root,defdir,uid,gid,cmd,arguments,type,pidp)
	char *root,*defdir,*type,*cmd,*arguments;
	uid_t uid;
	gid_t gid;
	pid_t *pidp;
{
	register char *cp;
	FILE *iop;
	int argc, gargc, pdes[2], pid;
	int rc;
	int noglob = 0;
	int errwrap = 0;
	char **pop, *argv[100], *gargv[1000], *vv[2];
	extern char **glob(), **copyblk(), *strtok();

	if (*type != 'r' && *type != 'w' && type[1] != 0 && type[1] != 'G')
		return(NULL);

	if (type[1] == 'G') noglob = 1;
	if (type[1] == 'E'||type[2]=='E') errwrap = 1;

	if (!pids) {
#ifdef BSD
		if ((fds = getdtablesize()) <= 0)
			return(NULL);
#endif
		if (!(pids =
		    (uid_t *)malloc((u_int)(fds * sizeof(uid_t)))))
			return(NULL);
		bzero(pids, fds * sizeof(uid_t));
	}
	if (pipe(pdes) < 0)
		return(NULL);

	iop = NULL;
#ifdef	USG
 	switch(pid = fork()) {
#else
	switch(pid = vfork()) {
#endif
	case -1:			/* error */
		(void)close(pdes[0]);
		(void)close(pdes[1]);
		goto free;
		/* NOTREACHED */
	case 0:				/* child */
		rc = 0;
		if (root)
		  rc = chroot(root);
		if (rc != 0) {
		  printf("chroot() failure!, errno=%d, str=`%s'\n",
			 errno,sys_errlist[errno]);
		}
		rc = chdir(defdir);
		if (rc != 0) {
		  extern int errno; extern char *sys_errlist[];
		  printf("initial chdir() failure!, errno=%d, str=`%s'\n",
			 errno,sys_errlist[errno]);
		}
		/* Now turn into minor pawn.. */
		setgid(gid);
		setuid(uid);

		/* break up string into pieces */
		argv[0] = cmd;
		for (argc = 1, cp = arguments; ; cp = NULL)
			if (!(argv[argc++] = strtok(cp, " \t\n")))
				break;
		argv[argc] = NULL;

		/* glob each piece */
		gargv[0] = argv[0];
		for (gargc = argc = 1; argv[argc]; argc++) {
			if (noglob ||			 /* No globbing, or .. */
			    !(pop = glob(argv[argc]))) { /* globbing failed */
				vv[0] = argv[argc];
				vv[1] = NULL;
				pop = copyblk(vv);
			}
			argv[argc] = (char *)pop;	/* save to free later */
			while (*pop && gargc < 1000)
				gargv[gargc++] = *pop++;
		}
		gargv[gargc] = NULL;
/*if (*type == 'r' && errwrap){printf("Args: "); for (argc=0; *gargv[argc]; ++argc) printf("\"%s\" ",gargv[argc]); printf("\n");fflush(stdout);}*/


		if (*type == 'r') {
			if (pdes[1] != 1) {
				dup2(pdes[1], 1);
				if (errwrap)
				  dup2(pdes[1], 2);
				(void)close(pdes[1]);
			}
			(void)close(pdes[0]);
		} else {
			if (pdes[0] != 0) {
				dup2(pdes[0], 0);
				(void)close(pdes[0]);
			}
			(void)close(pdes[1]);
		}
		execv(gargv[0], gargv);
		_exit(73); /* EX_OSERR -- can't exec.. */
	}
	/* parent; assume fdopen can't fail...  */
	if (*type == 'r') {
		iop = fdopen(pdes[0], type);
		(void)close(pdes[1]);
	} else {
		iop = fdopen(pdes[1], type);
		(void)close(pdes[0]);
	}
	pids[fileno(iop)] = pid;
	if (pidp != NULL) *pidp = pid;

free:	/* fork() takes care of it... */
/*	for (argc = 1; argv[argc] != NULL; argc++)	*/
/*		blkfree((char **)argv[argc]);		*/
	return(iop);
}

int
rootcmdpclose(iop)
	FILE *iop;
{
	register int fdes;
	long omask;
	int pid;	
	u_int waitpid();
	

	/*
	 * pclose returns -1 if stream is not associated with a
	 * `popened' command, or, if already `pclosed'.
	 */
	if (pids[fdes = fileno(iop)] == 0)
		return(-1);
	(void)fclose(iop);
#if	defined(USG) && !defined(sun)
	omask = sigset(SIGINT,SIG_IGN);
	omask = sigset(SIGQUIT,SIG_IGN);
	omask = sigset(SIGHUP,SIG_IGN);
	while ((pid = wait(&rootcmdpstat)) != pids[fdes] && pid != -1);
	omask = sigset(SIGINT,SIG_DFL);
	omask = sigset(SIGQUIT,SIG_DFL);
	omask = sigset(SIGHUP,SIG_DFL);
#else
	omask = sigblock(sigmask(SIGINT)|sigmask(SIGQUIT)|sigmask(SIGHUP));
	while ((pid = wait(&rootcmdpstat)) != pids[fdes] && pid != -1);
	(void)sigsetmask(omask);
#endif
	pids[fdes] = 0;
	return(rootcmdpstat);
}
