/* ************************************************************ *
 *								*
 *		CMD-SUSPECTADDR					*
#
#  Copyright 1990-1993   Matti.Aarnio @ FUNET.FI
#  This software is free under similar rules as BSD copyrights.
#  (Definitely this is NOT Public Domain.  "Just" FREELY AVAILABLE.
#   Don't clain you did this..)
#  You can use this, but you shall not held us liable for anything.
#  You must not use our name in marketing, in case you decide to
#  use this.  We do appreciate bug-reports  -> mailserver-owner@nic.funet.fi
#  for improving this piece of software.
 *								*
 * ************************************************************ */

/* Well, this is a bit simple-minded approach, not full RFC822 parser
   and so forth, but hopefully can handle most common X.400 addresses

   This is intended to be used when email address is suspected to be
   file path instead of real user address.

  Badies:
	foo. bar@legal. domain  (spaces cause problems..)

 */

/* return 1 when suspect, 0 when ok */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <ctype.h>
#include "config.h"

extern char *strchr();
extern void *malloc();
extern void *realloc();

static int rfc822_address();
/*static char *skip_rfc822_localpart();*/
static int blacklisted();
extern char *rfc821_error_ptr;
extern char *rfc821_error;

static const char *blacklist_err = "Blacklisted due to extensive mail delivery problems";


int
is_suspect_address(addr)
     char *addr;
{
  extern void *getpwnam(); /* Not really true, but we use it as a flag.. */

  while (*addr == ' ' || *addr == '\t') ++addr;

  if (getpwnam(addr) != NULL) return 0; /* LOCAL person!  Never suspect */

  return (rfc822_address(addr) || blacklisted(addr));
}


static int
rfc822_address(addr)
     char *addr;
{
  char *addr2;
  extern char *rfc821_path2();

  addr2 = rfc821_path2(addr,1);
  if (!addr2 || addr2 == addr) return 1;
  while (*addr2 == ' ' || *addr2 == '\t') ++addr2;
  if (*addr2 != 0) return 1;
  return 0;
}

struct BlackList {
	char *addr;	/* Address pattern */
	char *error;	/* Error report */
};

static struct BlackList *BlackList   = NULL;
static struct BlackList NoBlackList  = {NULL,NULL};

static int
blacklisted(addr)
     char *addr;
{
  FILE *blfile;
  int blindex = 0;
  int blsize = 8;
  int addrlen = strlen(addr);
  struct BlackList *BL;
  char linebuf[MAXPATHLEN];
  char *s;

  extern char *strrchr();
  extern int strcasecmp();
  extern int fclose();

  if (BlackList == &NoBlackList) return 0;
  if (BlackList == NULL) {

    blfile = fopen(_PATH_BLACKLISTFILE,"r");
    while (blfile && !ferror(blfile) && !feof(blfile)) {
      const char *error = blacklist_err;
      int linelen;
      *linebuf = 0;
      if (!fgets(linebuf,sizeof(linebuf)-1,blfile))
	break;
      s = strchr(linebuf,'\n');
      if (s) *s = 0;
      if (*linebuf == 0 || *linebuf == ';' || *linebuf == '#')
	continue;
      linelen = strlen(linebuf);
      s = strchr(linebuf,'\t');
      if (s) *s++ = 0;
      while (s && (*s == ' ' || *s == '\t')) ++s;
      if (s && *s != 0) error = s;
      if (!BlackList) {
	BlackList = (struct BlackList*) malloc(sizeof(struct BlackList)*(blsize+1));
	BlackList[0].addr = NULL;
      }
      if (blindex >= blsize) {
	blsize += 8;
	BlackList = (struct BlackList*) realloc(BlackList,sizeof(struct BlackList)*(blsize+1));
	BlackList[blindex].addr = NULL;
      }
      BlackList[blindex].addr = malloc(strlen(linebuf)+1);
      BlackList[blindex].error = malloc(strlen(error)+1);
      strcpy(BlackList[blindex].addr,linebuf);
      strcpy(BlackList[blindex].error,error);
      blindex++;
      BlackList[blindex].addr = NULL;
    }
    if (blfile)
      fclose(blfile);
    else {
      BlackList = &NoBlackList;
      return 0;
    }
  }

  /* Check blacklist! */
  BL = BlackList;
  s = strrchr(addr,'@');
  while (BL && BL->addr) {
    int bl_len = strlen(BL->addr);
    char *ss = addr+addrlen+1-bl_len-1;

    if (BL->addr[0] == '@' && s &&
	strcasecmp(BL->addr,s)==0) {
      rfc821_error_ptr = s;
      rfc821_error = BL->error;
      return 1;
    }
    if ((BL->addr[0] == '*')  &&  (addrlen > bl_len) &&
	(!isalnum(*ss))  &&  (strcasecmp(ss+1,(BL->addr)+1)==0)) {
	rfc821_error = BL->error;
	rfc821_error_ptr = ss+1;
	return 1;
    }

    if (strcasecmp(BL->addr,addr)==0) {
      rfc821_error = BL->error;
      rfc821_error_ptr = addr;
      return 1;
    }
    ++BL;
  }
  return 0;
}
