
typedef struct _cm_scope_t *cm_scope_t;
typedef	u_int cm_id_t;

typedef	void (*cm_free_t)(cm_id_t id, void *data);
typedef	void (*cm_changed_t)(cm_scope_t, cm_id_t *, size_t);

#define	CM_SCOPE_NULL	((cm_scope_t)0)

cm_scope_t cm_scope_create(const char *, cm_id_t, cm_free_t, cm_changed_t);
cm_scope_t cm_scope_create_sub(cm_scope_t, const char *, cm_changed_t);
void cm_scope_delete(cm_scope_t);
const char *cm_scope_get_name(cm_scope_t);
cm_scope_t cm_scope_get_parent(cm_scope_t);
void cm_scope_init(void);
void cm_scope_terminate(void);
int cm_var_is_set(cm_scope_t, cm_id_t);
void *cm_var_get(cm_scope_t, cm_id_t);
void cm_var_set(cm_scope_t, cm_id_t, void *);
void cm_var_unset(cm_scope_t, cm_id_t);
