/*
 * GateD Releases Unicast, Multicast, IPv6, RSd
 * 
 * Copyright (c) 1996,1997,1998,1999 
 * The Regents of the University of Michigan.
 * All Rights Reserved.
 * 
 * License to use, copy, modify, and distribute this software and its
 * documentation can be obtained from Merit Network, Inc. at the 
 * University of Michigan.
 * 
 * Merit GateD Consortium
 * Merit Network, Inc.
 * 4251 Plymouth Road, Suite C
 * Ann Arbor, MI 48105
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE FUNCTIONS 
 * CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR THAT 
 * OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for any special, 
 * indirect, incidental or consequential damages with respect to any claim 
 * by Licensee or any third party arising from use of the software. 
 * GateD was originated and developed through release 3.0 by Cornell 
 * University and its collaborators.
 * 
 * Please send questions or comments to gated-people@gated.org.
 *
 * Please submit bugs, bug fixes, and enhancements using the send-pr(1) 
 * utility or via the web at 
 * www.gated.org/gated-web/support/html/report_prob.html.
 * 
 * ------------------------------------------------------------------------
 *
 *      Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *          All rights reserved.
 *
 *      THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 *      EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 *      LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 *      AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *      GateD is based on Kirton's EGP, UC Berkeley's routing
 *      daemon   (routed), and DCN's HELLO routing Protocol.
 *      Development of GateD has been supported in part by the
 *      National Science Foundation.
 *
 * ------------------------------------------------------------------------
 *
 *      Portions of this software may fall under the following
 *      copyrights:
 *
 *      Copyright (c) 1988 Regents of the University of California.
 *      All rights reserved.
 *
 *      Redistribution and use in source and binary forms are
 *      permitted provided that the above copyright notice and
 *      this paragraph are duplicated in all such forms and that
 *      any documentation, advertising materials, and other
 *      materials related to such distribution and use
 *      acknowledge that the software was developed by the
 *      University of California, Berkeley.  The name of the
 *      University may not be used to endorse or promote
 *      products derived from this software without specific
 *      prior written permission.  THIS SOFTWARE IS PROVIDED
 *      ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 *      INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 *      MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * __END_OF_COPYRIGHT__
 */

#if defined(PROTO_MPBGP6)
#if !defined(__MPBGP6_PROTO_H__)
#define __MPBGP6_PROTO_H__
#include "inet6core/inet6.h"

/*
 * Put the next hop in a send packet
 */
#define SEND_PUT_NH_ADDR(addr, cp) \
	do { \
		sockaddr_un *Xsa; \
		byte *Xap; \
		int Xi, Xlen; \
		Xsa = (addr); \
		switch (socktype(Xsa)) { \
		case AF_INET: \
			Xap = (byte *)&(sock2ip(Xsa)); \
			Xlen = 4; \
			break; \
		case AF_INET6: \
			Xap = (byte *)&(sock2in6(Xsa)); \
			Xlen = 16; \
			break; \
		default: \
			/* XXX probably shouldn't assert in the real world */ \
			assert(FALSE); \
		} \
		for (Xi = 0; Xi < Xlen; Xi++) \
			*(cp)++ = *Xap++; \
	} while (0)
		

/*
 * The following macro extracts network addresses from the stream.  It
 * is used to decode the end of update messages, and understands that
 * network numbers are stored internally in network byte order.  It expects
 * the addr passed in to be initialized with the correct address family.
 */
#define BGP_GET_ADDR(addr, cp) \
	do { \
		sockaddr_un *Xsa; \
		byte *Xap; \
		int Xi, Xlen; \
		Xsa = (addr); \
		switch (socktype(Xsa)) { \
		case AF_INET: \
			Xap = (byte *)&(sock2ip(Xsa)); \
			Xlen = 4; \
			break; \
		case AF_INET6: \
			Xap = (byte *)&(sock2in6(Xsa)); \
			Xlen = 16; \
			break; \
		default: \
			/* Stop gcc warnings */ \
			Xap = NULL; \
			Xlen = 0; \
			/* XXX probably shouldn't assert in the real world */ \
			assert(FALSE); \
		} \
		for (Xi = 0; Xi < Xlen; Xi++) \
			*Xap++ = *(cp)++; \
	} while (0)

/*
 * These macros, the alternative to the above, extract BGP4-style
 * address prefixes from the stream.  The bit count is returned
 * by the first, the next couple are for testing (to see if the
 * bitcount is okay and there is space) and the remainder set the
 * address.     
 */

#define BGP_OKAY_BITCOUNT(bc, fam) \
	(((fam) == AF_INET) ? (bc) <= 32 : \
	    (((fam) == AF_INET6) ? (bc) <= 128 : FALSE))

#define BGP_GET_PREFIX(bitcount, addr, cp) \
	do { \
		sockaddr_un *Xsa; \
		byte *Xap; \
		int Xi, Xj, Xlen; \
		Xj = BGP_PREFIX_LEN(bitcount); \
		Xsa = (addr); \
		switch (socktype(Xsa)) { \
		case AF_INET: \
			Xap = (byte *)&(sock2ip(Xsa)); \
			Xlen = 4; \
			break; \
		case AF_INET6: \
			Xap = (byte *)&(sock2in6(Xsa)); \
			Xlen = 16; \
			break; \
		default: \
			/* Stop gcc warnings */ \
			Xap = NULL; \
			Xlen = 0; \
			/* XXX probably shouldn't assert in the real world */ \
			assert(FALSE); \
		} \
		for (Xi = 0; Xi < Xlen; Xi++) \
			if (Xi < Xj) \
				*Xap++ = *(cp)++; \
			else \
				*Xap++ = 0; \
	} while (0)

/*
 * The following puts a network address into the buffer in the form a BGP
 * update message would like.  We know the address is in network byte order
 * already.
 */
#define BGP_PUT_ADDR(addr, cp) \
	do { \
		sockaddr_un *Xsa; \
		byte *Xap; \
		int Xi, Xlen; \
		Xsa = (addr); \
		switch (socktype(Xsa)) { \
		case AF_INET: \
			Xlen = 4; \
			Xap = (byte *)&(sock2ip(Xsa)); \
			break; \
		case AF_INET6: \
			Xlen = 16; \
			Xap = (byte *)&(sock2in6(Xsa)); \
			break; \
		default: \
			/* XXX Asserting here may be appropriate */ \
			assert(FALSE); \
		} \
		for (Xi = 0; Xi < Xlen; Xi++) \
			*(cp)++ = *Xap++; \
	} while (0)

#define BGP_PUT_PREFIX(bitcount, addr, cp) \
	do { \
		sockaddr_un *Xsa; \
		byte *Xap; \
		int Xi; \
		byte Xbc; \
		Xbc = (byte)(bitcount); \
		Xsa = (addr); \
		switch (socktype(Xsa)) { \
		case AF_INET: \
			Xap = (byte *)&(sock2ip(Xsa)); \
			break; \
		case AF_INET6: \
			Xap = (byte *)&(sock2in6(Xsa)); \
			break; \
		default: \
			/* XXX Asserting here may be appropriate */ \
			assert(FALSE); \
		} \
		*(cp)++ = Xbc; \
		for (Xi = ((bitcount) + 7) >> 3; Xi; Xi--)  \
			*(cp)++ = *Xap++; \
	} while (0)

#endif /* !defined(__MPBGP6_PROTO_H__) */
#endif /* defined(PROTO_MPBGP6) */
