/*
 * Public Release 3
 * 
 * $Id: dvmrp_targets.h,v 1.3.2.2 1998/10/20 19:29:31 swright Exp $
 *
 *  Authors:
 *	Jeffrey C Honig <jch@nr-atp.cit.cornell.edu>
 *	Tom Pusateri <pusateri@netedge.com>
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997, 1998 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP and UC Berkeley's routing
 * daemon	 (routed).
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


/* Target definitions. */

#define	TDF_HOLDDOWN	0x8000	/* This entry is in holddown */
#define	TDF_POISON	0x4000	/* This entry is in poison reverse */
#define	TDF_CHANGED	0x2000	/* This entry is changed */

#define	target_set_holddown(tdp, count) { \
	 (tdp)->td_flags = TDF_HOLDDOWN|TDF_CHANGED; \
	 (tdp)->td_metric = (count); \
     }

#define	target_set_poison(tdp, count) { \
	 (tdp)->td_flags = TDF_POISON|TDF_CHANGED; \
	 (tdp)->td_metric = (count); \
     }

#define	target_set_metric(tdp, metric) { \
	 (tdp)->td_flags = TDF_CHANGED; \
	 (tdp)->td_metric = (metric); \
     }

#define	DVMRP_TD_CLEANUP(tlp, tdp) \
	{ \
	    dvmrp_td_delete(tlp, tdp); \
	    task_block_free(dvmrp_td_block_index, (void_t)tdp);\
	}

#define DVMRP_TD_NOMASK     0xffffffff


#define	TARGETF_BROADCAST	0x01		/* This is a broadcast address */
#define	TARGETF_SOURCE		0x02		/* This is a P2P client */
#define	TARGETF_SUPPLY		0x04		/* We supply updates to this client */
#define	TARGETF_ALLINTF		0x08		/* We want to see all interfaces */
#define	TARGETF_POLICY		0x10		/* Initial policy has been run */

#define	TARGETF_USER4		0x1000
#define	TARGETF_USER3		0x2000
#define	TARGETF_USER2		0x4000
#define	TARGETF_USER1		0x8000		/* For protocol use */


#define	TARGET_LIST(tlp, list) \
	{ \
	    for ((tlp) = (list)->target_forw; (tlp) != (list); (tlp) = (tlp)->target_forw)
#define	TARGET_LIST_END(tlp, list) \
	    if ((tlp) == (list)) { \
		tlp = (dvmrp_target *) 0; \
	    } \
	}

PROTOTYPE(dvmrp_target_locate,
	  extern dvmrp_target *,
	  (dvmrp_target *,
	   if_addr *,
	   gw_entry *));
PROTOTYPE(dvmrp_target_free_list,
	  extern void,
	  (task *,
	   dvmrp_target *));
PROTOTYPE(dvmrp_target_build,
	  extern int,
	  (task *,
	   dvmrp_target *y,
	   gw_entry *,
	   flag_t,
	   _PROTOTYPE(dump,
		      void,
		      (FILE *,
		       rt_head *,
		       void_t,
		       const char *))));
PROTOTYPE(dvmrp_target_dump,
	  extern void,
	  (FILE *,
	   dvmrp_target *,
	   const bits *));
