/*
 * Public Release 3
 * 
 * $Id: isis_globals.c,v 1.3.2.2 1998/10/20 19:30:01 swright Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997, 1998 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP and UC Berkeley's routing
 * daemon	 (routed).
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * ------------------------------------------------------------------------
 * 
 * 	Copyright 1991 D.L.S. Associates
 * 
 * 	Permission to use, copy, modify, distribute, and sell this software
 * 	and its documentation for any purpose is hereby granted without
 * 	fee, provided that the above copyright notice appear in all copies
 * 	and that both that copyright notice and this permission notice
 * 	appear in supporting documentation, and that the name of D.L.S. not
 * 	be used in advertising or publicity pertaining to distribution of
 * 	the software without specific, written prior permission.  D.L.S.
 * 	makes no representations about the suitability of this software for
 * 	any purpose.  It is provided "as is" without express or implied
 * 	warranty.
 * 
 * 	D.L.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * 	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * 	NO EVENT SHALL D.L.S.  BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * 	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * 	OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * 	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * 	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * 	Authors:  Robert Hagens and Dan Schuh
 * 
 * 
 */


#define EXTERN 

#include "include.h"
#include "isis_includes.h"

char areaAddr[] = { 11, 0x47, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, /* res */
	0x01, 0x01 /* RD */};

/*
 *	these multicast addrs may not work on any 802.5 networks
 *	that have MSb first transmission order
 */
static MACAddress	l1is[] = {0x01, 0x80, 0xc2, 0x00, 0x00, 0x14};
static MACAddress	l2is[] = {0x01, 0x80, 0xc2, 0x00, 0x00, 0x15};
static MACAddress	is[] = {0x09, 0x00, 0x2b, 0x00, 0x00, 0x05};
static MACAddress	es[] = {0x09, 0x00, 0x2b, 0x00, 0x00, 0x04};

/*
 *	define 'addr' as an area addr for this router
 *
 *	ASSUMES THE FIRST BYTE OF ADDR IS THE LENGTH IN BYTES!
 */
void
setAreaAddr __PF1(addr, u_char *)
{
	int i;
	AreaAddr *AA;

	for (i=0; i<systemAreaAddrs.count; i++) {
		AA = retrieveAreaAddr(systemAreaAddrs.areaAddr[i]);
		if ((AA) && (AA->len == *addr) && equalID(addr+1, AA->addr, *addr)) {
			/* we have a match */
			return;
		}
	}

	if (systemAreaAddrs.count == MaximumAreaAddresses) {
		trace_log_tf(isis_trace_options,
			     0,
			     LOG_ERR,
			     ("Maximum Area Addresses exceeded (%d), ignoring ...", 
			      MaximumAreaAddresses));
		return;
	}
	systemAreaAddrs.areaAddr[systemAreaAddrs.count++] = storeAreaAddr(addr);
}

GlobalCounters  isisCounters;

void
initGlobals __PF1(isis_initial_config, int)
{
	if (isis_initial_config) {
		copyID(l1is, AllL1ISmac, 6);
		copyID(l2is, AllL2ISmac, 6);
		copyID(es, AllESmac, 6);
        	bzero((caddr_t) &isisCounters, sizeof(isisCounters));
		/* 	setIPSystemID(gethostid(), systemID);*/
		/* 
		if (systemID[0] == 0)
			sprintf((char *) systemID, "%d", getpid());
		*/
		if (systemType == Unknown)
			systemType = L1IS;
        	origL1LSPBufSize = origL2LSPBufSize = dataLinkBlocksize = 1492;
		sysHoldingTimer = 20;			/* adj hold time */
        	sysISHInterval = 10;
        	sysIIHInterval = 3;
        	sysDRIIHInterval = 1;
        	sysPollESHelloRate = 50;                /* seconds */
        	sysDefaultESHelloTimer = 600;   	/* seconds */
		minLSPGenInterval = 30;			/* min between LSP generations */
		maxLSPGenInterval = 900;		/* max between LSP generations */
		minLSPXmitInterval = 2;			/* min between LSP propagations (from given source) */
		minBLSPXmitInterval = 5;		/* same, but on broadcast circuits */
		BLSPThrottle = 50;			/* packets */
		maximumAge = 1200;			/* of LSP */
		completeSNPInterval = 10;		/* complete SNP xmit time for broadcast media */
		partialSNPInterval = 2;			/* seconds */
		zeroAgeLifetime = 60;			/* expired LSP header retain time after flood */
        	waitingTime = 60;			/* time to stay in overload state */
		dumpDBinterval = 30;			/* seconds */
        	routingModuleState = ModuleUp;
	}

	/* DTS 12-8-90 check if any of the above have been reset by parser */
	isis_check_parms();

	if (isis_initial_config) {
		runL1spf = runL2spf = 0;
		LSPInit();	/* STEVE XXX - check interaction with updateAreaSummary (may need work for reconfig) */
		setTimer(dumpDBinterval, dumpDB);
		/*
	 	 * Start timers to age things.
	 	 */
		setTimer(1, ageListAge, NULL);
	}
}
