/*
 * Public Release 3
 * 
 * $Id: isis_globals.h,v 1.3.2.2 1998/10/20 19:30:02 swright Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997, 1998 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP and UC Berkeley's routing
 * daemon	 (routed).
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * ------------------------------------------------------------------------
 * 
 * 	Copyright 1991 D.L.S. Associates
 * 
 * 	Permission to use, copy, modify, distribute, and sell this software
 * 	and its documentation for any purpose is hereby granted without
 * 	fee, provided that the above copyright notice appear in all copies
 * 	and that both that copyright notice and this permission notice
 * 	appear in supporting documentation, and that the name of D.L.S. not
 * 	be used in advertising or publicity pertaining to distribution of
 * 	the software without specific, written prior permission.  D.L.S.
 * 	makes no representations about the suitability of this software for
 * 	any purpose.  It is provided "as is" without express or implied
 * 	warranty.
 * 
 * 	D.L.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * 	INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * 	NO EVENT SHALL D.L.S.  BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * 	CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * 	OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * 	NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * 	CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * 	Authors:  Robert Hagens and Dan Schuh
 * 
 * 
 */


#ifndef _globals_h
#define _globals_h

#include "isis.h"

#ifndef EXTERN
#define EXTERN extern
#endif

EXTERN  RoutingModuleState              routingModuleState;

/*
 *	The ID of this intermediate system 
 */
EXTERN SystemID6		systemID;

/*
 *	The area addresses configured for this system
 */
EXTERN AreaAddrList	systemAreaAddrs;

/*
 *	Maximum size of L1 and L2 LSPs and SNPs originated by this
 *	system.
 */
EXTERN u_short 	origL1LSPBufSize;
EXTERN u_short 	origL2LSPBufSize;
EXTERN u_short	dataLinkBlocksize;	/* TODO: on per circuit ? */

/*
 *	Type of system. Should only have value L1IS or L2IS
 */
EXTERN SystemType	systemType;

/*
 *	Holding timer (in seconds)
 */
EXTERN u_short	sysHoldingTimer;

/*
 *	Rate (in seconds) for transmitting ISH and IIH pdus
 */
EXTERN u_short  sysISHInterval;                 /* system wide default */
EXTERN u_short  sysIIHInterval;                 /* system wide default */
EXTERN u_short  sysDRIIHInterval;               /* for designated router */
EXTERN u_short  sysPollESHelloRate;
EXTERN u_short  sysDefaultESHelloTimer;

/*
 *	Parameters which control the flooding and generation of LSPs
 */
EXTERN u_short	minLSPGenInterval;		/* min time between generations of an LSP */
EXTERN u_short	maxLSPGenInterval;		/* max time between generations of an LSP */
EXTERN u_short	minBLSPXmitInterval;	/* transmission on broadcast circuit */
EXTERN u_short	minLSPXmitInterval;		/* transmission on pt 2 pt circuit */
EXTERN u_short	BLSPThrottle;			/* max # of LSPs to xmit per circuit
										   per minBLSPXmitInterval */
EXTERN u_short	maximumAge;				/* number of seconds fore LSP expired*/
EXTERN u_short	completeSNPInterval;
EXTERN u_short	partialSNPInterval;
EXTERN u_short	zeroAgeLifetime;
EXTERN u_short  waitingTime;                    /* time to stay in overload state */

#define	minBroadcastLSPXmitInterval	33 /* milliseconds */

/*
 *	The list of circuits configured into the system
 */
EXTERN CircuitEntry	*circuitList[MaximumCircuits];

/*
 *	Logging device
 */
EXTERN Logger debugLog;
EXTERN int		dumpDBinterval;

/*
 *	LSPs for this system
 */
LSPGroup	*L1LSP, *L2LSP;
AgeList		*normalLSPAge, *deletedLSPAge;

/*
 *	Multicast addresses
 */
EXTERN MACAddress	AllL1ISmac, AllL2ISmac, AllESmac;

/*
 * Our task (whatever it is at the time).
 */
EXTERN task *isis_task;

/*
 * Our tracing options.
 */
EXTERN trace *isis_trace_options;
EXTERN const bits isis_trace_types[];

/* 
 * Preferences for gated (L1 higher preference than L2).
 */
EXTERN pref_t isis_preference[3];

/* 
 * Mode of operation (set by parser).
 */
EXTERN int ip_supported;
EXTERN int clnp_supported;

/*
 * Import and export policy (set by parser).
 */
EXTERN adv_entry *isis_import_list_ip;
EXTERN adv_entry *isis_import_list_iso;
EXTERN adv_entry *isis_export_list_ip;
EXTERN adv_entry *isis_export_list_iso;

/*
 * Flags set by reception of LSPs.
 */
EXTERN int runL1spf;
EXTERN int runL2spf;
EXTERN int adjustPrefsOnly;

#endif /* _globals_h */
