/*
 * Public Release 3
 * 
 * $Id: krt_symbols_ioctl.c,v 1.3.2.2 1998/10/20 19:30:48 swright Exp $
 */

/*
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1996, 1997, 1998 The Regents of the University of Michigan
 * All Rights Reserved
 *  
 * Royalty-free licenses to redistribute GateD Release
 * 3 in whole or in part may be obtained by writing to:
 * 
 * 	Merit GateDaemon Project
 * 	4251 Plymouth Road, Suite C
 * 	Ann Arbor, MI 48105
 *  
 * THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE REGENTS OF THE
 * UNIVERSITY OF MICHIGAN AND MERIT DO NOT WARRANT THAT THE
 * FUNCTIONS CONTAINED IN THE SOFTWARE WILL MEET LICENSEE'S REQUIREMENTS OR
 * THAT OPERATION WILL BE UNINTERRUPTED OR ERROR FREE. The Regents of the
 * University of Michigan and Merit shall not be liable for
 * any special, indirect, incidental or consequential damages with respect
 * to any claim by Licensee or any third party arising from use of the
 * software. GateDaemon was originated and developed through release 3.0
 * by Cornell University and its collaborators.
 * 
 * Please forward bug fixes, enhancements and questions to the
 * gated mailing list: gated-people@gated.merit.edu.
 * 
 * ------------------------------------------------------------------------
 * 
 * Copyright (c) 1990,1991,1992,1993,1994,1995 by Cornell University.
 *     All rights reserved.
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 * LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * GateD is based on Kirton's EGP and UC Berkeley's routing
 * daemon	 (routed).
 * Development of GateD has been supported in part by the
 * National Science Foundation.
 * 
 * ------------------------------------------------------------------------
 * 
 * Portions of this software may fall under the following
 * copyrights:
 * 
 * Copyright (c) 1988 Regents of the University of California.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms are
 * permitted provided that the above copyright notice and
 * this paragraph are duplicated in all such forms and that
 * any documentation, advertising materials, and other
 * materials related to such distribution and use
 * acknowledge that the software was developed by the
 * University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote
 * products derived from this software without specific
 * prior written permission.  THIS SOFTWARE IS PROVIDED
 * ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


#define       INCLUDE_UDP
#define       INCLUDE_UDP_VAR
#define       INCLUDE_KVM
#include "include.h"
#ifdef        PROTO_INET
#include "inet.h"
#endif        /* PROTO_INET */
#include "krt.h"
struct __kvm {
    int kvm_fd;
    const char *kvm_nl;
    const char *kvm_core;
    const char *kvm_swap;
    char kvm_errmsg[BUFSIZ];
};
#include "krt_var.h"
#include <sys/ksym.h>

int
krt_symbols __PF1(tp, task *)
{
    char buf[BUFSIZ];
    struct mioc_rksym rks;

    rks.mirk_symname = KSYM_VERSION;
    rks.mirk_buf = buf;
    rks.mirk_buflen = sizeof(buf);
    if (ioctl(kd->kvm_fd, MIOC_READKSYM, &rks) < 0) {
      trace_log_tp(tp,
                   0,
                   LOG_INFO,
                   ("krt_symbols: mioc(KSYM_VERSION): %m"));
    } else {
      /* Set version */

      krt_version_kernel = task_mem_strdup(tp, buf);
      trace_tp(tp,
               TR_KRT_SYMBOLS,
               0,
               ("krt_symbols: kernel version: %s\n",
                krt_version_kernel));
    }

#ifdef        PROTO_INET
    rks.mirk_symname = KSYM_IPFORWARDING;
    rks.mirk_buf = buf;
    rks.mirk_buflen = sizeof(int);
    if (ioctl(kd->kvm_fd, MIOC_READKSYM, &rks) < 0) {
      trace_log_tp(tp,
                   0,
                   LOG_INFO,
                   ("krt_symbols: mioc(KSYM_IPFORWARDING): %m"));
    } else {
      inet_ipforwarding = *(int *)buf;
      trace_tp(tp,
               TR_KRT_SYMBOLS,
               0,
               ("krt_symbols: IP forwarding: %u\n",
                inet_ipforwarding));
    }

    rks.mirk_symname = KSYM_UDPCKSUM;
    rks.mirk_buf = buf;
    rks.mirk_buflen = sizeof(int);
    if (ioctl(kd->kvm_fd, MIOC_READKSYM, &rks) < 0) {
      trace_log_tp(tp,
                   0,
                   LOG_INFO,
                   ("krt_symbols: mioc(KSYM_UDPCKSUM): %m"));
    } else {
      inet_udpcksum = *(int *)buf;
      trace_tp(tp,
               TR_KRT_SYMBOLS,
               0,
               ("krt_symbols: UDP checksum: %u\n",
                inet_udpcksum));
    }
#endif        /* PROTO_INET */
    
    trace_tp(tp,
           TR_KRT_SYMBOLS,
           0,
           (NULL));

    return 0;
}

