#define finnish
#include <stdio.h>
#include <sys/types.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/timeb.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/dir.h>
#include <sys/ioctl.h>
#include <sys/signal.h>

#define bool int
#define NULLS ((char *) 0)

#define HELPDIR "/usr/share/help"
#define INFODIR "/usr/share/info"
#define LOGFILE "/var/log/.helplog"
#define INFOUID       42
#define SLEEPTIME      5
#define LOGINMAX     600		/* 10 minutes idle */
#define	MAXNAMES     256		/* maximum number of subtopics */
#define MAXMATCHES    24
#define MAXDEPTH      20
#define	MAXPATHLEN   256
#define	MAXNAMELEN   300
#define	MAXLINELEN   128
#define MAXTERMWIDTH 300
#define DEFTERMWIDTH  78
#define DEFTERMHEIGHT 24
#define	STACKSIZE  10000
#define COLUMNSPACE    3
#define HELPEXT      ".HLP"		/* help file extension */
#define MANEXT       ".MAN"		/* manual file extension */
#define LISTEXT      ".LIST"		/* namelist file extension */
#define VIEWPROGRAM  "/usr/ucb/more"    /* program to look at help */
#define VIEWPROGOPTS1 "-sd"
#define VIEWPROGOPTS2 "-18"
#define MANPROGRAM    "/usr/local/lib/man"  /* program to look at man */
#define INFOPROGRAM   "/usr/local/lib/minimore"  /* program to look at info */
#define INFOPROGOPTS  "-s"
#define INFOMANPROGRAM "/usr/local/lib/miniman"  /* program to look at man */

#ifdef finnish
#  define prompt		"Aihe:"
#  define topiclist		"Aiheet:"
#  define subtopics		"Alaotsikot:"
#  define next_subtopic		"Aihe:"
#  define want_to_read		"Haluatko lukea? [kes]"
#  define ynq_advice		"  Vastaa\n    k jos haluat lukea seuraavaa avainsanaa vastaavan tekstin,\n    e jos et halua,\n    s jos haluat lopettaa selaamisen.\n"
#  define help_not_found	"%s: hakemisto hukassa!.\n"
#  define sorry			"%s --- Ei oo tietoo.\n"
#  define subsorry		"Ei tietoa aiheesta"
#else
#  define prompt		"Topic:"
#  define topiclist		"Topics:"
#  define subtopics		"Subtopics:"
#  define next_subtopic		"Next subtopic:"
#  define want_to_read		"Read it? [ynq]"
#  define ynq_advice		"  Answer y to get next subtopic, n to skip, q to quit.\n"
#  define help_not_found	"%s: help directory not found.\n"
#  define sorry			"Sorry, no help text for %s.\n"
#  define subsorry		"Sorry, no help text for"
#endif

struct tchars  *init_tchars = NULL;
struct tchars  *here_tchars = NULL;

#define Set_Tc_Init(FD) \
        ((init_tchars==NULL)?(0):(ioctl(FD,TIOCSETC,init_tchars)))
#define Set_Tc_Here(FD) \
        ((here_tchars==NULL)?(0):(ioctl(FD,TIOCSETC,here_tchars)))
#define iswhite(_c)       (_c ==' ' || _c =='	' || _c =='\n' || _c =='\r')
