#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/timeb.h>
#include "help.h"
#define MAXMATCHES	24

/* talcott!seismo!wucs!nz (Neal Ziring)
    Mod.sources: Volume 6, Issue 45
    Archive-name: help/Part1 */

 /* ************************************************************
  * 			H   E   L   P    !!
  *		     =========================
  *
  * 	This program emulates the VMS help facility in the UNIX
  *  environment.  The main routine HELP1 looks up help and 
  *  subtopics for help.  The help texts for various topix 
  *  are tree-structured.  A directory is defined as a "help"
  *  directory, it has four types of files in it:
  *		main help text: 	.both
  *		manual page name:	.man
  *		subtopic texts:		<topicname>.both
  *		subtopic directories:	<topicname>
  *
  *	Subtopic names must start with an alphanumeric
  *  character.  Preferably all subtopics will start with
  *  lowercase letters.
  *
  *	The routine help1 is recursive, it descends the	tree
  *  structure.
  */

void logout(n)
int n;
 {
    exit(0);
 }

 /* **************************************************************
  * printhelp: given a string, pop .both on the end and do more(1).
  *
  *	This routine sends a help file to more(1).  A string
  *  is passed in, which is the name of a help.  If the string
  *  is nil, then just use the name .both.
  *	The return value is -1 if no help file is accessible, 
  *  0 if the more(1) command was called okay with fkoff();
  */

  printhelp(hs, path)
  	char *hs;
  {
	char filename[MAXNAMELEN], comm[MAXNAMELEN + 20];

	if (hs == NULL) strcpy(filename,HELPEX);
	else if (strlen(hs) < 1) strcpy(filename, HELPEX);
	else {
		strcpy(filename, hs);
		strcat(filename,HELPEX);
	}

	if ( access(filename, R_OK) < 0 ) {
		printf(sorry,
			(hs==NULL)?this_topic:hs );
		return(-1);
	}

	if (info_user)
	     fkoff(INFOPROGRAM,filename,NULL,NULL,NULL);
	else fkoff(VIEWPROGRAM,VIEWPROGOPTS1,VIEWPROGOPTS2,filename,NULL);

	return(0);
  }

/* *************************************************************
 * matchtopix: find the topics available in this directory
 *
 *	This routine does a directory of help options.
 *  All filenames which start with anything other than numbers 
 *  or letters are not kept.  Extensions are stripped off.
 *	
 *	The number of subtopics found is returned, along with
 *  a pointer to a null-terminated vector of string pointers.
 */

int matchtopix(topix)
 	char *topix[];
  {
	int i,j,k,l = 0;
	int  namewidth, totalnames;
	char *malloc(), *nbuf;
	char *thisname, *index();
	char *s1, *s2, **nxtname, *nxcnt;
	struct direct *readdir(), *filedat;
	DIR *dirp, *opendir();

	nbuf = malloc( MAXNAMES * MAXNAMELEN );
	nxcnt=nbuf;
	dirp = opendir(".");
	if (dirp == NULL) {
		fprintf(stderr,cannot_open_dir,progname);
		return(-1);
	}

	for(nxtname=topix, i=0; i < (MAXNAMES-1) ; ) {
		filedat = readdir(dirp);
		if (filedat == NULL) break;
		thisname = filedat->d_name;
		if ( !(isalnum(*thisname)) )    /* if not in [0-9A-Za-z] */
				continue;	/* do the next one.      */
		*nxcnt = '\0';
		if ( (s1 = index(thisname,'.')) != NULL) {
			if (strcmp(s1, HELPEX) == 0)
				*s1 = '\0';
			else if ( strcmp(s1, MANEX) == 0) continue;
		}
		if (strlen(thisname) >= MAXNAMELEN - 1)
			*(thisname+MAXNAMELEN-1) = '\0';
		/* copy in data from this loop */
		if (*nxcnt == '\0') strcpy(nxcnt,thisname);
		else strcat(nxcnt,thisname);
		*nxtname++ = nxcnt; 
		/* update pointers for next loop */
		nxcnt += (strlen(thisname) + 1);
		i++;
	}
	*nxtname++ = NULL;
	totalnames = i;
	closedir(dirp);

	if (totalnames == 0) return(0);
	
	/* sort the names in ascending order with exchange algorithm */
	for(i=0; i < totalnames-1; i++)
		for(j=i+1; j <totalnames; j++)
			if (strcmp(topix[i],topix[j]) > 0) {
				thisname = topix[i];
				topix[i] = topix[j];
				topix[j] = thisname;
			}
	return(totalnames);
  }


/* *************************************************************
 * counttopix: compute the number of topics in the list	
 */

int counttopix(topix)
 	char *topix[];
  {
	int i = 0;
	char **nxtname;
	for(nxtname=topix, i=0; *nxtname++ != NULL; i++ );
	return i;
  }

/* *************************************************************
 * printtopix: print the topics available in this directory
 *		in a nice format.
 *
 *  This routine prints a list of help options out in a manner
 *  similar to that of ls(1).  All filenames which start with
 *  anything other than numbers or letters are not kept.
 *  Extensions are stripped off.
 *	
 *	The number of subtopics found is returned, along with
 *  a pointer to a null-terminated vector of string pointers.
 */

int printtopix(topix)
 	char *topix[];
  {
	int totalnames;
	totalnames = counttopix(topix);
	if (col_flag) printf(subtopics);
	printlist(topix, totalnames);
	return(totalnames);
  }

manpage(ppt,topix,s2)
    char *ppt;
    char *topix[];
    char *s2;
 {
	int i,k;
	char *mx[MAXMATCHES];
	char cmdbuf[90];
	if ( *s2 == '\0' ) {
		mx[0] = "";  mx[1] = NULL; k = 1;
	}
	else if ( (k = matchv( s2, topix, mx)) == 0 ) {
	   printf(no_topics_match,s2);
	}
	for( i=0; i < k; i++ ) {
		strcpy(cmdbuf,mx[i]);
		strcat(cmdbuf,MANEX);
		if (access(cmdbuf, R_OK|X_OK ) < 0) {
		        strcpy(cmdbuf,mx[i]);
			strcat(cmdbuf,MAN_SUBEX);
			if (access(cmdbuf,R_OK|X_OK) < 0) {
			    printf(sorry_no_manual,
			      (strlen(s2)==0)?ppt:mx[i]);
			    continue;
			}
		}
		if (mx[2] != NULL) {
		    k = takeit(next_man_page,mx[i]);
		    if (k ==  1) continue;
		    if (k == -1) break; }
		printf(doing,cmdbuf);
		fkoff(SHELLPROG,SHELLOPTS,cmdbuf,NULL);
			/* source contents of .man file */
	}
 }

 /* ****************************************************************
  * help1comp: descend recursive help tree and provide some
  *	     user services.
  *
  *	This routine is the heart of the new UNIX help facility.
  *  It climbs recursively around an n-tree of documentation files
  *  and directories.  The routine printhelp() outputs a file of
  *  help text, the routine printtopix prints out all subtopics.
  *
  *	This routine can operate in interactive mode, or not.  The
  *  basic cycle of operation is:
  *		print help
  *		print list
  *		print prompt and do commands.
  *		return.
  *
  *	There are a number of commands available in the
  *  interactive mode, they are:
  *
  *		blank line:	up recursive level.
  *		subtopic name:	recurse to subtopic.
  *		?:		list topics again.
  *		^D:		quit help program.
  *		#		list topics again
  *		
  */

  help1comp(ppt,svec,skip,comp_flag)
  	char *ppt;
	char *svec[];
	short  skip;
	short  comp_flag;  /* non-zero if doing completions */
  {
	int i,j,k, err;
	int no_subs;
	char answer[MAXLINELEN];
	char fullpath[MAXNAMELEN + 29];
	char *topix[MAXNAMES], *mx[MAXMATCHES];
	int  matchv();
	char *index();
	char *s1, *s2, *s3, *rest;
	char *wvec[MAXMATCHES];

	matchtopix(topix);
	if ( (k = matchv( *svec, topix, mx)) == 0) return(-1);
	/* if there is more than one match, and we are not at end, flub */
	if ( svec[1] != NULL  &&  k > 1 ) return(-1);
	/* if we are not at end, go down one level */
	if ( svec[1] != NULL ) {
	    if ( chdir( mx[0] ) < 0) return(-1);
	    else {
	        k = help1comp(ppt, svec+1, 0, comp_flag);
	        chdir("..");
	        return(k);
	    }
	}
	/* if we are at end, then do appropriate action on comp_flag */
	else {
	    strcpy(gbl_match, mx[0]);
	    if ( comp_flag == CTRLD_COMP ) {
		puts("\n");
		printlist(mx,k);
	    }
	}
	return(0);
  }

 /* ****************************************************************
  * help1: descend recursive help tree and provide some
  *	     user services.
  *
  *	This routine is the heart of the new UNIX help facility.
  *  It climbs recursively around an n-tree of documentation files
  *  and directories.  The routine printhelp() outputs a file of
  *  help text, the routine printtopix prints out all subtopics.
  *
  *	This routine can operate in interactive mode, or not.  The
  *  basic cycle of operation is:
  *		print help
  *		print list
  *		print prompt and do commands.
  *		return.
  *
  *	There are a number of commands available in the
  *  interactive mode, they are:
  *
  *		blank line:	up recursive level.
  *		subtopic name:	recurse to subtopic.
  *		?:		list topics again.
  *		^D:		quit help program.
  *		#		list topics again
  *		
  */

  help1(ppt,svec,skip)
  	char *ppt;
	char *svec[];
	short  skip;
  {                             /* this routine is too big, eh? */
	int i,j,k, err;
	int no_subs;
	char answer[MAXLINELEN];
	char fullpath[MAXNAMELEN + 29];
	char *topix[MAXNAMES], *mx[MAXMATCHES];
	int  matchv();
	char *index();
	char *s1, *s2, *s3, *rest;
	char *wvec[MAXMATCHES];

	if ( svec != NULL  && *svec != NULL) {
	    matchtopix(topix);
	    if ( (k = matchv(*svec, topix, mx)) == 0) {
		printf(sorry_no_path,ppt,*svec);
		if (strlen(ppt) == 0) help1(ppt,NULL,1);
		return(-1);
	    }

	    for(i = 0, j = 0, err = -1; mx[i] != NULL; ) {
		if (mx[2] != NULL) {
		    j = takeit(next_path,ppt,mx[i]);
		    if (j == 1) { i++; continue; }
		    if (j < 0)  break; }
		strcpy(fullpath,ppt);
		strcat(fullpath," ");
		strcat(fullpath,mx[i]);

		if ( chdir(mx[i]) < 0) {
		    if ( *(svec + 1) != NULL ) {
			i++;
			continue;
		    }
		    printhelp( mx[i],fullpath);
		    printf("\n");
		    help1(ppt,NULL,1);
		    err = 0;
		}
		else {
		    if ( help1(fullpath,(svec+1),0) >= 0) {
			err = 0;
			chdir("..");
			printf("\n");
			help1(ppt,NULL,1);
		    }
		    else chdir("..");
		}
		i++;
	    }
	    return(err);
	}

	if (!skip) 
	    if (printhelp(NULL, ppt) < 0) {
		puts("\n");
		return(-1);
	    }

	if (( access(MANEX, R_OK) >= 0) && !skip)
		printf(manual_available);

	if (skip)
	    no_subs = (matchtopix(topix) < 0);
	else if (! (no_subs = matchtopix(topix) < 0)) {
	    printtopix(topix);
	    puts("\n"); }

	while (1) {

		/* now, prompt and wait for user response */

		if ( strlen(ppt) < 1 ) sprintf(gbl_ppt,top_prompt);
		else		 sprintf(gbl_ppt,sub_prompt,ppt);
		fputs(gbl_ppt,stdout);
#ifndef BSD
		if ( fgets(answer, MAXLINELEN-1, stdin) == NULL ) {
		    puts("\n");
		    exit(1);
		}
#else
		if (read_gets(stdin->_file, answer, MAXLINELEN - 1, 1) < 0) {
		    puts("\n");
		    exit(1);
		}
#endif

		/* first remove any leading blanks or tabs */
		for(s1=answer; *s1 == ' ' || *s1 == '	'; s1++);

		/* chop off all of answer after first word. */
		s2 = index(s1,' ');
		if (s2 == NULL)  s2 = index(s1,'	');
		if (s2 == NULL)  s2 = index(s1,'\n');
		if (s2)
		  { *s2 = '\0'; rest = ++s2; }
		else {
		    rest = s2 = s1 + strlen(s1);
		}
		makewvec(rest,wvec,MAXMATCHES);

		if ( strlen(s1) == 0 )		/*  on blank line, */
			break;			/* pop up one level*/

		switch (*s1) {
		    case '?':
			if (!no_subs)
			    printtopix(topix);
			else printf(sorry_no_subtopics);
			break;

	    	    case '.':			/* .: do manpage if any */
		    	s2 = s1 + 1;
			if (no_subs) {
				printf(sorry_no_subtopics);
		    		break;
			}
			manpage(ppt,mx,s2);
			break;

		    default:			/* must be a topic spec */
		        if ( no_subs )  {
				printf(sorry_no_subtopics);
		    		break;
			}
			if ( (k = matchv( s1, topix, mx)) == 0 ) {
			   printf(no_direct_help,s1);
			   break;	/* leave switch */
			}

			/* step thru sub-topics that match src */
		        for(i=0; i < k; i++) {
			    s3 = mx[i];

			    if (mx[2] != NULL) {
				j=takeit(next_subtopic,ppt,s3);
				if (j ==  1) continue;
				if (j == -1) break; }

			    if ( chdir(s3) >= 0 ) {  /* directory  subtopic */
			    	strcpy(fullpath,ppt);
			    	strcat(fullpath," ");
			    	strcat(fullpath,s3);
			    	help1(fullpath,wvec,0);	/* recurse */
				if ( strcmp(getwd(newdir),helpdir) )
					chdir("..");
			    }			/* else text subtopic */
			    else  {
				strcpy(fullpath, ppt);
				strcat(fullpath, " ");
				strcat(fullpath, s3);
				printhelp(s3, fullpath);
				puts("\n");
			    }
			}

		}	/* end of switch */

	}	/* end of while(1) */

	if (!no_subs && (*topix != NULL) ) free( *topix );

	return(0);

  }	/* end of help1 */

/* ****************************************************************
 * takeit: ask user whether to take next topic, return t or f
 *
 *	This routine takes a message, with format, and asks the 
 *  user whether he wants to do the action, not do the action,
 *  or quit the cycle of actions.
 *	y - return  0
 *	n - return  1
 *	k - return  0
 *	e - return  1
 *	q - return -1
 *	? - tell what y, n, and q do.
 *     <CR> - carriage return
 *
 *	Naturally, case is insignificant.
 */

 takeit(fmt,m1,m2,m3)
   char *fmt, *m1, *m2, *m3;
 {

	char ans[40];
	int  done, ret;
	char *fgets();

	for(done = 0; !done; ) {
		if (fmt != NULL) printf(fmt, m1, m2, m3);
		printf(" [ynkeq] ");
		if (fgets(ans, 39, stdin) == NULL) exit(1);  /* abort */
		isupper(*ans)?(*ans=tolower(*ans)):0;
		if (*ans == 'n' || *ans == 'e') {
			done = 1;
			ret = 1;
		}
		else if (*ans == 'y' || *ans == 'k' || *ans == '\n') {
			done = 1;
			ret = 0;
		}
		else if (*ans == 'q') {
			done = 1;
			ret = -1;
		}
		else printf(ynq_advice);
	}
	return(ret);
 }

 /* ***************************************************************
  * matchv: return all matches of a string in a vector.
  *
  *	This routine accepts a string and a vector of strings. 
  *  The string is supposed to be an abbreviation of one or more
  *  strings in the vector.  The full versions of the strings are
  *  placed in a another vector (which is in a static area) and
  *  a pointer to that vector returned.  Note that the input
  *  vector of pointers must have NULL as its terminating element.
  *  The output vector will also terminate with NULL.
  *	NOTE: The vector returned contains pointers into the input
  *  vector.  Do not, therefore, mess with the contents of the output
  *  vector.
  *
  *  If NULL is returned, nothing matched, or there was some other
  *  error.
  */

  matchv( src, vec, mx)
    char *src;
    char *vec[];
    char *mx[];
  {
	char *m[MAXMATCHES];
	char  *s1, *s2;
	int i,j, slen;

	if ( (slen = strlen(src)) == 0 ) return(NULL);  

	for(i=0, j=0; vec[i] != NULL && j < MAXMATCHES; i++) {
	    if  ( strcmp(src,vec[i]) == 0 ) {   /* exact match! */
		m[0] = vec[i];  j = 1;
		break;
	    }
	    else if ( strncmp(src,vec[i],slen) == 0   && 
		     strlen(vec[i]) >= slen )
		   		m[j++] = vec[i];
	}
	m[j] = NULL;
	for(i=0; i <= j; mx[i] = m[i], i++);
	return(j);
  }

 /* *****************************************************************
  * fkoff: fork a process and return the exit status of the process.
  *
  *    This routine takes a command line separated into words, and
  *  uses vfork(2) and execve(2) to quickly run the program.
  *
  *  This is a simplified version of the fkoff() routine from dcon(8).
  *  Here, a program name and up to four arguments may be passed in.
  *  If one of them is null, FINE, but the fifth 
  *
  */

  fkoff(prg,arg1,arg2,arg3,arg4)
    char *prg, *arg1, *arg2, *arg3, *arg4;

  {
	char *command, *malloc(), *argvec[6];
	int pid, stat, i;

	for(i=0; i < 6; argvec[i++] = NULL);
	argvec[0] = prg;
	argvec[1] = arg1;
	argvec[2] = arg2;
	argvec[3] = arg3;
	argvec[4] = arg4;
	if (argvec[0] == NULL) return(-1);
	command = malloc( strlen(argvec[0]) + 1);
	strcpy(command,argvec[0]);

	Set_Tc_Init( (stdin->_file) ) ;
#ifdef USG
	pid = fork();
#else
	pid = vfork();    /* fork 2 copies of us */
#endif
	if (pid < 0 )  {
	        fflush(stdout);
		perror("help: fork");
		Set_Tc_Here( (stdin->_file) ) ; 
		return(0);
	}
	else if (pid == 0)  { /* we are child, execve the program. */
   		pid = execve(command,argvec,environ);
		_exit(1);   
	}
	else {          /* we are parent, wait for child */
		pid = wait(&stat);
		Set_Tc_Here( (stdin->_file) ) ;
		if (pid == -1) return(pid);
		stat = stat / 0400;   /* get hi byte of status */
		return(stat);
        }
  }

/* **************************************************************
 * makewvec: make a vector of words, up to N of them
 *
 *    This routine uses index to simply parse a string
 *  made up of (possibly) several blank-separated words.
 *  The words are stored into the slots of a vector, as pointers
 *  into the original string.  Therefore, the original string
 *  is destroyed.
 */
 makewvec(sstr, rvec, veccnt)
     char *sstr;
     char *rvec[];
     int veccnt;
  {
    int mcnt = 0;
    int done = 0;
    int i,j;
    char *s1, *s2, *index();

    if (strlen(sstr) == 0) {
	rvec[0] = NULL;
    }
    else {
	/* skip leading whitespace */
	for(s1=sstr; iswhite(*s1); s1++);
	for(mcnt = 0, done = 0; !done; mcnt++) {
	    s2 = index(s1,' ');
	    if (s2 == NULL) s2 = index(s1,'	');
	    if (s2 == NULL) s2 = index(s1,'\n');
	    if (s2 != NULL) *s2 = '\0';
	    rvec[mcnt] = s1;
	    if (mcnt + 1 >= veccnt) break;
	    if (s2 == NULL) done = 1;
	    else {
		/* skip more white space */
		for(s1 = s2+1; iswhite(*s1); s1++);
		if (*s1 == '\0') done = 1;
	    }
	}
	rvec[mcnt] = NULL;
    }

    return(mcnt);
  }

/* **************************************************************
 * printlist - print a list of strings in columnar or list form
 *
 *     This routine takes a list of names in a vector and prints
 *   the list according to the current help mode.  This code
 *   used to be in printtopix() but I decided to move it here
 *   so it could be used for other things.
 */
printlist(vec,namecnt)
     char *vec[];
     int namecnt;
  {
    int i,j,k;
    int longlen, namewidth, rowcnt, colcnt;
    char *s1, *s2;
    static char row[TERMWID+1];

	longlen = 0;
	for(i=0; i < namecnt; i++ ) {
	    longlen = ((k=strlen(vec[i]))>longlen)?k:longlen;
	}

	/* here print the names out in nice columns */
	namewidth = longlen + COLUMNSPACE;
	rowcnt = TERMWID / namewidth;
	colcnt = (namecnt + (rowcnt-1)) / rowcnt ;
	if (colcnt <= 0) colcnt = 1;

	if (col_flag && rowcnt >= 1) {
	        printf("\n");
		for(i=0; i < colcnt ; i++ ) {
			for(k=0; k < TERMWID; row[k++] = ' ');
			row[k] = '\0';
			for(j=0, s1 = row; 
		    	    (i+j) < namecnt; 
		    	    j += colcnt) {
				row[strlen(row)] = ' ';
				strcpy(s1,vec[i+j]);
				s1 = s1 + namewidth;
			}
			printf("    %s\n",row);
		}
	}
	else {
		for(i=0; i < namecnt; i++)
			printf("%s\n",vec[i]);
 	}
 
  }

#ifdef BSD

/* ****************  funky keyboard stuff below here  ************* */

/* **************************************************************
 * pushback - push a string back onto the tty input queue
 *
 *     This routine accepts a string and pushes it onto the tty
 *   input queue, as if the user had typed it.
 *   The input is a file descriptor that points to a tty, and
 *   a pointer to the string.
 */
pushback(fd, str)
     int fd;
     char *str;
  {
    char *s1;

    for(s1=str; *s1; ioctl( fd, TIOCSTI, s1++));
  }

/* **************************************************************
 * getpending - get pending chars from tty, then push them back
 *
 *     This routine grabs chars pending on a specified file
 *   descriptor, puts them into the specified buffer, and pushes
 *   them back onto the tty input queue.
 *   The buffer passed by the caller had BETTER be long enough,
 *   or everything gets munched.
 *   If the parameter no_pushback is non-zero, the characters are
 *   not pushed back.
 *   The number of characters obtained is returned.
 */
getpending(fd, buf, buflen, no_pushback)
     int fd;
     char *buf;
     int buflen, no_pushback;
  {
    int i,j;
    char x = '\n';

    ioctl(fd, FIONREAD, &i);
    if (i <= 0) return(0);
    j = read(fd, buf, buflen);
    buf[j-1] = '\0';
    for(i = j-2; buf[i] > '\030' ; buf[i--] = '\0' );
    if (i <= 0) return(0);
    if ( !no_pushback) pushback(fd, buf);
    return(i);
  }

/* **************************************************************
 * init_funky - initialize funky stuff, and save startup values
 *
 *         This routine starts up breaking for ESC, and
 *   saves the initial tchars structure.
 */
init_funky()
  {
    char *malloc();

    if ( isatty(0) ) {
	is_tty = 1;
	init_tchars = (struct tchars *) malloc( sizeof(struct tchars));
	here_tchars = (struct tchars *) malloc( sizeof(struct tchars));
	ioctl(0,TIOCGETC,init_tchars);
	ioctl(0,TIOCGETC,here_tchars);
	here_tchars->t_brkc = '\033';
	ioctl(0,TIOCSETC,here_tchars);
    }
    
    return;
  }

/* **************************************************************
 * read_gets: do a gets by read(2)ing a line
 *
 *       Read a string into a buffer, from the given file
 *    descriptor.  There are four arguments:
 *
 *		fd	file descriptor (usually 0)  
 *  		buf     char * to buffer
 * 		blen    buffer length in bytes
 *		spec	do special ^[ and ^D processing
 *
 *    If the special processing is enabled, ESC invokes helpname
 *    completion, and ^D invokes possible completion listing.
 *    When the user finally inputs a line that does not require
 *    special processing, it is returned as a string to caller.
 *    If anything goes wrong, or a true EOF is given, -1 is
 *    returned.
 *    When special processing is not enabled, the input line is 
 *    simply returned to the caller as a string.
 */
read_gets(fd, buf, blen, do_special)
     int fd, blen, do_special;
     char *buf;
  {
    char *s1, *s2, endc;
    static  char bufcopy[MAXLINELEN];
    static  char *wvec[MAXMATCHES];
    int i,j,k;

    for(endc = '\0'; endc != LF ; ) {
	fflush(stdout);
	i = read(fd, buf, blen);

	/* now, having read data, analyze it for special stuff */
	if (i <= 0) return(-1);
	else {
	    s1 = buf + (i - 1);
	    if (*s1 == ESC || *s1 == LF || *s1 == RET) {
		endc = (*s1 == ESC)?(*s1):(LF);
		*s1 = '\0';
	    }
	    else {
		*++s1 = '\0';
		endc = *s1;
	    }
	    for(s1 = buf + (strlen(buf) - 1);
		*s1 == ' '  ||   *s1 == '	';
		*s1-- = '\0');
	    for(s1 = buf; *s1 == ' ' || *s1 == '	'; s1++);

	    if (endc == LF || endc == RET || do_special == 0) return(i-1);
	    else {
		*gbl_match = '\0';

		/* if this is a non-topic command, just beep */
		if ( index( SPEC_CHARS, *s1) ) {
		    fputs("  ",stdout);
		    for(s1 = buf; *s1; s1++) fputs("",stdout);
		    fflush(stdout);
		    pushback(stdin->_file,buf);
		    continue;
		}
		else
		/* do special stuff here */
		if (endc == ESC) {
		    strcpy(bufcopy,buf);
		    i = makewvec(bufcopy, wvec, MAXMATCHES);
		    help1comp("", wvec, 0, ESC_COMP);
		    fputs("  ",stdout);
		    for(s1 = buf; *s1; s1++) fputs("",stdout);
		    fflush(stdout);
		    pushback(stdin->_file,buf);
		    if ( *gbl_match ) {
			pushback(stdin->_file,(gbl_match + strlen(wvec[i-1])));
		    }
		    else fputs("",stdout);
		    fflush(stdout);
		}
		else
		  if (endc == '\0') {   /* must have been eof */
		      strcpy(bufcopy,buf);
		      i = makewvec(bufcopy, wvec, MAXMATCHES);
		      help1comp("" , wvec, 0, CTRLD_COMP);
		      printf("\n%s ",gbl_ppt);
		      if (*gbl_match == '\0') fputs("", stdout);
		      fflush(stdout);
		      pushback(stdin->_file,buf);

		  }
	    }
	}
    }
  }
		
#endif 

main(argc, argv)
  	int argc;
	char *argv[];
  {
	int i,j,k;
		
	strcpy(progname,argv[0]);
	helpdir = NULL;
	getwd(olddir);
	col_flag  = 1;
	info_user = (getuid() == INFOUID);
	argc--;
	argv++;
	if (helpdir == NULL) helpdir = (info_user ? INFODIR : HELPDIR);
	if (chdir(helpdir) < 0) {
		fprintf(stderr,help_not_found,progname,helpdir);
		exit(1);
	}

#ifdef BSD
	init_funky();
#endif
	if (info_user) {
	    int p;
	    p = fork();
	    if (p > 0) {
		time_t t;
		struct stat ttystat;
		signal(SIGCHLD,logout);
		while (1) {
		    sleep(SLEEPTIME);
		    time(&t);
		    fstat(fileno(stdin),&ttystat);
		    if (ttystat.st_atime < t - LOGINMAX) logout(); }}}
	if (argc >= 1) {		/* treat vector as a help path */
#ifdef DEBUG
	    fprintf(stderr," help path vector, argc=%d, *argv=%s.\n",
		    argc,*argv);
#endif
	    help1( "", argv, 0);

	}
	else	help1( "", NULL, 0);

	exit(0);
 }
