	/*
         *	help.h: header file for the VMS-help emulator
	 */

#include <stdio.h>
#include <ctype.h>
#define finnish
#define BSD
/* #define USG */
#ifdef USG
#include <sys/types.h>
#endif
#include <sys/file.h>
#include <sys/param.h>
#include <sys/dir.h>
#ifdef BSD
#include <sys/ioctl.h>
#include <sys/signal.h>
#endif

#define iswhite(_c)       (_c ==' ' || _c =='	' || _c =='\n' || _c =='\r')
#define HELPEX	".HLP"				/* help & info extension */
#define	MANEX	".MAN"				/* manual filename*/
#define MAN_SUBEX "/.MAN"                       /* other man filename */
#define INFOHEAD "file "
#define INFOTAIL " | sed 's/^/     /'"
#define SLEEPTIME 60
#define LOGINMAX 120

#define LF '\n'
#define RET '\r'
#define ESC '\033'

#define INFOUID		 42
#define	MAXLINELEN	128
#define	MAXNAMELEN	 24		/* max length of NAME of topix */
#define	MAXNAMES	256		/* maximum number of subtopics */
#define COLUMNSPACE	  3
#define TERMWID		 78
#define HELPDIR "/usr/share/help"
#define INFODIR "/usr/share/info"
#define VIEWPROGRAM  "/usr/ucb/more"    /* program to look at text */
#define VIEWPROGOPTS1 "-d"
#define VIEWPROGOPTS2 "-18"
#define INFOPROGRAM  "/usr/bin/cat"     /* program to look at info */
#define SHELLPROG    "/bin/sh"		/* program to execute text */
#define SHELLOPTS    "-c"

char 	progname[MAXNAMELEN];
char	olddir[MAXNAMELEN + 68];
char	newdir[MAXNAMELEN + 68];
char	*helpdir;
char	**environ;	/* environment, for forks */
char    gbl_ppt[MAXLINELEN];

int	dumb_flag;
int	list_flag;
int	col_flag;
int	frst_flag;

#ifdef BSD
struct tchars  *init_tchars = NULL;
struct tchars  *here_tchars = NULL;

#define Set_Tc_Init(FD) \
        ((init_tchars==NULL)?(0):(ioctl(FD,TIOCSETC,init_tchars)))
#define Set_Tc_Here(FD) \
        ((here_tchars==NULL)?(0):(ioctl(FD,TIOCSETC,here_tchars)))

int info_user = 0;
int is_tty = 0;
char *read_resp();

#define ESC_COMP       1
#define CTRLD_COMP    -1
#define SPEC_CHARS  ".$?*#"

char gbl_match[MAXNAMELEN];

#else
#define Set_Tc_Init  1
#define Set_Tc_Here  0
#endif

#ifdef finnish
#  define top_prompt		"Valitse aihe: "
#  define sub_prompt		"Valitse aihe: %s "
#  define help_not_found	"%s: %s: help-hakemisto hukassa!.\n"
#  define sorry			"\n%s --- Ei oo tietoo.\n"
#  define this_topic		""
#  define cannot_open_dir	"%s: Ei aukene mulle.\n"
#  define subtopics		"Aiheet:\n"
#  define sorry_no_path		" valitan, ei polkua aiheeseen '%s %s'\n"
#  define next_path		" Seuraava polku: %s %s\nKokeillaanko?"
#  define manual_available	"\n	Manuaali ON olemassa.\n"
#  define sorry_no_subtopics	"\n Valitan, ei tarkempia tietoja.\n\n"
#  define no_topics_match	"\n Valitan, ei tietoa avainsanasta '%s'\n"
#  define sorry_no_manual	"\n Valitan, ei manuaalia aiheesta '%s'.\n\n"
#  define next_man_page		" Seuraava manuaalisivu: %s.\n Katsotaanko? "
#  define doing			" ...muotoillaan %s\n\n"
#  define no_direct_help	"Ei tietoa aiheesta '%s' t{ll{ tasolla\n"
#  define next_subtopic		"Aihe: %s %s  -  Haluatko lukea?"
#  define ynq_advice		"  Vastaa\n    k jos haluat lukea seuraavaa avainsanaa vastaavan tekstin,\n    e jos et halua,\n    q jos haluat lopettaa selaamisen.\n"
#  define next_cross_ref	"\Seuraava viittaus '%s %s: %s'\nKatsotaanko?"
#  define cross_ref_inaccessible	" Valitan, viitetiedostoa '%s' ei voi lukea.\n"
#  define cross_ref_available	" Viittaus \"%s\" olisi tarjolla\n"
#  define cross_ref_empty	" Valitan, viitetiedostossa '%s' ei ole informaatiota!\n\n"
#  define following_cross_ref	"\n following cross-reference 'help"
#  define to_find_help		"' to find help for %s\n\n"
#else
#  define top_prompt		"Topic: "
#  define sub_prompt		"Topic: %s "
#  define help_not_found	"%s: %s: help directory not found.\n"
#  define sorry			"\n Sorry, no help text for %s.\n"
#  define this_topic		"this topic"
#  define cannot_open_dir	"%s: Cannot open help directory.\n"
#  define subtopics		"Subtopics:\n"
#  define sorry_no_path		" sorry, no direct help path to %s %s\n"
#  define next_path		" Next help path: %s %s\nTry it?"
#  define manual_available	"\n	Manual page IS available.\n"
#  define sorry_no_subtopics	"\n Sorry, no subtopics.\n\n"
#  define no_topics_match	"\n Sorry, no topics match %s\n"
#  define sorry_no_manual	"\n Sorry, no manual reference available for %s.\n\n"
#  define next_man_page		" Next man page: %s.\n Take it? "
#  define doing			" ...doing %s\n\n"
#  define no_direct_help	"Sorry, no direct help for  %s\n"
#  define next_subtopic		"Next %s subtopic: %s\nTake it?"
#  define ynq_advice		"  Answer y to get next subtopic, n to skip, q to quit.\n"
#  define next_cross_ref	"Next %s %s cross-reference: %s\nTake it?"
#  define cross_ref_inaccessible	" Sorry, %s cross-reference file inaccessible.\n"
#  define cross_ref_available	" Cross reference text called \"%s\" is available\n"
#  define cross_ref_empty	" Sorry, cross-ref file %s seems to be empty!\n\n"
#  define following_cross_ref	"\n following cross-reference `help"
#  define to_find_help		"' to find help for %s\n\n"
#endif
