/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ExpressionImage;
import gnu.jel.OP;
import gnu.jel.OP_function;
import gnu.jel.OP_load;
import gnu.jel.OP_param;
import gnu.jel.OPlist;
import gnu.jel.Optimizer;
import gnu.jel.debug.Debug;

class OP_binary
extends OP_function {
    int opc = 999;
    boolean logical = false;

    OP_binary() {
    }

    boolean canInterpret() {
        return this.operandsReady(2, false);
    }

    void compile(ExpressionImage ei) {
        if (this.logical) {
            ei.asm_logical_binary(this.opc);
        } else {
            ei.asm_binary(this.opc);
        }
    }

    void interpret(OPlist list) throws Throwable {
        if (this.logical) {
            OP_load c2 = (OP_load)this.prev.prev;
            OP_load c1 = (OP_load)this.prev.prev.prev.prev;
            boolean b1 = (Boolean)c1.what;
            boolean b2 = (Boolean)c2.what;
            switch (this.opc) {
                case 0: {
                    b1 &= b2;
                    break;
                }
                case 1: {
                    b1 |= b2;
                    break;
                }
                default: {
                    Debug.println("Wrong logical bitwise operation (" + this.opc + ").");
                }
            }
            c1.what = b1 ? Boolean.TRUE : Boolean.FALSE;
            this.consume(list, c1, 2, false);
            return;
        }
        OP_load c2 = (OP_load)this.prev.prev;
        OP_load c1 = (OP_load)this.prev.prev.prev.prev;
        if (this.opc == 0 && c1.type == Optimizer.string_class) {
            c1.what = String.valueOf((String)c1.what) + String.valueOf(c2.what);
        } else {
            Debug.assert(c1.type != null && c1.type == c2.type && c2.type.isPrimitive(), "Wrong types for binary OP");
            int id = ExpressionImage.primitiveID(c1.type);
            Number n1 = OP_function.widen(c1.what, id);
            Number n2 = OP_function.widen(c2.what, id);
            boolean boolres = false;
            boolean resbool = false;
            if (OP_function.isFloat(id)) {
                double d1 = n1.doubleValue();
                double d2 = n2.doubleValue();
                boolean wrop = false;
                switch (this.opc) {
                    case 0: {
                        d1 += d2;
                        break;
                    }
                    case 1: {
                        d1 -= d2;
                        break;
                    }
                    case 2: {
                        d1 *= d2;
                        break;
                    }
                    case 3: {
                        d1 /= d2;
                        break;
                    }
                    case 4: {
                        d1 %= d2;
                        break;
                    }
                    case 5: {
                        wrop = true;
                        break;
                    }
                    case 6: {
                        wrop = true;
                        break;
                    }
                    case 7: {
                        wrop = true;
                        break;
                    }
                    case 8: {
                        boolres = true;
                        resbool = d1 == d2;
                        break;
                    }
                    case 9: {
                        boolres = true;
                        resbool = d1 != d2;
                        break;
                    }
                    case 10: {
                        boolres = true;
                        resbool = d1 < d2;
                        break;
                    }
                    case 11: {
                        boolres = true;
                        resbool = d1 >= d2;
                        break;
                    }
                    case 12: {
                        boolres = true;
                        resbool = d1 > d2;
                        break;
                    }
                    case 13: {
                        boolres = true;
                        resbool = d1 <= d2;
                        break;
                    }
                    default: {
                        wrop = true;
                    }
                }
                if (wrop) {
                    Debug.println("Wrong operation on float (" + this.opc + ").");
                }
                n1 = !boolres ? (Number)new Double(d1) : (Number)(resbool ? new Long(1L) : new Long(0L));
            } else {
                long l1 = n1.longValue();
                long l2 = n2.longValue();
                switch (this.opc) {
                    case 0: {
                        l1 += l2;
                        break;
                    }
                    case 1: {
                        l1 -= l2;
                        break;
                    }
                    case 2: {
                        l1 *= l2;
                        break;
                    }
                    case 3: {
                        l1 /= l2;
                        break;
                    }
                    case 4: {
                        l1 %= l2;
                        break;
                    }
                    case 5: {
                        l1 &= l2;
                        break;
                    }
                    case 6: {
                        l1 |= l2;
                        break;
                    }
                    case 7: {
                        l1 ^= l2;
                        break;
                    }
                    case 8: {
                        boolres = true;
                        l1 = l1 == l2 ? 1L : 0L;
                        break;
                    }
                    case 9: {
                        boolres = true;
                        l1 = l1 != l2 ? 1L : 0L;
                        break;
                    }
                    case 10: {
                        boolres = true;
                        l1 = l1 < l2 ? 1L : 0L;
                        break;
                    }
                    case 11: {
                        boolres = true;
                        l1 = l1 >= l2 ? 1L : 0L;
                        break;
                    }
                    case 12: {
                        boolres = true;
                        l1 = l1 > l2 ? 1L : 0L;
                        break;
                    }
                    case 13: {
                        boolres = true;
                        l1 = l1 <= l2 ? 1L : 0L;
                        break;
                    }
                    case 14: {
                        l1 <<= (int)l2;
                        break;
                    }
                    case 15: {
                        l1 >>= (int)l2;
                        break;
                    }
                    case 16: {
                        if (id == 4) {
                            l1 = (int)l1 >>> (int)l2;
                            break;
                        }
                        l1 >>>= (int)l2;
                        break;
                    }
                    default: {
                        Debug.println("Wrong operation on integer (" + this.opc + ").");
                    }
                }
                n1 = new Long(l1);
            }
            if (boolres) {
                c1.what = OP_function.narrow(n1, 0);
                c1.type = Boolean.TYPE;
            } else {
                c1.what = OP_function.narrow(n1, id);
            }
        }
        this.consume(list, c1, 2, false);
    }

    void setOperation(OPlist list, int opc, boolean logical, Class type) {
        this.logical = logical;
        this.opc = opc;
        if (type != Optimizer.string_class) {
            int cpar = 2;
            OP cop = this.prev;
            while (cop != null && cpar >= 0) {
                OP_param copp;
                if (cop instanceof OP_param && (copp = (OP_param)cop).getFunction() == this) {
                    copp.setConvert(list, type);
                }
                cop = cop.prev;
            }
        }
    }

    public String toString() {
        if (this.logical) {
            return ExpressionImage.logicalSymbols[this.opc];
        }
        return ExpressionImage.binarySymbols[this.opc];
    }
}

