/* LocaleInformation_eu.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_eu extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "ESP";

  private static final String currenciesDisplayNameValues = "ESP";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "ESP";

  private static final String currenciesSymbolValues = "\u20a7";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "urt",
    "ots",
    "mar",
    "api",
    "mai",
    "eka",
    "uzt",
    "abu",
    "ira",
    "urr",
    "aza",
    "abe",
    null,
  };

  private static final String[] months = {
    "urtarrila",
    "otsaila",
    "martxoa",
    "apirila",
    "maiatza",
    "ekaina",
    "uztaila",
    "abuztua",
    "iraila",
    "urria",
    "azaroa",
    "abendua",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "ig",
    "al",
    "as",
    "az",
    "og",
    "or",
    "lr",
  };

  private static final String[] weekdays = {
    null,
    "igandea",
    "astelehena",
    "asteartea",
    "asteazkena",
    "osteguna",
    "ostirala",
    "larunbata",
  };

  private static final String territoriesKeys = "TD|GW|AQ|MZ|MY|MX|GR|ZA|MV|GQ|SZ|MU|SY|GN|AG|AF|ST|AE|SR|SP|MK|MH|SL|MG|SK|SI|MD|MC|SG|MA|SE|SC|SB|LY|FR|LV|LU|LT|RW|FM|RU|FI|RO|LC|LB|ET|ES|KR|KP|KN|KM|EH|EG|KH|EC|KG|KE|DZ|QA|PY|DO|DM|JP|DK|JO|DJ|JM|DE|PL|PH|PG|CZ|CY|CV|CU|VC|VA|IT|CO|IS|CN|CM|IQ|CL|UY|CI|CH|CG|CF|US|CA|IE|BY|BS|BR|UA|NZ|HU|BO|HR|TT|NO|BE|TR|NL|BA|NI|TJ|TH";

  private static final String territoriesValues = "Txad|Ginea-Bissau|Antartika|Mozambike|Malasia|Mexiko|Grezia|Hegoafrika|Maldivak|Ekuatore Ginea|Swazilandia|Maurizio|Siria|Ginea|Antigua eta Barbuda|Afganistan|Sao Tom\u00e9 eta Principe|Arabiar Emirrerri Batuak|Surinam|Serbia|Mazedonia|Marshall uharteak|Sierra Leona|Madagaskar|Eslovakia|Eslovenia|Moldavia|Monako|Singapur|Maroko|Suedia|Seychelleak|Salomon uharteak|Libia|Frantzia|Letonia|Luxenburgo|Lituania|Ruanda|Mikronesia|Errusia|Finlandia|Errumania|Santa Luzia|Libano|Etiopia|Espainia|Hego Korea|Ipar Korea|Saint Kitts eta Nevis|Komoreak|Mendebaldeko Sahara|Egipto|Kanbodia|Ekuador|Kirgizistan|Kenia|Aljeria|Katar|Paraguai|Dominikar Errepublika|Dominika|Japonia|Danimarka|Jordania|Djibuti|Jamaika|Alemania|Polonia|Filipinak|Papua Ginea Berria|Txekiar errepublika|Zipre|Cabo Verde|Kuba|Saint Vincent eta Grenadinak|Vatikano|Italia|Kolonbia|Islandia|Txina|Kamerun|Irak|Txile|Uruguai|Boli Kosta|Suitza|Kongo|Afrika Erdiko Errepublika|Ameriketako Estatu Batuak|Kanada|Irlanda|Bielorrusia|Bahamak|Brasil|Ukraina|Zeelanda Berria|Hungaria|Bolibia|Kroazia|Trinidad eta Tobago|Norvegia|Belgika|Turkia|Herbehereak|Bosnia-Herzegovina|Nikaragua|Tadjikistan|Tailandia";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "eu";

  private static final String languagesValues = "euskara";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
