$! vmstest.com -- DCL script to perform test/Makefile actions for VMS
$!
$! Usage:
$!  $ set default [-.test]
$!  $ @[-.vms]vmstest.com bigtest
$! This assumes that newly built gawk.exe is in the next directory up.
$!
$	echo	= "write sys$output"
$	cmp	= "diff/Output=_NL:/Maximum=1"
$	rm	= "delete/noConfirm/noLog"
$	gawk = "$sys$disk:[-]gawk"
$	AWKPATH_srcdir = "define/User AWKPATH sys$disk:[]"
$
$	if p1.eqs."" then  p1 = "bigtest"
$	gosub 'p1'
$	if p2.nes."" then  gosub 'p2'
$	if p3.nes."" then  gosub 'p3'
$	if p4.nes."" then  gosub 'p4'
$	if p5.nes."" then  gosub 'p5'
$	if p6.nes."" then  gosub 'p6'
$	if p7.nes."" then  gosub 'p7'
$	if p8.nes."" then  gosub 'p8'
$	exit
$
$all:
$bigtest:	bigtest_list = "basic unix_tests gawk_ext"
$		echo "bigtest"
$bigtest_loop:	bigtest_test = f$element(0," ",bigtest_list)
$		bigtest_list = bigtest_list - bigtest_test - " "
$		if bigtest_test.nes." " then  gosub 'bigtest_test'
$		if bigtest_list.nes.""	then  goto   bigtest_loop
$		return
$
$basic:		basic_list = "msg swaplns messages argarray longwrds" -
		  + " getline fstabplus compare arrayref rs fsrs rand" -
		  + " fsbs negexp asgext anchgsub splitargv awkpath nfset" -
		  + " reparse convfmt arrayparm paramdup nonl defref" -
		  + " nofmtch litoct resplit rswhite prmarscl sclforin" -
		  + " sclifin intprec childin noeffect numsubstr pcntplus" -
		  + " prmreuse math fldchg fldchgnf reindops sprintfc" -
		  + " backgsub tweakfld clsflnam mmap8k fnarray dynlj" -
		  + " substr eofsplit prt1eval splitwht back89 tradanch"
$		echo "basic"
$basic_loop:	basic_test = f$element(0," ",basic_list)
$		basic_list = basic_list - basic_test - " "
$		if basic_test.nes." " then  gosub 'basic_test'
$		if basic_list.nes.""  then  goto   basic_loop
$		return
$
$unix_tests:	unix_tst_list = "poundbang fflush getlnhd"
$		echo "unix_tests"
$unix_tst_loop: unix_tst_test = f$element(0," ",unix_tst_list)
$		unix_tst_list = unix_tst_list - unix_tst_test - " "
$		if unix_tst_test.nes." " then  gosub 'unix_tst_test'
$		if unix_tst_list.nes.""  then  goto   unix_tst_loop
$		return
$
$gawk_ext:	gawk_ext_list = "fieldwdth ignrcase posix manyfiles" -
		  + " igncfs argtest badargs strftime gensub gnureops"
$		echo "gawk_ext (gawk.extensions)"
$gawk_ext_loop: gawk_ext_test = f$element(0," ",gawk_ext_list)
$		gawk_ext_list = gawk_ext_list - gawk_ext_test - " "
$		if gawk_ext_test.nes." " then  gosub 'gawk_ext_test'
$		if gawk_ext_list.nes.""  then  goto   gawk_ext_loop
$		return
$
$extra:		extra_list = "regtest inftest"
$		echo "extra"
$		gosub "regtest"
$		gosub "inftest"
$		return
$
$poundbang:
$	echo "poundbang:  useless for VMS, so skipped"
$	return
$
$msg:
$	echo "Any output from ""DIFF"" is bad news, although some differences"
$	echo "in floating point values are probably benign -- in particular,"
$	echo "some systems may omit a leading zero and the floating point"
$	echo "precision may lead to slightly different output in a few cases."
$	return
$
$swaplns:	echo "swaplns"
$	gawk -f swaplns.awk swaplns.in >tmp.
$	cmp swaplns.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$messages:	echo "messages"
$	set noOn
$	gawk -f messages.awk > out2 >& out3
$	cmp out1.ok out1.
$	if $status then  rm out1.;
$	cmp out2.ok out2.
$	if $status then  rm out2.;
$	cmp out3.ok out3.
$	if $status then  rm out3.;
$	set On
$	return
$
$argarray:	echo "argarray"
$	define/User TEST "test"			!this is useless...
$	gawk -f argarray.awk ./argarray.in - >tmp.
just a test
$	cmp argarray.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$fstabplus:	echo "fstabplus"
$	gawk -f fstabplus.awk >tmp.
1		2
$	cmp fstabplus.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$fsrs:		echo "fsrs"
$	gawk -f fsrs.awk fsrs.in >tmp.
$	cmp fsrs.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$igncfs:	echo "igncfs"
$	gawk -f igncfs.awk igncfs.in >tmp.
$	cmp igncfs.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$longwrds:	echo "longwrds"
$	gawk -f longwrds.awk manpage >tmp.too
$	sort tmp.too tmp.
$	cmp longwrds.ok tmp.
$	if $status then  rm tmp.;,tmp.too;
$	return
$
$fieldwdth:	echo "fieldwdth"
$	gawk -v "FIELDWIDTHS=2 3 4" "{ print $2}" >tmp.
123456789
$	cmp fieldwdth.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$ignrcase:	echo "ignrcase"
$	gawk -v "IGNORECASE=1" "{ sub(/y/, """"); print}" >tmp.
xYz
$	cmp ignrcase.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$regtest:
$  if f$search("regtest.com").eqs.""
$  then echo "regtest:  not available"
$  else echo "regtest"
$	echo "Some of the output from regtest is very system specific, do not"
$	echo "be distressed if your output differs from that distributed."
$	echo "Manual inspection is called for."
$	@regtest.com
$ endif
$	return
$
$posix: echo "posix"
$	gawk -f posix.awk >tmp.
1:2,3 4
$	cmp posix.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$manyfiles:	echo "manyfiles"
$	if f$search("[.junk]*.*").nes."" then  rm [.junk]*.*;*
$	if f$parse("[.junk]").eqs."" then  create/Dir/Prot=(O:rwed) [.junk]
$	gawk "BEGIN { for (i = 1; i <= 300; i++) print i, i}" >tmp.
$	echo "This may take quite a while..."
$	echo ""
$	gawk -f manyfiles.awk tmp. tmp.
$	define/User sys$error _NL:
$	define/User sys$output tmp.too
$	search/Match=Nor/Output=_NL:/Log [.junk]*.* ""
$!/Log output: "%SEARCH-S-NOMATCH, <filename> - <#> records" plus 1 line summary
$	gawk "$4!=2{++count}; END{if(NR!=301||count!=1){print ""Failed!""}}" tmp.too
$	rm tmp.;,tmp.too;,[.junk]*.*;*,[]junk.dir;
$	return
$
$compare:	echo "compare"
$	gawk -f compare.awk 0 1 compare.in >tmp.
$	cmp compare.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$arrayref:	echo "arrayref"
$	gawk -f arrayref.awk >tmp.
$	cmp arrayref.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$rs:		echo "rs"
$	gawk -v "RS=" "{ print $1, $2}" rs.in >tmp.
$	cmp rs.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$fsbs:		echo "fsbs"
$	gawk -v "FS=\" "{ print $1, $2 }" fsbs.in >tmp.
$	cmp fsbs.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$inftest:	echo "inftest"
$     !!  echo "This test is very machine specific..."
$	gawk -f inftest.awk >tmp.
$     !!  cmp inftest.ok tmp.		!just care that gawk doesn't crash...
$	if $status then  rm tmp.;
$	return
$
$getline:	echo "getline"
$	gawk -f getline.awk getline.awk getline.awk >tmp.
$	cmp getline.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$rand:		echo "rand"
$	echo "The following line should just be 19 random numbers between 1 and 100"
$	echo ""
$	gawk -f rand.awk
$	return
$
$negexp:	echo "negexp"
$	gawk "BEGIN { a = -2; print 10^a }" >tmp.
$	cmp negexp.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$asgext:	echo "asgext"
$	gawk -f asgext.awk asgext.in >tmp.
$	cmp asgext.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$anchgsub:	echo "anchgsub"
$	gawk -f anchgsub.awk anchgsub.in >tmp.
$	cmp anchgsub.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$splitargv:	echo "splitargv"
$	gawk -f splitargv.awk splitargv.in >tmp.
$	cmp splitargv.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$awkpath:	echo "awkpath"
$	define/User AWK_LIBRARY [],[.lib]
$	gawk -f awkpath.awk >tmp.
$	cmp awkpath.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$nfset:		echo "nfset"
$	gawk -f nfset.awk nfset.in >tmp.
$	cmp nfset.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$reparse:	echo "reparse"
$	gawk -f reparse.awk reparse.in >tmp.
$	cmp reparse.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$argtest:	echo "argtest"
$	gawk -f argtest.awk -x -y abc >tmp.
$	cmp argtest.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$badargs:	echo "badargs"
$	on error then continue
$	gawk -f 2>&1 >tmp.too
$!	search/Match=Nor tmp. "patchlevel" /Output=tmp.
$	gawk "/patchlevel/{next}; {gsub(""\"""",""'""); print}" <tmp.too >tmp.
$	cmp badargs.ok tmp.
$	if $status then  rm tmp.;,tmp.too;
$	return
$
$convfmt:	echo "convfmt"
$	gawk -f convfmt.awk >tmp.
$	cmp convfmt.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$arrayparm:	echo "arrayparm"
$	set noOn
$	AWKPATH_srcdir
$	gawk -f arrayparm.awk >tmp. 2>&1
$	set On
$	cmp arrayparm.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$paramdup:	echo "paramdup"
$	set noOn
$	AWKPATH_srcdir
$	gawk -f paramdup.awk >tmp. 2>&1
$	set On
$	cmp paramdup.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$nonl:		echo "nonl"
$	! this one might fail, depending on how the distribution was unpacked,
$	! because the nonl.awk might actually end up with a final newline
$	AWKPATH_srcdir
$	gawk --lint -f nonl.awk _NL: >tmp. 2>&1
$	cmp nonl.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$defref:	echo "defref"
$	set noOn
$	AWKPATH_srcdir
$	gawk --lint -f defref.awk >tmp. 2>&1
$	set On
$	cmp defref.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$nofmtch:	echo "nofmtch"
$	AWKPATH_srcdir
$	gawk --lint -f nofmtch.awk >tmp. 2>&1
$	cmp nofmtch.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$strftime:	echo "strftime"
$	! this test could fail on slow machines or on a second boundary,
$	! so if it does, double check the actual results
$!!	date | gawk -- "{$3 = sprintf(""%02d"",$3+0); print >""strftime.ok""; print strftime() >""tmp.""}"
$	! note: original test is too Unix-specific, so substitute an easier one
$	gawk -- "BEGIN {""show time"" | getline; print >""strftime.ok""; print strftime(""  %v %T"") >""tmp.""}"
$	set noOn
$	cmp strftime.ok tmp.
$	if $status then  rm tmp.;,strftime.ok;*
$	set On
$	return
$
$litoct:	echo "litoct"
$	gawk --traditional -f litoct.awk >tmp.
ab
$	cmp litoct.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$gensub:	echo "gensub"
$	gawk -f gensub.awk gensub.in >tmp.
$	cmp gensub.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$resplit:	echo "resplit"
$	gawk -- "{ FS = "":""; $0 = $0; print $2 }" >tmp.
a:b:c d:e:f
$	cmp resplit.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$rswhite:	echo "rswhite"
$	gawk -f rswhite.awk rswhite.in >tmp.
$	cmp rswhite.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$prmarscl:	echo "prmarscl"
$	set noOn
$	AWKPATH_srcdir
$	gawk -f prmarscl.awk >tmp. 2>&1
$	set On
$	cmp prmarscl.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$sclforin:	echo "sclforin"
$	set noOn
$	AWKPATH_srcdir
$	gawk -f sclforin.awk >tmp. 2>&1
$	set On
$	cmp sclforin.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$sclifin:	echo "sclifin"
$	set noOn
$	AWKPATH_srcdir
$	gawk -f sclifin.awk >tmp. 2>&1
$	set On
$	cmp sclifin.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$intprec:	echo "intprec"
$	gawk -f intprec.awk >tmp. 2>&1
$	cmp intprec.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$! note: this `childin' test currently [gawk 3.0.1] fails for vms
$childin:	echo "childin"
$	echo "note: type ``hi<return><ctrl/Z>'",-
	     "' if testing appears to hang in `childin'"
$!!	@echo hi | gawk "BEGIN { ""cat"" | getline; print; close(""cat"") }" >tmp.
$	gawk "BEGIN { ""type sys$input:"" | getline; print; close(""type sys$input:"") }" >tmp.
hi
$	cmp childin.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$noeffect:	echo "noeffect"
$	AWKPATH_srcdir
$	gawk --lint -f noeffect.awk >tmp. 2>&1
$	cmp noeffect.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$numsubstr:	echo "numsubstr"
$	AWKPATH_srcdir
$	gawk -f numsubstr.awk numsubstr.in >tmp.
$	cmp numsubstr.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$gnureops:	echo "gnureops"
$	gawk -f gnureops.awk >tmp.
$	cmp gnureops.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$pcntplus:	echo "pcntplus"
$	gawk -f pcntplus.awk >tmp.
$	cmp pcntplus.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$prmreuse:	echo "prmreuse"
$	if f$search("prmreuse.ok").eqs."" then  create prmreuse.ok
$	gawk -f prmreuse.awk >tmp.
$	cmp prmreuse.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$math:		echo "math"
$	gawk -f math.awk >tmp.
$	cmp math.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$fflush:
$	echo "fflush:  hopeless for VMS, so skipped"
$	return
$!!fflush:	echo "fflush"
$	! hopelessly Unix-specific
$!!	@fflush.sh >tmp.
$	cmp fflush.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$fldchg:	echo "fldchg"
$	gawk -f fldchg.awk fldchg.in >tmp.
$	cmp fldchg.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$fldchgnf:	echo "fldchgnf"
$	gawk -f fldchgnf.awk fldchgnf.in >tmp.
$	cmp fldchgnf.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$reindops:	echo "reindops"
$	gawk -f reindops.awk reindops.in >tmp.
$	cmp reindops.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$sprintfc:	echo "sprintfc"
$	gawk -f sprintfc.awk sprintfc.in >tmp.
$	cmp sprintfc.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$getlnhd:
$	echo "getlnhd:  uses Unix-specific command so won't work on VMS"
$	return
$!!getlnhd:	echo "getlnhd"
$	gawk -f getlnhd.awk >tmp.
$	cmp getlnhd.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$backgsub:	echo "backgsub"
$	gawk -f backgsub.awk backgsub.in >tmp.
$	cmp backgsub.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$tweakfld:	echo "tweakfld"
$	gawk -f tweakfld.awk tweakfld.in >tmp.
$	if f$search("errors.cleanup").nes."" then  rm errors.cleanup;*
$	cmp tweakfld.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$clsflnam:	echo "clsflnam"
$	if f$search("clsflnam.ok").eqs."" then  create clsflnam.ok
$	gawk -f clsflnam.awk clsflnam.in >tmp.
$	cmp clsflnam.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$mmap8k:	echo "mmap8k"
$	gawk "{ print }" mmap8k.in >tmp.
$	cmp mmap8k.in tmp.
$	if $status then  rm tmp.;
$	return
$
$fnarray:	echo "fnarray"
$	set noOn
$	AWKPATH_srcdir
$	gawk -f fnarray.awk >tmp. 2>&1
$	set On
$	cmp fnarray.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$dynlj:		echo "dynlj"
$	gawk -f dynlj.awk >tmp.
$	cmp dynlj.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$substr:	echo "substr"
$	gawk -f substr.awk >tmp.
$	cmp substr.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$eofsplit:	echo "eofsplit"
$	if f$search("eofsplit.ok").eqs."" then  create eofsplit.ok
$	gawk -f eofsplit.awk >tmp.
$	cmp eofsplit.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$prt1eval:	echo "prt1eval"
$	gawk -f prt1eval.awk >tmp.
$	cmp prt1eval.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$splitwht:	echo "splitwht"
$	gawk -f splitwht.awk >tmp.
$	cmp splitwht.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$back89:		echo "back89"
$	gawk "/a\8b/" back89.in >tmp.
$	cmp back89.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$tradanch:	echo "tradanch"
$	if f$search("tradanch.ok").eqs."" then  create tradanch.ok
$	gawk --traditional -f tradanch.awk tradanch.in >tmp.
$	cmp tradanch.ok tmp.
$	if $status then  rm tmp.;
$	return
$
$
$clean:
$	if f$search("tmp.")	 .nes."" then  rm tmp.;*
$	if f$search("tmp.too")	 .nes."" then  rm tmp.too;*
$	if f$search("out%.")	 .nes."" then  rm out%.;*
$	if f$search("strftime.ok").nes."" then  rm strftime.ok;*
$	if f$search("[.junk]*.*").nes."" then  rm [.junk]*.*;*
$	if f$parse("[.junk]")	 .nes."" then  rm []junk.dir;1
$	return
$
$!NOTREACHED
$ exit
