/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.requests;

import java.util.LinkedList;
import org.gnunet.mq.MessageQueue;
import org.gnunet.requests.Request;
import org.gnunet.requests.RequestContainer;
import org.gnunet.requests.RequestIdentifier;
import org.gnunet.requests.SimpleRequestIdentifier;

public class SequentialRequestContainer<T extends Request>
extends RequestContainer {
    private boolean overlap;
    private LinkedList<Identifier> requests = new LinkedList();
    private final MessageQueue mq;
    private int requestsActive = 0;

    public SequentialRequestContainer(MessageQueue mq, boolean overlap) {
        this.mq = mq;
        this.overlap = overlap;
    }

    public SequentialRequestContainer(MessageQueue mq) {
        this(mq, false);
    }

    public RequestIdentifier<T> getRequestIdentifier() {
        return this.requests.peekFirst();
    }

    public T getAndRetireRequest() {
        RequestIdentifier<T> i = this.getRequestIdentifier();
        if (null == i) {
            return null;
        }
        i.retire();
        return i.getRequest();
    }

    public Iterable<RequestIdentifier<T>> iter() {
        return this.requests;
    }

    public T getRequest() {
        RequestIdentifier<T> i = this.getRequestIdentifier();
        if (null == i) {
            return null;
        }
        return i.getRequest();
    }

    public RequestIdentifier<T> addRequest(T request) {
        Identifier identifier = new Identifier(this, request);
        this.requests.addLast(identifier);
        if (this.overlap || this.requestsActive == 0) {
            identifier.send(this.mq);
            ++this.requestsActive;
        }
        return identifier;
    }

    @Override
    public void restart() {
        LinkedList<Identifier> requestsOld = this.requests;
        this.requests = new LinkedList();
        for (Identifier r : requestsOld) {
            this.addRequest(r.getRequest());
        }
    }

    private static class Identifier
    extends SimpleRequestIdentifier<T> {
        final /* synthetic */ SequentialRequestContainer this$0;

        public Identifier(T request) {
            this.this$0 = var1_1;
            super(request);
        }

        @Override
        public void retire() {
            super.retire();
            if (this.this$0.requestsActive == 0 || this.this$0.requests.isEmpty()) {
                throw new AssertionError();
            }
            boolean found = this.this$0.requests.remove(this);
            if (!found) {
                throw new AssertionError((Object)"request not in queue");
            }
            this.this$0.requestsActive--;
            Identifier next = (Identifier)this.this$0.requests.peekFirst();
            if (null == next || next.queued) {
                return;
            }
            if (this.this$0.requestsActive == 0 || this.this$0.overlap) {
                next.send(this.this$0.mq);
            }
        }
    }
}

