/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.termcreation;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.AtomicTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.ArrayList;

public class Predicate_univ
extends ExecuteOnlyCode {
    public static final Term[] termArrayType = new Term[0];

    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        int undoPos = interpreter.getUndoPosition();
        Term term = args[0];
        Term list = args[1];
        if (term instanceof AtomicTerm) {
            Predicate_univ.checkList(list, false);
            if (list instanceof VariableTerm) {
                VariableTerm lvar = (VariableTerm)list;
                interpreter.addVariableUndo(lvar);
                lvar.value = CompoundTerm.getList(term, TermConstants.emptyListAtom);
                return 1;
            }
            CompoundTerm ct = (CompoundTerm)list;
            Term head = ct.args[0].dereference();
            Term tail = ct.args[1].dereference();
            if (head instanceof CompoundTerm) {
                PrologException.typeError(TermConstants.atomicAtom, head);
            }
            CompoundTerm t = CompoundTerm.getList(term, TermConstants.emptyListAtom);
            return interpreter.unify(t, list);
        }
        if (term instanceof CompoundTerm) {
            Predicate_univ.checkList(list, false);
            CompoundTerm ct = (CompoundTerm)term;
            CompoundTermTag tag = ct.tag;
            AtomTerm functor = tag.functor;
            Term tmp = TermConstants.emptyListAtom;
            Term[] targs = ct.args;
            int i = tag.arity - 1;
            while (i >= 0) {
                tmp = CompoundTerm.getList(targs[i].dereference(), tmp);
                --i;
            }
            int rc = interpreter.unify(tmp = CompoundTerm.getList(functor, tmp), list);
            if (rc == -1) {
                interpreter.undo(undoPos);
            }
            return rc;
        }
        if (term instanceof VariableTerm) {
            Predicate_univ.checkList(list, true);
            VariableTerm vt = (VariableTerm)term;
            if (list == TermConstants.emptyListAtom) {
                PrologException.domainError(TermConstants.nonEmptyListAtom, list);
            }
            CompoundTerm ct = (CompoundTerm)list;
            if (ct.tag != TermConstants.listTag) {
                PrologException.typeError(TermConstants.listAtom, list);
            }
            Term head = ct.args[0].dereference();
            Term tail = ct.args[1].dereference();
            if (head instanceof VariableTerm) {
                PrologException.instantiationError();
            }
            if (tail == TermConstants.emptyListAtom) {
                interpreter.addVariableUndo(vt);
                vt.value = head;
                return 1;
            }
            if (!(head instanceof AtomTerm)) {
                PrologException.typeError(TermConstants.atomAtom, head);
            }
            AtomTerm functor = (AtomTerm)head;
            ArrayList<Term> argList = new ArrayList<Term>();
            do {
                ct = (CompoundTerm)tail;
                head = ct.args[0].dereference();
                tail = ct.args[1].dereference();
                argList.add(head);
            } while (tail != TermConstants.emptyListAtom);
            Term[] targs = argList.toArray(termArrayType);
            interpreter.addVariableUndo(vt);
            vt.value = new CompoundTerm(functor, targs);
            return 1;
        }
        return -1;
    }

    private static void checkList(Term list, boolean nonPartial) throws PrologException {
        Term exArg = list;
        if (list == TermConstants.emptyListAtom) {
            return;
        }
        if (list instanceof VariableTerm) {
            if (nonPartial) {
                PrologException.instantiationError();
            } else {
                return;
            }
        }
        if (!(list instanceof CompoundTerm)) {
            PrologException.typeError(TermConstants.listAtom, exArg);
        }
        CompoundTerm ct = (CompoundTerm)list;
        if (ct.tag != TermConstants.listTag) {
            PrologException.typeError(TermConstants.listAtom, exArg);
        }
        Term head = ct.args[0].dereference();
        Term tail = ct.args[1].dereference();
        if (tail == TermConstants.emptyListAtom) {
            if (head instanceof CompoundTerm) {
                PrologException.typeError(TermConstants.atomicAtom, head);
            }
            return;
        }
        if (!(head instanceof VariableTerm) && !(head instanceof AtomicTerm)) {
            PrologException.typeError(TermConstants.atomAtom, head);
        }
        list = tail;
        while (list != TermConstants.emptyListAtom) {
            if (list instanceof VariableTerm) {
                if (nonPartial) {
                    PrologException.instantiationError();
                } else {
                    return;
                }
            }
            if (!(list instanceof CompoundTerm)) {
                PrologException.typeError(TermConstants.listAtom, exArg);
            }
            ct = (CompoundTerm)list;
            if (ct.tag != TermConstants.listTag) {
                PrologException.typeError(TermConstants.listAtom, exArg);
            }
            list = ct.args[1].dereference();
        }
        return;
    }
}

