<?php

//        # Copyright (C) 2012-2013 GNU remotecontrol authors.
//        #
//        # This program is free software: you can redistribute it and/or modify
//        # it under the terms of the GNU Affero General Public License as
//        # published by the Free Software Foundation, either version 3 of the
//        # License, or (at your option) any later version.
//        #
//        # This program is distributed in the hope that it will be useful,
//        # but WITHOUT ANY WARRANTY; without even the implied warranty of
//        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//        # GNU Affero General Public License for more details.
//        #
//        # You should have received a copy of the GNU Affero General Public License
//        # along with this program.  If not, see <http://www.gnu.org/licenses/>.

	class IPThermostatCollection extends ArrayObject
	{
		// Constructor
		public function __construct($userId, $loadData, $sortField = false)
		{
			if($loadData)
			{
				$this->Load($userId, $sortField);
			}
		}

		// Methods
		public function FindThermostatByID($id)
		{
			foreach($this as $therm)
			{
				if($therm->ID == $id)
				{
					return $therm;
				}
			}

			return null;
		}

		protected function Load($userId, $sortField = false)
		{
		        //default sorting field
		        if (!$sortField) {
		            $sortField = 'Name_Asc';
		        }
		        $dataAccess = new MySqlDataAccess(Common::ConnectionString);
			$dataAccess->Command->CommandType = CommandType::StoredProcedure;

			$dataAccess->Command->CommandText = "CALL sp_Thermostat_Load_All($userId, '$sortField')";
			$dataAccess->GetData();
			if($dataAccess->ResultSet)
			{
				while($row = $dataAccess->ResultSet->fetch_assoc())
				{
					$this->append(new IPThermostat(intval($row['ThermostatId']), $row['Name'], $row['Description'], $row['Host'],
							$row['Port'], $row['AuthString'], new TimeZoneOffset($row['TimeZoneOffsetID'], true), new IPThermostatGroup($row['GroupId'], true)));
				}
			}

			$dataAccess->Cleanup();
		}
	}

?>
