#! @AWK@ -f

#######################################################################
#
#   Gtk wrapper creation scripts (C->Smalltalk interface for signals)
#
########################################################################


#######################################################################
#
# Copyright 2003 Free Software Foundation, Inc.
# Written by Paolo Bonzini and Norman Jordan
#
# This file is part of the GNU Smalltalk class library.
#
# The GNU Smalltalk class library is free software; you can redistribute it
# and/or modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1, or (at
# your option) any later version.
# 
# The GNU Smalltalk class library is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
# General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public License
# along with the GNU Smalltalk class library; see the file COPYING.LESSER.
# If not, write to the Free Software Foundation, 59 Temple Place - Suite
# 330, Boston, MA 02111-1307, USA.  
#
########################################################################

BEGIN {
  print "/* Automatically generated, do not edit! */"
  print "#include <string.h>"
  print "#include <stdlib.h>"
  print "#include <glib.h>"
  print "#include <glib-object.h>"
  print "#include <atk/atk.h>"
  print "#include <pango/pango.h>"
  print "#include <gdk/gdk.h>"
  print "#include <gtk/gtk.h>"
  print "#include \"gstpub.h\""
  print "#include \"blox-gtk.h\"\n"

  if (header_file == "") {
    header_file = "signals.h"
  }
  print "/* Automatically generated, do not edit! */" > header_file
}

$0 ~ /^struct _[a-zA-Z]+Class/ {
  className = $2
  sub(/^_/, "", className)
  sub(/Class$/, "", className)
    
  getline
  while($0 !~ /^};/) {
    if($0 ~ /[a-zA-Z0-9]+[ \t]+\(\*[a-zA-Z0-9_]+\)\([a-zA-Z_]+[ \t]+\**[a-zA-Z_]+[,\)]/) {
      declaration($1, $2, $2, $3)

    } else if($0 ~ /[a-zA-Z0-9]+[ \t]+\(\*[ \t]+[a-zA-Z0-9_]+\)\([a-zA-Z_]+[ \t]+\**[a-zA-Z)]+[,\)]/) {
      declaration($1, $3, $3, $4)

    } else if($0 ~ /[a-zA-Z0-9]+[ \t]+\(\*[a-zA-Z0-9_]+\)[ \t]+\([a-zA-Z_]+[ \t]+\**[a-zA-Z_]+[,\)]/) {
      declaration($1, $2, $3, $4)

    } else if($0 ~ /[a-zA-Z0-9]+[ \t]+\(\*[ \t]+[a-zA-Z0-9_]+\)[ \t]+\([a-zA-Z_]+[ \t]+\**[a-zA-Z_]+[,\)]/) {
      declaration($1, $3, $4, $5)
    }

    getline
  }
}

function declaration (returnType, signalName, firstType, firstName)
{
  split ("", argTypes)
  split ("", argNames)

  argTypes[0] = firstType
  argNames[0] = firstName

  sub(/\).*$/, "", signalName)
  sub(/^\(\*/, "", signalName)
  sub(/^.*\(/, "", argTypes[0])

  if(className == "GtkContainer" && signalName == "forall") {
    getline
    return
  }

  i = 1
  while($0 !~ /\);[ \t]*$/) {
    getline
        
    sub(/\/\*.*/, "")
    if(NF == 2) {
      argTypes[i] = $1
      argNames[i] = $2
    } else {
      argTypes[i] = $1 " " $2
      argNames[i] = $3
    }
    i++
  }

  # Remove pointer and array markers from argument names and compute argPointer
  for (i in argTypes) {
    paramName = argNames[i]
    sub(/,$/, "", paramName)
    sub(/\);/, "", paramName)
    argPointer[i] = 0
    for (;;) {
      if(paramName ~ /^\*/) {
        paramName = substr(paramName, 2)
      } else if (paramName ~ /\[\]/) {
        sub(/\[\]/, "", paramName)
      } else {
        break
      }
      argPointer[i]++
    }

    # Simplify a bit
    if (argPointer[i] > 1) {
       argType[i] = "gpointer"
       argPointer[i] = 1
    }
    if (argType[i] = "gconstpointer") {
      argType[i] = "const gpointer"
    }

    argNames[i] = paramName
  }

  # First print the function declaration (also to the header file)

  printf "%s %s_%s(", returnType, className, signalName
  printf "%s %s_%s(", returnType, className, signalName >> header_file
    
  for(i in argTypes) {
    line = argTypes[i] " "
    if(argPointer[i])
      line = line "*"

    line = line argNames[i] ", "
    printf line
    printf line >> header_file
  }
    
  print "gpointer bloxGtkUserData)\n{"
  print "gpointer bloxGtkUserData);" >> header_file

  # and the local variables
  print "  static char selector[] = \"" getSelector(signalName, argNames) "\";"
  print "  eventData *ed = bloxGtkUserData;"

  # Allocate copies of const parameters (consider using alloca)
  mustFree = 0
  for(i in argTypes) {
    if(argTypes[i] ~ /^const / && argPointer[i]) {
      mustFree = 1
      printf "  gpointer %s_copy = ", argNames[i]
      if(argTypes[i] ~ /g?char$/) {
        printf "strdup(%s);", argNames[i]
      } else {
        size = "sizeof(" argTypes[i] ")"
        printf "memcpy(malloc(%s), %s, %s);", size, argNames[i], size
      }
      argNames[i] = argNames[i] "_copy"
    }
  }
  if (mustFree)
    print ""

  # Now the method invocation proper
  printf "  "
  spaces="  "
  if (returnType ~ /^gboolean$/ || isIntType(returnType)) {
    printf "OOP result = "
    spaces="             " spaces
  }
  printf "_blox_vm_proxy->strMsgSend(ed->eventHandler, selector, ed->data, ed->widget,\n"
  spaces="                           " spaces
  for(i in argTypes) {
    if (i > 0) {
      convFunc = converter(argPointer[i], argTypes[i]);
      printf "%s_blox_vm_proxy->%s(%s),\n", spaces, convFunc, argNames[i]
    }
  }
    
  printf "%sNULL);\n", spaces

  # Free the variables
  if (mustFree) {
    print ""
    for(i in argTypes) {
      if(argTypes[i] ~ /^const / && argPointer[i])
        printf "  free(%s);\n", argNames[i]
    }
  }
    
  # And compute the return value
  if (isIntType(returnType))
    print "\n  return(_blox_vm_proxy->OOPToInt(result));"
  else if(returnType == "gboolean")
    print "\n  return(_blox_vm_proxy->OOPToBool(result));"

  print "}\n"
}

function converter(pointer, argType) {
  if(pointer && argType ~ /g?char$/)
    return "stringToOOP"

  if (pointer || argType ~ /gpointer$/)
    return "cObjectToOOP"

  if(argType ~ /g?char$/)
    return "charToOOP"

  if(isIntType(argType))
    return "intToOOP"

  if(argType ~ /g?(float|double)$/)
    return "floatToOOP"

  if(argType ~ /gboolean$/)
    return "boolToOOP"

  print "#error make-signal-funcs.awk: unrecognized type " argType
  return "cObjectToOOP"
}
        
function isIntType(argType)
{
  return argType ~ /(int|gu?int.*|G.*(Type|Style|Flags)|GtkOrientation|GtkCListDragPos|PangoGlyph|GdkWindowEdge|GtkTextDirection|GtkMovementStep|GtkCellRendererState|GdkGCValuesMask|GdkRgbDither|GtkNotebookTab|AtkRole|AtkLayer)$/
}

function getSelector(signalName, argNames) {
  string = smalltalkize(signalName) ":data:"
  for(i in argNames) {
    if (i > 1)
      string = string smalltalkize(argNames[i]) ":"
  }
  return string
}

function smalltalkize( res )
{
  first = substr (res, 1, 1)
  res = tolower( substr (res, 2) )

  while (is = index (res, "_")) {
    first = first substr(res, 1, is - 1) toupper( substr (res, is + 1, 1))
    res = substr (res, is + 2)
  }

  return first res
}
