# vim: set noexpandtab:
#
# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001, 2002, 2003  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

all:

%.html: $(depth)/topdocs/%.texi
	makeinfo --no-headers --html --no-split $< > $@


LOOP=$(foreach i, $(SUBDIRS), $(MAKE) -C $(i) $@ &&) true
LANGLOOP=$(foreach i, $(LANGUAGES), $(MAKE) -C $(i) $@ &&) true

export prefix=/usr/local
export exec_prefix=${prefix}
export bindir=${exec_prefix}/bin
export datadir=${prefix}/share
export sysconfdir=${prefix}/etc
export libdir=${exec_prefix}/lib
export mandir=${prefix}/man
export CC=gcc
export CFLAGS=-g -O2
export M4=/usr/bin/m4
export SWIG=@SWIG@
export SWIG_VERSION=@SWIG_VERSION@
export WITH_LOCAL_XMLCATALOG=no
export XGETTEXT=/usr/bin/xgettext
export MSGFMT=/usr/bin/msgfmt
export MSGMERGE=/usr/bin/msgmerge
export PYTHON=/usr/bin/python
export XSLTPROC=@XSLTPROC@
export PYTHON_VERSION=2.3
export PYTHON_PREFIX=${prefix}
export PYTHON_INCLUDES=-I/usr/include/python2.3
export PACKAGE=solfege

export MAJOR_VERSION=2
export MINOR_VERSION=0
export PATCH_LEVEL=7
export VERSION=2.0.7
export stylesheet_filename=@stylesheet_filename@

export INSTALL=/usr/bin/install -c
export INSTALL_PROGRAM = ${INSTALL}
export INSTALL_DATA = ${INSTALL} -m 644
export WITH_GNOME = yes
export ENABLE_OSS_SOUND = yes
export ENABLE_TUNER = no
export HAVE_LINUX_AWE_VOICE_H = yes
export HAVE_GTKHTML = yes
export HAVE_FFTW = @HAVE_FFTW@
export LIBS=
export DISTNAME=$(PACKAGE)-$(VERSION)
export DISTDIR=$(PWD)/$(PACKAGE)-$(VERSION)

dist:
	mkdir $(depth)/$(DISTNAME)/$(name)
	cp $(dist_files) $(depth)/$(DISTNAME)/$(name)
	$(LOOP)

easy-dist:
	mkdir -p $(depth)/$(DISTNAME)/$(name)
	cp $(easy_dist_files) $(depth)/$(DISTNAME)/$(name)
	$(LOOP)

win32-dist-local:
	cp $(win32_dist_files) $(depth)/$(DISTNAME)/$(name)

python-install:
	mkdir -p $(datadir)/$(PACKAGE)/$(VERSION)/$(name)
	$(INSTALL_DATA) $(python-installfiles) $(datadir)/$(PACKAGE)/$(VERSION)/$(name)
ifneq ($(nopycompile),YES)
	$(depth)/py-compile --basedir $(datadir)/$(PACKAGE)/$(VERSION)/$(name)/*.py 1>/dev/null
endif

python-uninstall:
	echo "__init__.py" | sed -e 's/\.py/\.pyc/g'
	for file in $(python-installfiles); do\
	  rm -f $(datadir)/$(PACKAGE)/$(VERSION)/$(name)/$$file; \
	  rm -f $(datadir)/$(PACKAGE)/$(VERSION)/$(name)/`echo $$file | sed -e 's/\.py/\.pyc/g'  `;  \
	  rm -f $(datadir)/$(PACKAGE)/$(VERSION)/$(name)/`echo $$file | sed -e 's/\.py/\.pyo/g'  `;  \
	done
	rmdir $(datadir)/$(PACKAGE)/$(VERSION)/$(name) || true

data-install:
	mkdir -p $(datadir)/$(PACKAGE)/$(VERSION)/$(name)
	$(INSTALL_DATA) $(data-installfiles) $(datadir)/$(PACKAGE)/$(VERSION)/$(name)

data-uninstall:
	for file in $(data-installfiles); do\
	  rm -f $(datadir)/$(PACKAGE)/$(VERSION)/$(name)/$$file || true ;\
	done
	rmdir $(datadir)/$(PACKAGE)/$(VERSION)/$(name) || true
	rmdir $(datadir)/$(PACKAGE)/$(VERSION) || true

