#ifndef TAGS_H
#define TAGS_H

#define SPACE_CHAR " "

#define ISBOLD 0x1
#define ISITALIC 0x2
#define ISUNDERLINE 0x4

#include "my_set.h"

#include <string>

using std::string;

class Tag
{
 protected:
  string TagName ;
  string color ;
  int flags ;

 public:
  Tag( const string &n ) : TagName( n ), flags( 0 ) {}
  Tag( const string &n, const string &c );

  void SetFlags( int f ) { flags = f ; }

  string GetName() const { return TagName ; }
  string GetColor() const { return color ; }
  void SetColor( const string &col ) { color = col ; }

  int IsBold() { return ( flags & ISBOLD ) ; }
  int IsItalic() { return ( flags & ISITALIC ) ; }
  int IsUnderline() { return ( flags & ISUNDERLINE ) ; }

  void Print() ;
} ;

struct TagLess
{
  typedef std::less<string> value_compare;

  value_compare value_comp;

 public:
  bool operator() (const Tag *t1, const Tag *t2) const
  { return value_comp(t1->GetName(),t2->GetName()); }
};

class Tags
{
 protected:
  typedef set<Tag *, TagLess> container_type;

  container_type tagsList ;

  typedef container_type::const_iterator const_iterator;

 public:
  Tags() {}
  void AddTag( Tag *t ) { tagsList.insert( t ) ;  }
  Tag *GetTag( const string &name ) ;
} ;

inline Tag *
Tags::GetTag( const string &name )
{
  Tag *temp = new Tag (name);
  const_iterator p = tagsList.find (temp);
  delete temp;
  if (p != tagsList.end ())
    return *p;

  return 0;
}

void setTags( Tags *t ) ;
Tag *getTag( const string &name ) ;
void createDefaultTags() ;
Tag *newDefaultTag( const string &tag, const string &color ) ;

#endif
