
;;;
;;; NOTE: This code is for use in Windows only as the drive spec is
;;; assumed to occupy position 0 of the file strings
;;;
(defun d-round (x)
  (/ (round (* x 100.0)) 100.0))

(defun compare-files-inner-nondirs (ptr-c ptr-k &optional progress)
  (when progress
    (setq count 0)
    (setq len   (length ptr-c)))
  (assert (compare-lists ptr-c ptr-k))
  ;;(compare-files-inner-subdirs (car ptr-c) (car ptr-k))
  ;;(debug "Billie Holiday: Twenty four Hours a Day")
  (while (or ptr-c ptr-k)
    (assert (not (file-directory-p (car ptr-c))))
    (assert (not (file-directory-p (car ptr-k))))
    (if (and ptr-c ptr-k)
        (if (and (stringp (car ptr-c))
                 (stringp (car ptr-k))
                 (string= (substring (car ptr-c) 1) (substring (car ptr-k) 1)))
            (progn
              (setq fc (nth 7 (file-attributes (car ptr-c))))
              (setq fk (nth 7 (file-attributes (car ptr-k))))
              (if (/= fc fk)
                  (message "File size mismatch #1 %s, %s" (car ptr-c) (car ptr-k)))
              ;;(debug "Bic Runga: Heal me now")
              )
          (message "File mismatch #2 %s, %s" (car ptr-c) (car ptr-k))
          )
      (message "File mismatch #3 %s, %s" (car ptr-c) (car ptr-k)))
    (setq ptr-k (cdr ptr-k))
    (setq ptr-c (cdr ptr-c))
    (when progress
      (incf count)
      (message "Progress %s%%" (d-round (/ (* 100.0 count) len)))
      ;;(debug "David Bowie's China Girl")
      )) ;; END WHILE!
  )

(defun compare-files-inner-subdirs (ptr-c ptr-k &optional progress)
  (let (count len)
    (assert (compare-lists ptr-c ptr-k))
    (when progress
      (setq count 0)
      (setq len   (length ptr-c)))
    ;;(debug "Bic Runga: Sorry")
    (while (or ptr-c ptr-k)
      (if (and ptr-c ptr-k
               (stringp (car ptr-c))
               (stringp (car ptr-k))
               (string= (substring (car ptr-c) 1) (substring (car ptr-k) 1)))
          (let (ptr2-c ptr2-k)
            (setq ptr2-c (directory-files-subdirs (car ptr-c) t))
            (setq ptr2-k (directory-files-subdirs (car ptr-k) t))
            (compare-files-inner-subdirs ptr2-c ptr2-k)
            ;;(debug "Halloween")
            (setq ptr2-c (directory-files-nondirs (car ptr-c) t))
            (setq ptr2-k (directory-files-nondirs (car ptr-k) t))
            (assert (compare-lists ptr2-c ptr2-k))
            (compare-files-inner-nondirs ptr2-c ptr2-k)
            )
        (message "File mismatch #4 %s, %s" (car ptr-c) (car ptr-k)))
      ;;(debug "John Coltrane: Ascension")
      (setq ptr-c (cdr ptr-c))
      (setq ptr-k (cdr ptr-k))
      (when progress
        (incf count)
        (message "Progress %s%%" (d-round (/ (* 100.0 count) len)))
        )
      ) ;; END WHILE!
    )
  )

;; (compare-lists (setq list1 '("a:/bcd")) (setq list2 '("b:/bcx")))
;; (compare-lists (setq list1 '("a:/bcd")) (setq list2 '("b:/bcd")))
(defun compare-lists (ptr-1 ptr-2)
  (let ((done  nil)
        (found t))
    (while (and (not done) (or ptr-1 ptr-2))
      (when (not (and ptr-1 ptr-2
                      (string= (substring (car ptr-1) 1)
                               (substring (car ptr-2) 1))))
        (message "File mismatch #5\n (car ptr-1)=%s,\n (car ptr-2)=%s" (car ptr-1) (car ptr-2))
        ;;(debug "Bob Dylan: Positively 4th Street")
        (message "ptr-1=%s" ptr-1)
        (message "ptr-2=%s" ptr-2)
        ;;(debug "Billie Holiday: What a Night, What a Moon, What a Girl")
        (setq found nil)
        (setq done t))
      (setq ptr-1 (cdr ptr-1))
      (setq ptr-2 (cdr ptr-2)))
    found))

(defun compare-files ()
  (interactive)
  (let (ptr-c ptr-k dir)
    (setq dir "Downloads")
    ;;(setq dir "Install Files")
    ;;(setq dir "flacs")
    (setq drive "f")
    (setq ptr-c (directory-files-subdirs (concat "c:/"      dir) t))
    (setq ptr-k (directory-files-subdirs (concat drive ":/" dir) t))
    (assert (compare-lists ptr-c ptr-k))
    (compare-files-inner-subdirs ptr-c ptr-k 'PROGRESS)
    (setq ptr-c (directory-files-nondirs (concat "c:/" dir)      t))
    (setq ptr-k (directory-files-nondirs (concat drive ":/" dir) t))
    (assert (compare-lists ptr-c ptr-k))
    (compare-files-inner-nondirs ptr-c ptr-k 'PROGRESS)
    )
  )

(provide 'compare-files)
