/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (opts.h)
 *
 *  It has been AutoGen-ed
 *  From the definitions    opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 41:1:16 templates.
 *
 *  AutoOpts is a copyrighted work.  This header file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the gnu-pw-mgr author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The gnu-pw-mgr program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 2013-2014 Bruce Korb, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  gnu-pw-mgr is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  gnu-pw-mgr is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the gnu-pw-mgr program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_OPTS_H_GUARD
#define AUTOOPTS_OPTS_H_GUARD 1
#include "config.h"
#include <autoopts/options.h>
#include <stdarg.h>

/**
 *  Ensure that the library used for compiling this generated header is at
 *  least as new as the version current when the header template was released
 *  (not counting patch version increments).  Also ensure that the oldest
 *  tolerable version is at least as old as what was current when the header
 *  template was released.
 */
#define AO_TEMPLATE_VERSION 167937
#if (AO_TEMPLATE_VERSION < OPTIONS_MINIMUM_VERSION) \
 || (AO_TEMPLATE_VERSION > OPTIONS_STRUCT_VERSION)
# error option template version mismatches autoopts/options.h header
  Choke Me.
#endif

/**
 *  Enumeration of each option type for gnu-pw-mgr
 */
typedef enum {
    INDEX_OPT_SEED                =  1,
    INDEX_OPT_TAG                 =  2,
    INDEX_OPT_TEXT                =  3,
    INDEX_OPT_LOGIN_ID            =  5,
    INDEX_OPT_LENGTH              =  6,
    INDEX_OPT_CCLASS              =  7,
    INDEX_OPT_PBKDF2              =  8,
    INDEX_OPT_SPECIALS            =  9,
    INDEX_OPT_SELECT_CHARS        = 10,
    INDEX_OPT_NO_HEADER           = 12,
    INDEX_OPT_CONFIRM             = 13,
    INDEX_OPT_STATUS              = 14,
    INDEX_OPT_DELETE              = 15,
    INDEX_OPT_VERSION             = 17,
    INDEX_OPT_HELP                = 18,
    INDEX_OPT_MORE_HELP           = 19,
    INDEX_OPT_LOAD_OPTS           = 20
} teOptIndex;
/** count of all options for gnu-pw-mgr */
#define OPTION_CT    21
/** gnu-pw-mgr version */
#define GNU_PW_MGR_VERSION       "1.6"
/** Full gnu-pw-mgr version text */
#define GNU_PW_MGR_FULL_VERSION  "gnu-pw-mgr 1.6"

/**
 *  Interface defines for all options.  Replace "n" with the UPPER_CASED
 *  option name (as in the teOptIndex enumeration above).
 *  e.g. HAVE_OPT(SEED_OPTIONS)
 */
#define         DESC(n) (gnu_pw_mgrOptions.pOptDesc[INDEX_OPT_## n])
/** 'true' if an option has been specified in any way */
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
/** The string argument to an option. The argument type must be \"string\". */
#define      OPT_ARG(n) (DESC(n).optArg.argString)
/** Mask the option state revealing how an option was specified.
 *  It will be one and only one of \a OPTST_SET, \a OPTST_PRESET,
 * \a OPTST_DEFINED, \a OPTST_RESET or zero.
 */
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
/** Count of option's occurrances *on the command line*. */
#define    COUNT_OPT(n) (DESC(n).optOccCt)
/** mask of \a OPTST_SET and \a OPTST_DEFINED. */
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
/** 'true' if \a HAVE_OPT would yield 'false'. */
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
/** 'true' if OPTST_DISABLED bit not set. */
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
/** number of stacked option arguments.
 *  Valid only for stacked option arguments. */
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
/** stacked argument vector.
 *  Valid only for stacked option arguments. */
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
/** Reset an option. */
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT_MASK;   \
                if ((DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Enumeration of gnu-pw-mgr exit codes
 */
typedef enum {
    GNU_PW_MGR_EXIT_SUCCESS          = 0,
    GNU_PW_MGR_EXIT_INVALID          = 1,
    GNU_PW_MGR_EXIT_NO_MEM           = 2,
    GNU_PW_MGR_EXIT_BAD_USER         = 3,
    GNU_PW_MGR_EXIT_HOMELESS         = 4,
    GNU_PW_MGR_EXIT_PERM             = 5,
    GNU_PW_MGR_EXIT_NO_CONFIG        = 6,
    GNU_PW_MGR_EXIT_BAD_CONFIG       = 7,
    GNU_PW_MGR_EXIT_NO_SEED          = 8,
    GNU_PW_MGR_EXIT_BAD_SEED         = 9,
    GNU_PW_MGR_EXIT_BAD_SELECT_CHARS = 10,
    GNU_PW_MGR_EXIT_CODING_ERROR     = 16,
    GNU_PW_MGR_EXIT_USAGE_ERROR      = 64,
    GNU_PW_MGR_EXIT_NO_CONFIG_INPUT  = 66,
    GNU_PW_MGR_EXIT_LIBOPTS_FAILURE  = 70
}   gnu_pw_mgr_exit_code_t;
/**
 *  Interface defines for specific options.
 * @{
 */
#define VALUE_OPT_SEED           0x1001
#define VALUE_OPT_TAG            't'

#define SET_OPT_TAG(a)   STMTS( \
        DESC(TAG).optActualIndex = 2; \
        DESC(TAG).optActualValue = VALUE_OPT_TAG; \
        DESC(TAG).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(TAG).fOptState |= OPTST_SET; \
        DESC(TAG).optArg.argString = (a) )
#define VALUE_OPT_TEXT           's'
#define VALUE_OPT_LOGIN_ID       'i'

#define SET_OPT_LOGIN_ID(a)   STMTS( \
        DESC(LOGIN_ID).optActualIndex = 5; \
        DESC(LOGIN_ID).optActualValue = VALUE_OPT_LOGIN_ID; \
        DESC(LOGIN_ID).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(LOGIN_ID).fOptState |= OPTST_SET; \
        DESC(LOGIN_ID).optArg.argString = (a) )
#define VALUE_OPT_LENGTH         'l'

#define OPT_VALUE_LENGTH         (DESC(LENGTH).optArg.argInt)
#define SET_OPT_LENGTH(a)   STMTS( \
        DESC(LENGTH).optActualIndex = 6; \
        DESC(LENGTH).optActualValue = VALUE_OPT_LENGTH; \
        DESC(LENGTH).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(LENGTH).fOptState |= OPTST_SET; \
        DESC(LENGTH).optArg.argInt = (a); \
        (*(DESC(LENGTH).pOptProc))(&gnu_pw_mgrOptions, \
                gnu_pw_mgrOptions.pOptDesc + 6); )
#define VALUE_OPT_CCLASS         'c'

#define CCLASS_ALPHA             0x0001UL
#define CCLASS_UPPER             0x0002UL
#define CCLASS_LOWER             0x0004UL
#define CCLASS_DIGIT             0x0008UL
#define CCLASS_SPECIAL           0x0010UL
#define CCLASS_NO_SPECIAL        0x0020UL
#define CCLASS_NO_ALPHA          0x0040UL
#define CCLASS_NO_TRIPLETS       0x0080UL
#define CCLASS_PIN               0x0100UL
#define CCLASS_ALNUM             0x0200UL
#define CCLASS_TWO_UPPER         0x0400UL
#define CCLASS_TWO_LOWER         0x0800UL
#define CCLASS_TWO_DIGIT         0x1000UL
#define CCLASS_TWO_SPECIAL       0x2000UL
#define CCLASS_MEMBERSHIP_MASK   0x3FFFUL
#define OPT_VALUE_CCLASS         ((uintptr_t)DESC(CCLASS).optCookie)
#define OPT_MEMLST_CCLASS        optionMemberList(&DESC(CCLASS))
#define SET_OPT_CCLASS(a)   STMTS( \
        DESC(CCLASS).optActualIndex = 7; \
        DESC(CCLASS).optActualValue = VALUE_OPT_CCLASS; \
        DESC(CCLASS).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(CCLASS).fOptState |= OPTST_SET; \
        DESC(CCLASS).optArg.argIntptr = (a); \
        (*(DESC(CCLASS).pOptProc))(&gnu_pw_mgrOptions, \
                gnu_pw_mgrOptions.pOptDesc + 7); )
#define VALUE_OPT_PBKDF2         0x1002

#define OPT_VALUE_PBKDF2         (DESC(PBKDF2).optArg.argInt)
#define SET_OPT_PBKDF2(a)   STMTS( \
        DESC(PBKDF2).optActualIndex = 8; \
        DESC(PBKDF2).optActualValue = VALUE_OPT_PBKDF2; \
        DESC(PBKDF2).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(PBKDF2).fOptState |= OPTST_SET; \
        DESC(PBKDF2).optArg.argInt = (a); \
        (*(DESC(PBKDF2).pOptProc))(&gnu_pw_mgrOptions, \
                gnu_pw_mgrOptions.pOptDesc + 8); )
#define DISABLE_OPT_PBKDF2   STMTS( \
        DESC(PBKDF2).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(PBKDF2).fOptState |= OPTST_SET | OPTST_DISABLED; \
        DESC(PBKDF2).optArg.argString = NULL; \
        (*(DESC(PBKDF2).pOptProc))(&gnu_pw_mgrOptions, \
                gnu_pw_mgrOptions.pOptDesc + 8); )
#define VALUE_OPT_SPECIALS       0x1003

#define SET_OPT_SPECIALS(a)   STMTS( \
        DESC(SPECIALS).optActualIndex = 9; \
        DESC(SPECIALS).optActualValue = VALUE_OPT_SPECIALS; \
        DESC(SPECIALS).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(SPECIALS).fOptState |= OPTST_SET; \
        DESC(SPECIALS).optArg.argString = (a); \
        (*(DESC(SPECIALS).pOptProc))(&gnu_pw_mgrOptions, \
                gnu_pw_mgrOptions.pOptDesc + 9); )
#define VALUE_OPT_SELECT_CHARS   0x1004
#define VALUE_OPT_NO_HEADER      'H'
#define VALUE_OPT_CONFIRM        'C'
#define VALUE_OPT_STATUS         'S'
#define VALUE_OPT_DELETE         'd'
/** option flag (value) for help-value option */
#define VALUE_OPT_HELP          'h'
/** option flag (value) for more-help-value option */
#define VALUE_OPT_MORE_HELP     'M'
/** option flag (value) for version-value option */
#define VALUE_OPT_VERSION       'v'
#define VALUE_OPT_SAVE_OPTS     0
/** option flag (value) for load-opts-value option */
#define VALUE_OPT_LOAD_OPTS     0x1005
/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS(gnu_pw_mgrOptions.fOptSet &= ~OPTPROC_ERRSTOP)
#define ERRSTOP_OPTERR  STMTS(gnu_pw_mgrOptions.fOptSet |= OPTPROC_ERRSTOP)
#define RESTART_OPT(n)  STMTS( \
                gnu_pw_mgrOptions.curOptIdx = (n); \
                gnu_pw_mgrOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*gnu_pw_mgrOptions.pUsageProc)(&gnu_pw_mgrOptions, c)

#ifdef  __cplusplus
extern "C" {
#endif
/*
 *  global exported definitions
 */

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <inttypes.h>
#include <pwd.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdnoreturn.h>
#include <string.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <termios.h>
#include <time.h>
#include <unistd.h>

#include "base64.h"
#include "gc.h"
#include "sha256.h"

#include "gpw-str.c"

#define MIN_PW_LEN         8
#define MIN_SEED_TEXT_LEN 64
#define MARK_TEXT_LEN     24
#define CONFIRM_LEN       12
#define MIN_BUF_LEN ((256 / NBBY) + (256 / (NBBY * 2))) // 48
#define VER_TO_INT(_maj, _min, _rev) \
	(((_maj)<<20) + ((_min)<<10) + (_rev))

static unsigned int const secure_mask   = S_IRWXG | S_IRWXO;
static char const * config_file_name    = NULL;
static size_t       config_file_size    = 0;
static uintptr_t    post_cfg_setting    = 0UL;

typedef struct str_list str_list_t;
struct str_list {
    str_list_t *    next;
    char            buf[0];
};


/* * * * * *
 *
 *  Declare the gnu-pw-mgr option descriptor.
 */
extern tOptions gnu_pw_mgrOptions;
# define OPT_NO_XLAT_CFG_NAMES
# define OPT_NO_XLAT_OPT_NAMES

# define OPT_XLAT_CFG_NAMES
# define OPT_XLAT_OPT_NAMES

# ifndef _
#   define _(_s)  _s
# endif

extern void vusage_message(char const * fmt, va_list ap);
extern void usage_message(char const * fmt, ...);
extern void vdie( int exit_code, char const * fmt, va_list);
extern void die(  int exit_code, char const * fmt, ...);
extern void fserr(int exit_code, char const * op, char const * fn);

/**
 * Print a GNU_PW_MGR_EXIT_NO_MEM fatal error message and die.
 *
 * @param[in] sz     the object size that was not allocated
 * @param[in] what   what that object was going to be
 * @noreturn
 */
static inline void
nomem_err(size_t sz, char const * what)
{
    char const * fmt = _("could not allocate %zu bytes for %s\n");
    die(GNU_PW_MGR_EXIT_NO_MEM, fmt, sz, what);
}
extern void vwarning_msg( char const * fmt, va_list);
extern void warning_msg(  char const * fmt, ...);
#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_OPTS_H_GUARD */

/* opts.h ends here */
