/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.crypto;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.util.HashCode;
import org.gnunet.util.Strings;
import org.gnunet.util.crypto.EcdsaPublicKey;
import org.gnunet.util.crypto.Ed25519;

public class EcdsaSignature
implements Message {
    @FixedSizeIntegerArray(bitSize=8, signed=false, length=32)
    public byte[] r = new byte[32];
    @FixedSizeIntegerArray(bitSize=8, signed=false, length=32)
    public byte[] s = new byte[32];

    public boolean verifyRaw(byte[] m, EcdsaPublicKey publicKey) {
        if (publicKey.asPoint().isIdentity()) {
            throw new AssertionError();
        }
        if (!publicKey.asPoint().isOnCurve()) {
            throw new AssertionError();
        }
        if (!publicKey.asPoint().scalarmult(Ed25519.l).isIdentity()) {
            throw new AssertionError((Object)"invalid public key");
        }
        HashCode h = HashCode.hash(m);
        BigInteger z = new BigInteger(1, h.data);
        BigInteger sCoeff = Ed25519.decodeScalar(this.s);
        if (sCoeff.equals(BigInteger.ZERO) || sCoeff.compareTo(Ed25519.l) >= 0) {
            return false;
        }
        BigInteger rCoeff = Ed25519.decodeScalar(this.r);
        if (rCoeff.equals(BigInteger.ZERO) || rCoeff.compareTo(Ed25519.l) >= 0) {
            return false;
        }
        BigInteger w = sCoeff.modInverse(Ed25519.l);
        BigInteger u1 = z.multiply(w).mod(Ed25519.l);
        BigInteger u2 = rCoeff.multiply(w).mod(Ed25519.l);
        Ed25519 P = Ed25519.B.scalarmult(u1).add(publicKey.asPoint().scalarmult(u2));
        return P.P0.mod(Ed25519.l).equals(rCoeff);
    }

    public boolean verify(byte[] data, int purpose, EcdsaPublicKey publicKey) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(data.length + 8);
        DataOutputStream dos = new DataOutputStream(os);
        try {
            dos.writeInt(data.length);
            dos.writeInt(purpose);
            dos.write(data);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return this.verifyRaw(os.toByteArray(), publicKey);
    }

    public static EcdsaSignature fromString(String value) {
        byte[] data = new byte[64];
        if (!Strings.stringToData(value, data)) {
            throw new AssertionError();
        }
        EcdsaSignature sig = new EcdsaSignature();
        System.arraycopy(data, 0, sig.r, 0, 32);
        System.arraycopy(data, 32, sig.s, 0, 32);
        return sig;
    }

    public String toString() {
        byte[] sigData = new byte[64];
        System.arraycopy(this.r, 0, sigData, 0, 32);
        System.arraycopy(this.s, 0, sigData, 32, 32);
        return Strings.dataToString(sigData);
    }

    public static EcdsaSignature randomGarbage() {
        EcdsaSignature sig = new EcdsaSignature();
        SecureRandom r = new SecureRandom();
        r.nextBytes(sig.r);
        r.nextBytes(sig.s);
        return sig;
    }
}

