/* Copyright (C) 2022-2024 Free Software Foundation

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses>.  */

package org.gprofng.mpmt.collect;

import org.gprofng.analyzer.AnEnvironment;
import org.gprofng.mpmt.AnFile;
import org.gprofng.mpmt.AnLocale;
import org.gprofng.mpmt.ConfigurationPanel;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;

public class CollectorOpenPanel extends javax.swing.JPanel {

  private ConfigurationPanel configurationPanel;

  public CollectorOpenPanel(String experimentPath, String workingDir) {
    initComponents();
    setBackground(AnEnvironment.DEFAULT_PANEL_BACKGROUND);
    configurationOuterPanel.setBackground(AnEnvironment.DEFAULT_PANEL_BACKGROUND);
    label1.setText(
        AnLocale.getString("Data collection is complete. Do you want to open the experiment?"));
    experimentLabel.setText(AnLocale.getString("Experiment:"));
    pathTextField.setText(experimentPath);
    pathTextField.setToolTipText(experimentPath);
    //        pathTextField.setFont(pathTextField.getFont().deriveFont(Font.BOLD));
    pathTextField.setBorder(BorderFactory.createLineBorder(pathTextField.getBackground(), 5));
    //        pathTextField.setBorder(null);
    configurationOuterPanel.setLayout(new BorderLayout());
    configurationPanel = new ConfigurationPanel(false);
    configurationPanel.setBackground(AnEnvironment.DEFAULT_PANEL_BACKGROUND);
    configurationOuterPanel.add(configurationPanel, BorderLayout.CENTER);

    AnFile file = new AnFile(experimentPath);
    if (file.exists()) {
      configurationPanel.initConfigurationChoices(file);
      configurationPanel.setWorkingDirectory(workingDir);
    }
  }

  public String getWorkingDirectory() {
    return configurationPanel.getWorkingDirectory();
  }

  public String getConfiguration() {
    return configurationPanel.getConfiguration();
  }

  public boolean alwaysUseThisConfiguration() {
    return configurationPanel.alwaysUseThisConfiguration();
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT
   * modify this code. The content of this method is always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    label1 = new javax.swing.JLabel();
    experimentLabel = new javax.swing.JLabel();
    pathTextField = new javax.swing.JTextField();
    configurationOuterPanel = new javax.swing.JPanel();

    setLayout(new java.awt.GridBagLayout());

    label1.setText("jLabel1");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 0;
    gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
    add(label1, gridBagConstraints);

    experimentLabel.setText("jLabel3");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 1;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
    gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
    add(experimentLabel, gridBagConstraints);

    pathTextField.setEditable(false);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 2;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(4, 0, 0, 0);
    add(pathTextField, gridBagConstraints);

    javax.swing.GroupLayout configurationOuterPanelLayout =
        new javax.swing.GroupLayout(configurationOuterPanel);
    configurationOuterPanel.setLayout(configurationOuterPanelLayout);
    configurationOuterPanelLayout.setHorizontalGroup(
        configurationOuterPanelLayout
            .createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE));
    configurationOuterPanelLayout.setVerticalGroup(
        configurationOuterPanelLayout
            .createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE));

    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.gridx = 0;
    gridBagConstraints.gridy = 3;
    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
    gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
    gridBagConstraints.weightx = 1.0;
    gridBagConstraints.weighty = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(4, 0, 12, 0);
    add(configurationOuterPanel, gridBagConstraints);
  } // </editor-fold>//GEN-END:initComponents

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel configurationOuterPanel;
  private javax.swing.JLabel experimentLabel;
  private javax.swing.JLabel label1;
  private javax.swing.JTextField pathTextField;
  // End of variables declaration//GEN-END:variables
}
