/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;

public class BlockParentHandler
extends ExpressionHandler {
    private static final int[] CHECKED_CHILDREN = new int[]{10, 28, 6, 87};

    public BlockParentHandler(IndentationCheck aIndentCheck, String aName, DetailAST aAst, ExpressionHandler aParent) {
        super(aIndentCheck, aName, aAst, aParent);
    }

    protected DetailAST getToplevelAST() {
        return this.getMainAst();
    }

    protected void checkToplevelToken() {
        DetailAST toplevel = this.getToplevelAST();
        if (toplevel == null || this.expandedTabsColumnNo(toplevel) == this.getLevel()) {
            return;
        }
        if (!this.toplevelMustStartLine() && !this.startsLine(toplevel)) {
            return;
        }
        this.logError(toplevel, "", this.expandedTabsColumnNo(toplevel));
    }

    protected boolean toplevelMustStartLine() {
        return true;
    }

    protected boolean hasCurlys() {
        return this.getLCurly() != null && this.getRCurly() != null;
    }

    protected DetailAST getLCurly() {
        return this.getMainAst().findFirstToken(7);
    }

    protected DetailAST getRCurly() {
        DetailAST slist = this.getMainAst().findFirstToken(7);
        if (slist == null) {
            return null;
        }
        return slist.findFirstToken(73);
    }

    protected void checkLCurly() {
        DetailAST lcurly = this.getLCurly();
        if (lcurly == null || this.expandedTabsColumnNo(lcurly) == this.curlyLevel() || !this.startsLine(lcurly)) {
            return;
        }
        this.logError(lcurly, "lcurly", this.expandedTabsColumnNo(lcurly));
    }

    private int curlyLevel() {
        return this.getLevel() + this.getIndentCheck().getBraceAdjustement();
    }

    protected boolean rcurlyMustStart() {
        return true;
    }

    protected boolean childrenMayNest() {
        return false;
    }

    protected void checkRCurly() {
        DetailAST lcurly = this.getLCurly();
        DetailAST rcurly = this.getRCurly();
        if (rcurly == null || this.expandedTabsColumnNo(rcurly) == this.curlyLevel() || !this.rcurlyMustStart() && !this.startsLine(rcurly) || ExpressionHandler.areOnSameLine(rcurly, lcurly)) {
            return;
        }
        this.logError(rcurly, "rcurly", this.expandedTabsColumnNo(rcurly));
    }

    protected DetailAST getNonlistChild() {
        return (DetailAST)this.getMainAst().findFirstToken(77).getNextSibling();
    }

    private void checkNonlistChild() {
        DetailAST nonlist = this.getNonlistChild();
        if (nonlist == null) {
            return;
        }
        this.checkExpressionSubtree(nonlist, this.getLevel() + this.getIndentCheck().getBasicOffset(), false, false);
    }

    protected DetailAST getListChild() {
        return this.getMainAst().findFirstToken(7);
    }

    protected DetailAST getRParen() {
        return this.getMainAst().findFirstToken(77);
    }

    protected DetailAST getLParen() {
        return this.getMainAst().findFirstToken(76);
    }

    protected void checkRParen() {
        DetailAST rparen = this.getRParen();
        if (rparen == null) {
            return;
        }
        int rparenLevel = this.expandedTabsColumnNo(rparen);
        if (rparenLevel == this.getLevel() || !this.startsLine(rparen)) {
            return;
        }
        DetailAST lparen = this.getLParen();
        int lparenLevel = this.expandedTabsColumnNo(lparen);
        if (rparenLevel == lparenLevel + 1) {
            return;
        }
        this.logError(rparen, "rparen", this.expandedTabsColumnNo(rparen));
    }

    protected void checkLParen() {
        DetailAST lparen = this.getLParen();
        if (lparen == null || this.expandedTabsColumnNo(lparen) == this.getLevel() || !this.startsLine(lparen)) {
            return;
        }
        this.logError(lparen, "lparen", this.expandedTabsColumnNo(lparen));
    }

    public void checkIndentation() {
        DetailAST listChild;
        this.checkToplevelToken();
        this.checkLParen();
        this.checkRParen();
        if (this.hasCurlys()) {
            this.checkLCurly();
            this.checkRCurly();
        }
        if ((listChild = this.getListChild()) != null) {
            if (!this.hasCurlys() || !ExpressionHandler.areOnSameLine(this.getLCurly(), this.getRCurly())) {
                this.checkChildren(listChild, CHECKED_CHILDREN, this.getChildrenExpectedLevel(), true, this.childrenMayNest());
            }
        } else {
            this.checkNonlistChild();
        }
    }

    protected int getChildrenExpectedLevel() {
        return this.getLevel() + this.getIndentCheck().getBasicOffset();
    }
}

