/******************************************************************* 
**
** EHTS was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**
** at The University of Aalborg in Denmark spring 1990, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify EHTS without charge, but are not authorized
** to license or distribute it to anyone else except as part of a
** product or program developed by the user.
**   
** EHTS IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
** WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
** PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE
** PRACTICE.
** 
** EHTS is provided with no support and without any obligation on the
** part of the authors, to assist in its use, correction, modification
** or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY EHTS OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

/** include files **/

#include <math.h>

#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/canvas.h>
#include <xview/scrollbar.h>
#include <xview/xv_xrect.h>
#include <xview/font.h>
#include <xview/cursor.h>
#include <xview/svrimage.h>
#include <xview/notice.h>

#include "browser.h"

/** extern definitions **/

extern Frame baseframe;
extern Panel basepanel;
extern Canvas canvas;
extern Frame rename_frame;

extern HBNODE *node_root; /* root pointer to the node list */
extern HBLINK *link_root; /* root pointer to the link list */


extern int delete_node_dragging;  /* for the canvas repait options */
extern int delete_links_draggnig; /* --- */
extern int show_dragging;	  /* --- */
extern int update_all_canvas;	  /* --- */
extern int show_dir_in_hierarchy; /* --- */

extern int data_to_ehts;	/* Global variabels for EHTS options */
extern int nodeatt_to_ehts;	/* --- */
extern int linkatt_to_ehts;	/* --- */


/** Global variable **/

Xv_Font fixed_font;		/* The font we use */
Pixwin *canvaspw;

Menu action_menu;		/* menu when outside of node */
Menu action_node_menu;		/* menu when in node */
Menu action_node_dir_menu;	/* menu when in node and node is a DIR */

int dragging = FALSE;		/* are we dragging or not */
HBNODE *node_ptr;		/* the actual node */
HBNODE *node_dir_ptr;		/* points to the current dir pos */
HBNODE *node_hierarchy_ptr;	/* where to in the hierarchy */
int x_pos, y_pos;		/* mouse event possions */
int cd_from_first_root = FALSE;	/* this is not nice... but ??? */

struct level_struct *levelstack = NULL; /* the level stack */


/*******************************************************************
** make_arrow() --- make a arrow from one node to another
*******************************************************************/

make_arrow(display, xid, gc, fx, fy, tx, ty)
Display *display;
Window xid;
GC gc;
int fx, fy, tx, ty;
{
  double length;
  double x, y;
  double mx, my;
  XPoint points[3];
  
  /** the line **/
  x = (double)(tx - fx);
  y = (double)(ty - fy);
  length = sqrt((x * x) + (y * y));

  fx = fx + ceil((3+CIR_RAD) * (((double)(tx - fx))/length));
  fy = fy + ceil((3+CIR_RAD) * (((double)(ty - fy))/length));
  tx = tx + ceil((3+CIR_RAD) * (((double)(fx - tx))/length));
  ty = ty + ceil((3+CIR_RAD) * (((double)(fy - ty))/length));

  XDrawLine(display, xid, gc, fx, fy, tx, ty);

  /** the arrow head **/
  x = (double)(tx - fx);
  y = (double)(ty - fy);
  length = sqrt((x * x) + (y * y));
  mx = x/length;
  my = y/length;

  points[0].x = (short)tx;
  points[0].y = (short)ty;
  points[1].x = (short)(tx + ceil(-8*mx - 4*my));
  points[1].y = (short)(ty + ceil(-8*my + 4*mx));
  points[2].x = (short)(tx + ceil(-8*mx + 4*my));
  points[2].y = (short)(ty + ceil(-8*my - 4*mx));
  points[3].x = (short)tx;
  points[3].y = (short)ty;
  
  XFillPolygon(display, xid, gc, &points[0], 4, Nonconvex, CoordModeOrigin);
}


/*******************************************************************
** set_not_all_links() --- set the arrow indicating non shown links
*******************************************************************/

set_not_all_links(node, display, xid, gc)
HBNODE *node;
Display *display;
Window xid;
GC gc;
{
  int fx, fy, tx, ty;
  double length;
  double x, y;
  double mx, my;
  XPoint points[3];
  
  fx = node->x_coor - 5;
  fy = ty = node->y_coor + 7;
  tx = node->x_coor + 18;
  
  XDrawLine(display, xid, gc, fx, fy, tx, ty);

  /** the arrow head **/
  x = (double)(tx - fx);
  y = (double)(ty - fy);
  length = sqrt((x * x) + (y * y));
  mx = x/length;
  my = y/length;

  points[0].x = (short)tx;
  points[0].y = (short)ty;
  points[1].x = (short)(tx + ceil(-4*mx - 4*my));
  points[1].y = (short)(ty + ceil(-4*my + 4*mx));
  points[2].x = (short)(tx + ceil(-4*mx + 4*my));
  points[2].y = (short)(ty + ceil(-4*my - 4*mx));
  points[3].x = (short)tx;
  points[3].y = (short)ty;
  
  XFillPolygon(display, xid, gc, &points[0], 4, Nonconvex, CoordModeOrigin);
}


/*******************************************************************
** paint_node_and_links() 
*******************************************************************/

void paint_node_and_links(selectable, node_tmp_ptr, node_level_ptr, display, xid)
int selectable;
HBNODE *node_tmp_ptr;
HBNODE *node_level_ptr;
Display      *display;
Window        xid;
{
  GC gc;
  struct link_list *link_list_ptr;
  
  gc = DefaultGC(display, DefaultScreen(display));
  
  XSetFont(display, gc, (XID) xv_get(fixed_font, XV_XID));
  XSetLineAttributes(display, gc, 0, 0, 1, 1);
  
  
  if ((node_tmp_ptr->shown) || (show_dragging)) 
  {
    int x,y;
    
    x = node_tmp_ptr->x_coor;
    y = node_tmp_ptr->y_coor;
    
    if (node_tmp_ptr->type == DIR)
    {
      if (node_tmp_ptr->locked)
      {
	XSetLineAttributes(display, gc, 3, 0, 1, 1);
	XDrawLine(display, xid, gc, (x-CIR_RAD), (y-CIR_RAD),
		  (x-CIR_RAD), (y+CIR_RAD));
	XDrawLine(display, xid, gc, (x-CIR_RAD), (y-CIR_RAD),
		  (x+CIR_RAD), (y-CIR_RAD));
	XDrawLine(display, xid, gc, (x-CIR_RAD), (y+CIR_RAD),
		  (x+CIR_RAD), (y+CIR_RAD));
	XSetLineAttributes(display, gc, 0, 0, 1, 1);
      }
      else
      {
	XDrawLine(display, xid, gc, (x-CIR_RAD), (y-CIR_RAD),
		  (x-CIR_RAD), (y+CIR_RAD));
	XDrawLine(display, xid, gc, (x-CIR_RAD), (y-CIR_RAD),
		  (x+CIR_RAD), (y-CIR_RAD));
	XDrawLine(display, xid, gc, (x-CIR_RAD), (y+CIR_RAD),
		  (x+CIR_RAD), (y+CIR_RAD));
      }
    }
    
    if (selectable)
    {
      if (node_tmp_ptr->locked)
      {
	XSetLineAttributes(display, gc, 3, 0, 1, 1);
	XDrawArc(display, xid, gc, (x-CIR_RAD), (y-CIR_RAD),
		 (2 * CIR_RAD), (2 * CIR_RAD), 2880, 17279);
	XSetLineAttributes(display, gc, 0, 0, 1, 1);
      }
      else
	XDrawArc(display, xid, gc, (x-CIR_RAD), (y-CIR_RAD),
		 (2 * CIR_RAD), (2 * CIR_RAD), 2880, 17279);
    }
    
    XDrawString(display, xid, gc, (x-5), (y+3), node_tmp_ptr->name,
		strlen(node_tmp_ptr->name));
    
    link_list_ptr = node_tmp_ptr->link_num;
    
    while (link_list_ptr != NULL) /* make all links from node */
    {
      int nodenum;
      int num = link_list_ptr->num;
      HBLINK *link_ptr;
      HBNODE *node_ptr;
      
      link_ptr = link_root;
      while (link_ptr->num != num) /* find the link */
	link_ptr = link_ptr->next;
      nodenum = link_ptr->to_node;
      
      if((node_ptr = (HBNODE *)find_dir_node(nodenum, node_level_ptr)) == NULL)
	set_not_all_links(node_tmp_ptr, display, xid, gc);
      else			/* have found the node */
      {
	if ((node_ptr->shown) || (!delete_links_draggnig))
	  make_arrow(display, xid, gc,
		     node_tmp_ptr->x_coor, node_tmp_ptr->y_coor, /* from */
		     node_ptr->x_coor, node_ptr->y_coor); /* to */
      }
      link_list_ptr = link_list_ptr->next;
    }
  }
}


/*******************************************************************
** repaint_proc() --- repaint the canvas
*******************************************************************/

void repaint_proc(canvas, paint_window, display, xid, xrects)
Canvas        canvas;         /* unused */
Xv_Window     paint_window;   /* unused */
Display      *display;
Window        xid;
Xv_xrectlist *xrects;         /* unused */
{
  HBNODE *node_tmp_ptr;
  HBNODE *node_level_ptr;
  
  if((node_dir_ptr == node_root) && (cd_from_first_root == FALSE))
    node_level_ptr = node_dir_ptr;
  else
    node_level_ptr = node_dir_ptr->dir;
    
  if (show_dir_in_hierarchy)
    paint_node_and_links(FALSE, node_dir_ptr, node_level_ptr, display, xid);
    
  for(node_tmp_ptr = node_level_ptr;
      (node_tmp_ptr != NULL); node_tmp_ptr = node_tmp_ptr->next)
    paint_node_and_links(TRUE, node_tmp_ptr, node_level_ptr, display, xid);
}


/*******************************************************************
** pop(), push() --- the level stack
*******************************************************************/

pop_level()
{
  if (levelstack != NULL)
  {
    struct level_struct *level_tmp;

    level_tmp = levelstack;
    levelstack = levelstack->next;
    node_dir_ptr = level_tmp->node_ptr;
    free(level_tmp);
  }
}

push_level(tmp)
HBNODE *tmp;
{
  struct level_struct *level_tmp;

  level_tmp = (struct level_struct *)malloc(sizeof(struct level_struct));

  level_tmp->node_ptr = tmp;
  level_tmp->next = levelstack;
  levelstack = level_tmp;
}

 
/*******************************************************************
** redraw_all_paintwin() --- call the repaint rutine for all windows
*******************************************************************/

redraw_all_paintwin()
{
  Xv_Window W;
  
  CANVAS_EACH_PAINT_WINDOW(canvas, W)
    XClearWindow((Display *)xv_get(W, XV_DISPLAY), xv_get(W, XV_XID));
  repaint_proc((Canvas)NULL, W, (Display *)xv_get(W, XV_DISPLAY),
	       xv_get(W, XV_XID), (Xv_xrectlist *)NULL);
  CANVAS_END_EACH
}


/*******************************************************************
** action_notify_proc() --- parse action when not in node
*******************************************************************/

void action_notify_proc(menu, menu_item)
Menu menu;
Menu_item menu_item;
{
  Frame subframe;
  Panel subpanel;
  
  if (!strcmp(xv_get(menu_item, MENU_STRING), "Previous level"))
  {
    pop_level();
    print_right_footer(node_dir_ptr->name);
    redraw_all_paintwin();
  }
  else if (!strcmp(xv_get(menu_item, MENU_STRING), "Top level"))
  {
    push_level(node_dir_ptr);
    node_dir_ptr = node_root;
    print_right_footer("Top Level");
    cd_from_first_root = FALSE;
    redraw_all_paintwin();
  }
  print_left_footer("");
}


/*******************************************************************
** action_notify_node_proc() --- parse action when in node
*******************************************************************/

void action_notify_node_proc(menu, menu_item)
Menu menu;
Menu_item menu_item;
{
  if (!strcmp(xv_get(menu_item, MENU_STRING), "Attributes"))
  {
    if (nodeatt_to_ehts)
      send_nodeatt_to_ehts(node_ptr->num);
    else
    {
      if (node_ptr->att_frame == NULL)
	read_node_attributes(node_ptr);
      xv_set(baseframe, FRAME_BUSY, TRUE, NULL);
      xv_set(node_ptr->att_frame, XV_SHOW, TRUE, NULL);
      xv_set(baseframe, FRAME_BUSY, FALSE, NULL);
    }
  }
  else if(!strcmp(xv_get(menu_item, MENU_STRING), "Show data"))
  {
    if (data_to_ehts)
      send_data_to_ehts(node_ptr->num);
    else
      edit_node(node_ptr);
  }
  else if(!strcmp(xv_get(menu_item, MENU_STRING), "Make node DIR"))
  {
    node_ptr->type = DIR;
    redraw_all_paintwin();
  }
  else if(!strcmp(xv_get(menu_item, MENU_STRING), "Make dir NODE"))
  {
    node_ptr->type = NODE;
    redraw_all_paintwin();
  }
  else if(!strcmp(xv_get(menu_item, MENU_STRING), "Delete node"))
  {
    int ret;
    int *linklist, len;

    hb_Read(node_ptr->num, 516, &linklist, &len);
    
    if ((ret = hb_Delete(node_ptr->num)) != 0)
    {
      if (ret == 350)
	notice_prompt(canvas, NULL,
		      NOTICE_MESSAGE_STRINGS, "Can't delete locked node !!!",
		      NULL,
		      NOTICE_BUTTON_YES, "OK", NULL);
      else if (ret == -204)
	notice_prompt(canvas, NULL,
		      NOTICE_MESSAGE_STRINGS,
		      "Can't delete node when still referenced !!!", NULL,
		      NOTICE_BUTTON_YES, "OK", NULL);
    }
    else
    {
      for( ; len > 0; len -= 4)
      {
	hb_Delete(*linklist);
	delete_link(*linklist);
	linklist++;
      }
    }
  }
  else if((!strcmp(xv_get(menu_item, MENU_STRING), "Rename node")) ||
	  (!strcmp(xv_get(menu_item, MENU_STRING), "Rename dir")))
  {
    xv_destroy(rename_frame);
    rename_node();
    xv_set(rename_frame, XV_SHOW, TRUE, NULL);
  }
  else if((!strcmp(xv_get(menu_item, MENU_STRING), "Move dir to top level")) ||
	  (!strcmp(xv_get(menu_item, MENU_STRING), "Move node to top level")))
  {
    move_node(node_ptr->num, 0);
    redraw_all_paintwin();
  }
  else
  {
    print_right_footer(xv_get(menu_item, MENU_STRING));
    sleep(1);
    print_right_footer("");
  }
}

/*******************************************************************
** rename_proc()
*******************************************************************/

rename_proc(item,event)
Panel_item item;
Event *event;
{
  char *name;

  name = (char *)xv_get(item,PANEL_VALUE);

  hb_Write(node_ptr->num, 7, name, (strlen(name)+1)); /* 7 = NNAME */

  xv_set(rename_frame, XV_SHOW, FALSE, NULL);
}


/*******************************************************************
** action_notify_link_proc() --- find link and display attributes
*******************************************************************/

action_notify_link_proc(menu, menu_item)
Menu menu;
Menu_item menu_item;
{
  HBLINK *link_ptr;
  
  for (link_ptr = link_root;	/* find link */
       strcmp(link_ptr->name, xv_get(menu_item, MENU_STRING));
       link_ptr = link_ptr->next);

  if (linkatt_to_ehts)
    send_linkatt_to_ehts(link_ptr->num,node_ptr->num);
  else
  {
    if (link_ptr->att_frame == NULL)
      read_link_attributes(link_ptr);
    
    xv_set(baseframe, FRAME_BUSY, TRUE, NULL);
    xv_set(link_ptr->att_frame, XV_SHOW, TRUE, NULL);
    xv_set(baseframe, FRAME_BUSY, FALSE, NULL);
  }
  
}


/*******************************************************************
** action_hierarchy_proc()
*******************************************************************/

action_hierarchy_proc(menu, menu_item)
Menu menu;
Menu_item menu_item;
{
  HBNODE *node_to;
  
  node_to = (HBNODE *)find_name_node(xv_get(menu_item, MENU_STRING),
				      node_root);
  
  if ((node_to != NULL) && (node_ptr->num != node_to->num))
  {
    move_node(node_ptr->num, node_to->num);
    redraw_all_paintwin();
    /* test_move(node_root); */
  }
  else
  {
    print_left_footer("Can't move node ...");
    sleep(2);
    print_left_footer("");
  }
}



/*******************************************************************
** action_hierarchy_cd_proc()
*******************************************************************/

action_hierarchy_cd_proc(menu, menu_item)
Menu menu;
Menu_item menu_item;
{
  push_level(node_dir_ptr);
  
  node_dir_ptr = (HBNODE *)find_name_node(xv_get(menu_item, MENU_STRING),
					  node_root);
    
  if (node_root == node_dir_ptr)
    cd_from_first_root = TRUE;
  else
    cd_from_first_root = FALSE;
  
  redraw_all_paintwin();
  
  print_right_footer(xv_get(menu_item, MENU_STRING));
}



/*******************************************************************
** create_cursor() --- make a cursor thats is an image of the node
*******************************************************************/

create_cursor(window, actual_node)
Xv_Window window;
HBNODE *actual_node;
{
  Xv_Cursor      cursor;
  Server_image   image;
  Pixmap         pixmap;
  Display        *dpy;
  GC             gc;
  XGCValues      gcvalues;
  int cir_dia;

  dpy = (Display *)xv_get(window, XV_DISPLAY);
  
  image = (Server_image)xv_create(XV_NULL, SERVER_IMAGE,
				  XV_WIDTH, 200,
				  XV_HEIGHT, 21,
				  NULL);

  pixmap = (Pixmap)xv_get(image, XV_XID);

  /* Create GC with reversed foreground and background colors to
   * clear pixmap first.  Use 1 and 0 because pixmap is 1-bit deep.
   */

  gcvalues.foreground = 0;
  gcvalues.background = 1;
  gc = XCreateGC(dpy, pixmap, GCForeground|GCBackground, &gcvalues);
  XFillRectangle(dpy, pixmap, gc, 0, 0, 200, 21);

  /* Reset foreground and background values for XDrawArc() routines. */

  gcvalues.foreground = 1;
  gcvalues.background = 0;
  XChangeGC(dpy, gc, GCForeground | GCBackground, &gcvalues);

  cir_dia = 2 * CIR_RAD;
  
  if (actual_node->locked)
  {
    XSetLineAttributes(dpy, gc, 3, 0, 1, 1);
    XDrawArc(dpy, pixmap, gc, 0, 0, cir_dia, cir_dia, 2880, 17279);
    XSetLineAttributes(dpy, gc, 0, 0, 1, 1);
  }
  else
    XDrawArc(dpy, pixmap, gc, 0, 0, cir_dia, cir_dia, 2880, 17279);
  
  XDrawString(dpy, pixmap, gc, 5, 13, actual_node->name,
	      strlen(actual_node->name));  
  
  /* Creaste cursor and assign it to the window (parameter) */
  
  cursor = xv_create(XV_NULL, CURSOR,
		     CURSOR_IMAGE,   image,
		     CURSOR_XHOT,    10,
		     CURSOR_YHOT,    10,
		     NULL);

  xv_set(window, WIN_CURSOR, cursor, NULL);
  
  /* free the GC -- the cursor and the image must not be freed. */

  XFreeGC(dpy, gc);
}


/*******************************************************************
** normal_cursor() --- install the normal cursor
*******************************************************************/

void normal_cursor(window)
Xv_Window window;
{
  Xv_Cursor cursor;

  cursor = xv_create(NULL, CURSOR, CURSOR_SRC_CHAR, OLC_BASIC_PTR, NULL);
  xv_set(window,
	 WIN_CURSOR, cursor,
	 NULL);
}


/*******************************************************************
** canvas_event_proc() --- parse canvas events
*******************************************************************/

void canvas_event_proc(window, event)
Xv_Window window;
Event *event;
{
  HBNODE *node_level_ptr;

  if((node_dir_ptr == node_root) && (cd_from_first_root == FALSE))
    node_level_ptr = node_dir_ptr;
  else
    node_level_ptr = node_dir_ptr->dir;

  x_pos = event_x(event);
  y_pos = event_y(event);
  
  switch (event_action(event))
  {
  case ACTION_SELECT:
  case MS_LEFT:
    if (!dragging)
    {
      for(node_ptr = node_level_ptr;
	  ((!dragging) && (node_ptr != NULL)); node_ptr = node_ptr->next)
      {
	if (((x_pos > (node_ptr->x_coor - CIR_RAD)) &&
	     (x_pos < (node_ptr->x_coor + CIR_RAD))) &&
	    ((y_pos > (node_ptr->y_coor - CIR_RAD)) &&
	     (y_pos < (node_ptr->y_coor + CIR_RAD))))
	{
	  print_left_footer("Move the node ...");
	  create_cursor(window, node_ptr);
	  node_ptr->shown = FALSE;

	  if(delete_node_dragging)
	  {
	    XClearWindow((Display *)xv_get(window, XV_DISPLAY),
			 xv_get(window, XV_XID));
	    repaint_proc((Canvas)NULL, window,
			 (Display *)xv_get(window, XV_DISPLAY),
			 xv_get(window, XV_XID), (Xv_xrectlist *)NULL);
	  }
	  
	  dragging = TRUE;
	}
      }
    }
    else			/* is dragging */
    {				/* find the draged node */
      for(node_ptr = node_level_ptr; (node_ptr->shown == TRUE);
	  node_ptr = node_ptr->next);
      
      if ((x_pos > CIR_RAD) &&	/* check the bound (canvas size) */
	  (y_pos > CIR_RAD) &&
	  (x_pos < (EHTS_WIDTH - CIR_RAD)) &&
	  (y_pos < (EHTS_HEIGHT - CIR_RAD)))
      {
	node_ptr->x_coor = x_pos;
	node_ptr->y_coor = y_pos;
      }
      
      node_ptr->shown = TRUE;

      normal_cursor(window); 

      redraw_all_paintwin();
      
      dragging = FALSE;
      print_left_footer("");
    }
    break;
  case ACTION_ADJUST:
  case MS_MIDDLE:
    for(node_ptr = node_level_ptr; (node_ptr != NULL);
	node_ptr = node_ptr->next)
    {
      if (((x_pos > (node_ptr->x_coor - CIR_RAD)) &&
	   (x_pos < (node_ptr->x_coor + CIR_RAD))) &&
	  ((y_pos > (node_ptr->y_coor - CIR_RAD)) &&
	   (y_pos < (node_ptr->y_coor + CIR_RAD))))
	if(node_ptr->type == DIR)
	{
	  push_level(node_dir_ptr);
	  node_dir_ptr = node_ptr;
	  if (node_root == node_dir_ptr)
	    cd_from_first_root = TRUE;
	  else
	    cd_from_first_root = FALSE;
	  redraw_all_paintwin();
	  print_right_footer(node_ptr->name);
	  break;
	}
    }
/*    if (node_ptr == NULL)
    {
      pop_level();
      print_right_footer(node_dir_ptr->name);
      redraw_all_paintwin();
    } */
    break;
  case ACTION_MENU:
  case MS_RIGHT:
    for(node_ptr = node_level_ptr; node_ptr != NULL; node_ptr = node_ptr->next)
    {
      if (((x_pos > (node_ptr->x_coor - CIR_RAD)) &&
	   (x_pos < (node_ptr->x_coor + CIR_RAD))) &&
	  ((y_pos > (node_ptr->y_coor - CIR_RAD)) &&
	   (y_pos < (node_ptr->y_coor + CIR_RAD))))
	break;
    }
    if (node_ptr == NULL)
      menu_show(action_menu, window, event, 0);
      
    else
    {
      char str[52];
      
      strcpy(str, " ");
      strcat(str, node_ptr->name);
      strcat(str, " ");
      xv_set(action_node_menu, MENU_TITLE_ITEM, str, NULL);
      xv_set(action_node_dir_menu, MENU_TITLE_ITEM, str, NULL);

      if (node_ptr->type == NODE)
	menu_show(action_node_menu, window, event, 0);
      if (node_ptr->type == DIR)
	menu_show(action_node_dir_menu, window, event, 0);
    }
    break;
  case LOC_DRAG:
    if (dragging)
    {
      if (show_dragging)
      {
	for(node_ptr = node_level_ptr; (node_ptr->shown == TRUE);
	    node_ptr = node_ptr->next);
      
	node_ptr->x_coor = x_pos;
	node_ptr->y_coor = y_pos;

	if (!update_all_canvas)
	  redraw_all_paintwin();
	else
	{
	  XClearWindow((Display *)xv_get(window, XV_DISPLAY),
		       xv_get(window, XV_XID)); 
	  repaint_proc((Canvas)NULL, window,
		       (Display *)xv_get(window, XV_DISPLAY),
		       xv_get(window, XV_XID), (Xv_xrectlist *)NULL);
	}
      }
    }
    break; 
  default:
    return;
  }
}

/*******************************************************************
** link_menu_gen()
*******************************************************************/

Menu link_menu_gen(menu_item, op)
Menu_item menu_item;
Menu_generate op;
{
  struct link_list *llptr;
  Menu link_menu;
  Menu_item mi;
  
  switch (op)
  {
  case MENU_DISPLAY:		/* make the link menu */
    link_menu = (Menu)xv_create(XV_NULL, MENU, NULL); 
    
    llptr = node_ptr->link_num;
    
    if (llptr == NULL)
    {
      mi = xv_create(XV_NULL, MENUITEM,
		     MENU_STRING, "No links!",
		     MENU_INACTIVE, TRUE,
		     NULL);
      xv_set(link_menu, MENU_APPEND_ITEM, mi, NULL);
    }
    else
    {
      while(llptr != NULL)
      {
	HBLINK *lsptr;
	
	for(lsptr = link_root;
	    lsptr->num != llptr->num; lsptr = lsptr->next);
	
	mi = xv_create(XV_NULL, MENUITEM,
		       MENU_STRING, lsptr->name,
		       MENU_RELEASE,
		       MENU_RELEASE_IMAGE,
		       MENU_NOTIFY_PROC, action_notify_link_proc,
		       NULL);
	xv_set(link_menu, MENU_APPEND_ITEM, mi, NULL);
	llptr = llptr->next;
      }	  
    }
    return link_menu;
  case MENU_DISPLAY_DONE:	/* destroy the link nemu */
  case MENU_NOTIFY_DONE:
    /* xv_destroy_safe(menu_item); */
    break;
  default:
    return;
  }
  return;
}


/*******************************************************************
** add_dir_to_cd_menu()
*******************************************************************/

Menu_item add_dir_to_cd_menu(node_local_ptr)
HBNODE *node_local_ptr;
{
  Menu_item mi;
  Menu next_menu;
  HBNODE *node_tmp;
  
  int cnt = 0;

  if (node_local_ptr == NULL)
    return NULL;
  
  next_menu = (Menu)xv_create(XV_NULL, MENU, NULL);

  for (node_tmp = node_local_ptr->dir;
       node_tmp != NULL; node_tmp = node_tmp->next)
  {
    if (node_tmp->type == DIR)
    {
      if ((mi = add_dir_to_cd_menu(node_tmp)) == NULL)
      {
	mi = xv_create(XV_NULL, MENUITEM,
		       MENU_STRING, node_tmp->name,
		       MENU_RELEASE,
		       MENU_RELEASE_IMAGE,
		       MENU_NOTIFY_PROC, action_hierarchy_cd_proc,
		       NULL);
      }
      xv_set(next_menu, MENU_APPEND_ITEM, mi, NULL);
      cnt++;
    }
  }
  
  mi = xv_create(XV_NULL, MENUITEM,
		 MENU_STRING, node_local_ptr->name, 
		 MENU_RELEASE,
		 MENU_RELEASE_IMAGE,
		 MENU_NOTIFY_PROC, action_hierarchy_cd_proc,
		 NULL);
  
  if (!cnt)
    xv_destroy(next_menu);
  else
  {
    xv_set(next_menu, MENU_TITLE_ITEM, node_local_ptr->name, NULL);
    xv_set(mi, MENU_PULLRIGHT, next_menu, NULL);
  }
  return mi;
}


/*******************************************************************
** add_dir_to_menu()
*******************************************************************/

Menu_item add_dir_to_menu(node_local_ptr)
HBNODE *node_local_ptr;
{
  Menu_item mi;
  Menu next_menu;
  HBNODE *node_tmp;
  
  int cnt = 0;

  if (node_local_ptr == NULL)
    return NULL;
  
  next_menu = (Menu)xv_create(XV_NULL, MENU, NULL);

  for (node_tmp = node_local_ptr->dir;
       node_tmp != NULL; node_tmp = node_tmp->next)
  {
    if (node_tmp->type == DIR)
    {
      if ((mi = add_dir_to_menu(node_tmp)) == NULL)
      {
	mi = xv_create(XV_NULL, MENUITEM,
		       MENU_STRING, node_tmp->name,
		       MENU_RELEASE,
		       MENU_RELEASE_IMAGE,
		       MENU_NOTIFY_PROC, action_hierarchy_proc,
		       NULL);
      }
      xv_set(next_menu, MENU_APPEND_ITEM, mi, NULL);
      cnt++;
    }
  }
  
  mi = xv_create(XV_NULL, MENUITEM,
		 MENU_STRING, node_local_ptr->name, 
		 MENU_RELEASE,
		 MENU_RELEASE_IMAGE,
		 MENU_NOTIFY_PROC, action_hierarchy_proc,
		 NULL);
  
  if (!cnt)
    xv_destroy(next_menu);
  else
  {
    xv_set(next_menu, MENU_TITLE_ITEM, node_local_ptr->name, NULL);
    xv_set(mi, MENU_PULLRIGHT, next_menu, NULL);
  }
  return mi;
}


/*******************************************************************
** hierarchy_menu_gen()
*******************************************************************/

Menu hierarchy_menu_gen(menu_item, op)
Menu_item menu_item;
Menu_generate op;
{
  if (op == MENU_DISPLAY)
  {
    Menu_item mi;
    Menu hierarchy;
    HBNODE *node_dir;

    hierarchy = (Menu)xv_create(XV_NULL, MENU, NULL);

    xv_set(hierarchy, MENU_TITLE_ITEM, "Top Level", NULL);

    for (node_dir = node_root; ((node_dir != NULL) && (node_dir->type != DIR));
	 node_dir = node_dir->next);

    if (node_dir == NULL)
    {
      mi = xv_create(XV_NULL, MENUITEM,
		     MENU_STRING, "No Hierarchy!",
		     MENU_INACTIVE, TRUE,
		     MENU_RELEASE,
		     MENU_RELEASE_IMAGE,
		     NULL);
      xv_set(hierarchy, MENU_APPEND_ITEM, mi, NULL);
    }
    else
    {
      for (node_dir = node_root; (node_dir != NULL);
	   node_dir = node_dir->next)
      {
	if (node_dir->type == DIR)
	{
	  mi = add_dir_to_menu(node_dir);
	  xv_set(hierarchy, MENU_APPEND_ITEM, mi, NULL);
	}
      }
    }
    return(hierarchy);
  }
}


/*******************************************************************
** hierarchy_cd_menu_gen()
*******************************************************************/

Menu hierarchy_cd_menu_gen(menu_item, op)
Menu_item menu_item;
Menu_generate op;
{
  if (op == MENU_DISPLAY)
  {
    Menu_item mi;
    Menu hierarchy;
    HBNODE *node_dir;

    hierarchy = (Menu)xv_create(XV_NULL, MENU, NULL);

    xv_set(hierarchy, MENU_TITLE_ITEM, "Top Level", NULL);

    for (node_dir = node_root; ((node_dir != NULL) && (node_dir->type != DIR));
	 node_dir = node_dir->next);

    if (node_dir == NULL)
    {
      mi = xv_create(XV_NULL, MENUITEM,
		     MENU_STRING, "No Hierarchy!",
		     MENU_INACTIVE, TRUE,
		     MENU_RELEASE,
		     MENU_RELEASE_IMAGE,
		     NULL);
      xv_set(hierarchy, MENU_APPEND_ITEM, mi, NULL);
    }
    else
    {
      for (node_dir = node_root; (node_dir != NULL);
	   node_dir = node_dir->next)
      {
	if (node_dir->type == DIR)
	{
	  mi = add_dir_to_cd_menu(node_dir);
	  xv_set(hierarchy, MENU_APPEND_ITEM, mi, NULL);
	}
      }
    }
    return(hierarchy);
  }
}


/*******************************************************************
** setup_the_canvas() --- instrall the canvas
*******************************************************************/

void set_up_canvas()
{
  canvas = xv_create(baseframe, CANVAS,
		     XV_X, 0,	/* place to the left */
		     WIN_BELOW, basepanel, /* below the panel */
		     CANVAS_X_PAINT_WINDOW, TRUE, /* for Xlib */
		     CANVAS_WIDTH,  EHTS_WIDTH,
		     CANVAS_HEIGHT, EHTS_HEIGHT,
		     CANVAS_AUTO_SHRINK, FALSE,
		     CANVAS_AUTO_EXPAND, FALSE, 
		     CANVAS_REPAINT_PROC, repaint_proc,
		     NULL);

  canvaspw=(Pixwin *)canvas_paint_window(canvas);
  xv_set(canvaspw,
	 WIN_CONSUME_EVENTS,
	    WIN_MOUSE_BUTTONS, LOC_DRAG, NULL,
	 WIN_EVENT_PROC, canvas_event_proc,
	 NULL);

  xv_create(canvas, SCROLLBAR,
	    SCROLLBAR_SPLITTABLE, TRUE,
	    SCROLLBAR_DIRECTION, SCROLLBAR_VERTICAL,
	    SCROLLBAR_PIXELS_PER_UNIT, EHTS_DELTA_PIXELS,
	    NULL);
  
  xv_create(canvas, SCROLLBAR,
	    SCROLLBAR_SPLITTABLE, TRUE,
	    SCROLLBAR_DIRECTION, SCROLLBAR_HORIZONTAL,
	    SCROLLBAR_PIXELS_PER_UNIT, EHTS_DELTA_PIXELS,
	    NULL);

  action_menu = (Menu)xv_create(canvas, MENU,
				MENU_TITLE_ITEM, APP_NAME,
				MENU_STRINGS, "Previous level",
				     "Top level", NULL,
				MENU_GEN_PULLRIGHT_ITEM, "Goto level",
				     hierarchy_cd_menu_gen,
				MENU_NOTIFY_PROC, action_notify_proc,
				NULL);
  
  action_node_menu = (Menu)xv_create(canvas, MENU,
				MENU_TITLE_ITEM, "",
				MENU_STRINGS, "Show data", "Rename node",
				     "Delete node", "Make node DIR",
				     "Attributes", "Move node to top level",
				     NULL,
				MENU_GEN_PULLRIGHT_ITEM, "Move node to...",
				     hierarchy_menu_gen,
				MENU_GEN_PULLRIGHT_ITEM, "Link attributes",
				     link_menu_gen,
				MENU_NOTIFY_PROC, action_notify_node_proc,
				NULL);

  action_node_dir_menu = (Menu)xv_create(canvas, MENU,
				MENU_TITLE_ITEM, "",
				MENU_STRINGS, "Show data", "Rename dir",
				     "Delete node", "Make dir NODE",
				     "Attributes", "Move dir to top level",
				     NULL,
				MENU_GEN_PULLRIGHT_ITEM, "Move dir to...",
				     hierarchy_menu_gen,
				MENU_GEN_PULLRIGHT_ITEM, "Link attributes",
				     link_menu_gen,
				MENU_NOTIFY_PROC, action_notify_node_proc,
				NULL);

  xv_set(action_node_menu, MENU_TITLE_ITEM, "No Title", NULL);

  fixed_font = (Xv_Font)xv_find(XV_NULL, FONT, FONT_NAME, "6x13", NULL);
  if (!fixed_font)
  {
    fprintf(stderr, "Cannot load font: 6x13.\n");
    fixed_font = (Xv_Font)xv_get(baseframe, XV_FONT);
  }
}


