/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#include "baltree.hh"
#include "../config/hb_config.hh"
#include "Lock.hh"

/*******************************************************************
** Global variables
*******************************************************************/

LockClass LockTree;

/*******************************************************************
** Check parametre
*******************************************************************/

int CheckPar(long ent, int opr, int key)
{
  if (ent < 0)
    return WRONG_NODE;
  if ((opr < 0) || (opr > NO_OPERATION))
    return WRONG_OPERATION;
  if ((key < 0) || (key > NO_OF_KEYS))
    return WRONG_KEY;
  return OK;
}

/*******************************************************************
** Anny keys locked
*******************************************************************/

int AnnyKeyLocked(long ent_no)
{
  int i;
  Lock* tmp;
  
  tmp = LockTree.search(ent_no);
  if (tmp == NULL)
    return FALSE;
  else
  {
    for (i=ALL;i< NO_OF_KEYS;i++)
    {
      if (tmp->Keys[i] != NL)
	return TRUE;
    }
    return FALSE;
  }
}


/*******************************************************************
** Fuction for check Locked Entety
*******************************************************************/

int IsLockedUser(long ent_no,int UserID,int key)
{
  Lock* tmp;
  
  int test;
  test = CheckPar( ent_no, ALL, key);
  if(test == OK)
  {
    tmp=LockTree.search(ent_no);
    if (tmp == NULL)
      return FALSE;
    else
    {
      if((tmp->Keys[key]==UserID) || (tmp->Keys[key]==NL))
	return FALSE;
      else
	return TRUE;
    }
  }
  else
    return test;
}

/*******************************************************************
** Functions for LOCK
*******************************************************************/

int IsLocked(long ent_no,int key)
{
  Lock* tmp;
  int i;
  
  tmp=LockTree.search(ent_no);
  if (tmp == NULL)
    return FALSE;
  if(tmp->Keys[key] == NL)
  {
    if(key == ALL)
      for (i=ALL+1;i<NO_OF_KEYS;i++)
	if (tmp->Keys[key] != NL)
	  return TRUE;
    if(key == NODE)
      for (i=NODE+1;i<LINK;i++)
	if (tmp->Keys[key] != NL)
	  return TRUE;
    if(key == LINK)
      for (i=ALL+1;i<USER;i++)
	if (tmp->Keys[key] != NL)
	  return TRUE;
    return FALSE;
  }
  return TRUE;
}

int CheckFree(Lock* tmp,int keystart,int keyend,int UserID)
{
  int i;
  for(i=keystart;i<keyend;i++)
  {
    if(tmp->Keys[i] != NL)
      return FALSE;
  };
  for(i=keystart;i<keyend;i++)
  {
    tmp->Keys[i]=UserID;
  }    
  return TRUE;
}


int LockInsert(long ent_no,int UserID,int key) 
{
  Lock* tmp;
  int i;
  
  tmp=LockTree.search(ent_no);
  if (tmp == NULL)
  {
    tmp = new Lock;
    for(i=0;i<NO_OF_KEYS;i++)
      tmp->Keys[i] = NL;
    int t=LockTree.insert(ent_no,tmp);
  }
  if (key == ALL)
  {
    if (CheckFree(tmp,ALL,NO_OF_KEYS,UserID))
      return OK;
    else
      return LOCKED;
  }  
  else if (key == NODE)
  {
    if (CheckFree(tmp,NODE,LINK,UserID))
      return OK;
    else
      return LOCKED;
  }  
  else if (key == LINK)
  {
    if (CheckFree(tmp,LINK,USER,UserID))
      return OK;
    else
      return LOCKED;
  }
  else
  {
    if(tmp->Keys[key]==NL)
    {
      tmp->Keys[key] = UserID;
      return OK;
    }
    else
      return LOCKED;
  }
}


int LockNode(int UserID, long ent_no, int key)
{
  int ret;
  
  int test;
  test = CheckPar( ent_no, ALL, key);
  if(test == OK)
  {
    if(ent_no != ALL)
    {
      if(IsLocked(ent_no,key))
	return LOCKED;
      else
      {
	ret = LockInsert(ent_no,UserID,key);
	return ret;
      }
    }
    else
      return NOT_ALL_NODES;
  }
  else
    return test;
}

/*******************************************************************
** Functions for UNLOCK
*******************************************************************/

int UnLockNode(int UserID, long ent_no, int key)
{
  Lock* tmp;
  int i;
  
  int test;
  test = CheckPar( ent_no, ALL, key);
  if(test == OK)
  {
    if(ent_no != ALL)
    {
      if(IsLocked(ent_no,key))
      {
	tmp = LockTree.search(ent_no);
	if(tmp->Keys[key] != UserID)
	  return LOCK_BY_OTHER;
	else
	{
	  if (key == ALL)
	    LockTree.remove(ent_no);
	  else 
	  {
	    if (key == NODE)
	      for(i=NODE;i<LINK;i++)
		tmp->Keys[i] = NL;
	    else if (key == LINK)
	      for(i=LINK;i<USER;i++)
		tmp->Keys[i] = NL;
	    tmp->Keys[key] = NL;
	    for(i=0;i<NO_OF_KEYS;i++)
	      if(tmp->Keys[key] != NL)
		return OK;
	    LockTree.remove(ent_no);
	    return OK;
	  };
	};
      }
      else
	return NOT_LOCKED;
    }
    else
    {
      long i;
      int test;
      if (key != ALL)
      {
	for(i=LockTree.first();i!=0;i=LockTree.next(i))
	{
	  test =  UnLockNode(UserID,i,key);
	}
      }
      else
      {
	test = LockTree.clear();
      }
      return OK;
    }
  }
  else
    return test;
}

/*******************************************************************
** Functions for SHOWLOCK
*******************************************************************/

int ShowLockNode(int* UserID, long ent_no,int key)
{
  Lock* tmp;

  int test;
  test = CheckPar( ent_no, ALL, key);
  if(test == OK)
  {
    if(ent_no != ALL)
    {
      if(IsLocked(ent_no,key))
      {
	tmp = LockTree.search(ent_no);
	*UserID = tmp->Keys[key];
	return OK;
      }
      else
	return NOT_LOCKED;
    }
    else
      return NOT_ALL_NODES;
  }
  else
    return test;
}

