/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

/*******************************************************************
** Main class for block 3
*******************************************************************/

class EventLock 
{
public:
  int Write(int UserID, long ent_no, int key , char *value, long len); 
  int Read(int UserID, long ent_no, int key, char **value, long* len); 
  
  int EWrite(int UserID, long ent_no, char *value);
  int ERead(int UserID, long ent_no, char **value);

  int CreateNode (int UserID,  long *ent_no);
  int Delete(int UserID, long ent_no);
  
  int Link(int UserID, long* ent_no, long ToNode);
  int MoveLink(int UserID, long LinkNo, long NewNode);
  int RemoveLink(int UserID, long ent_no, long link);
  
  int Event(int UserID, long ent_no, int operation, int key);
  int UnEvent(int UserID, long ent_no, int operation, int key);
  int ShowEvent(int UserID, int **usersID, long ent_no, int operation, int key);
  
  int Lock(int UserID, long ent_no, int key);
  int UnLock(int UserID, long ent_no, int key);
  int ShowLock(int UserID, int *UserId, long ent_no, int key);
	
  int Connect(int UserID);
  int Disconnect(int UserID);

  int Browse(int UserID,int type, long *value[], long *length);
    
};







