/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#include <stream.h>		// til test
#include "baltree.hh"
#include "bal2.cc"

int baltree::insert(long n, ent a)
{
  return treeinsert(&root,n,a);
};

int baltree::remove(long n)
{
  return treeremove(&root,n);
};

ent baltree::search(long n)
{
  return treesearch(root,n);
};

int baltree::clear()
{
  if (root == 0)
    return 1;
  else
  {
    treeclear(&root);
    root = 0;
    return 0;
  }
};

void baltree::inorder()		// til test
{
  treeinorder(root);
};  

void baltree::preorder()	// til test
{
  treepreorder(root);
};  

long baltree::count()
{
  number = 0;  
  treecount(root);
  return number;
};


/*******************************************************************
** private functions
*******************************************************************/

int baltree::treeinsert(treelink** t, long n, ent a)
{
  treelink *ptr1, *ptr2;

  if (*t == 0)			// empty tree
  {
    *t = new treelink(n,a,null,0,0);
    h = TRUE;
    return 0;			
  }
  else if ((*t)->nr > n)
  {
    int r = treeinsert(&((*t)->left),n,a);
    if (h == TRUE) 
    {
      switch ((*t)->b) 
      {
      case plus:
	(*t)->b = null;
	h = FALSE;
	break;
      case null:
	(*t)->b = minus;
	break;
      case minus:		// rebalance tree
	ptr1 = (*t)->left;
	if (ptr1->b == minus)
	{			// single LL rotation
	  (*t)->left = ptr1->right;
	  ptr1->right = (*t);
	  (*t)->b = null;
	  (*t) = ptr1;
	}
	else 
	{			// double LR rotation
	  ptr2 = ptr1->right;
	  ptr1->right = ptr2->left;
	  ptr2->left = ptr1;
	  (*t)->left = ptr2->right;
	  ptr2->right = (*t);
	  if (ptr2->b == minus)
	    (*t)->b = plus;
	  else
	    (*t)->b = null;
	  if (ptr2->b == plus)
	    ptr1->b = minus;
	  else
	    ptr1->b = null;
	  (*t) = ptr2;
	}
	(*t)->b = null;
	h = FALSE;		// tree rebalanced !!
	break;
      }
    };
    return r;
  }
  else if ((*t)->nr < n)  
  {
    int r = treeinsert(&((*t)->right),n,a);
    if (h == TRUE)
      switch ((*t)->b) 
      {
      case minus:
	(*t)->b = null;
	h = FALSE;
	break;
      case null:
	(*t)->b = plus;
	break;
      case plus:		// rebalance tree
	ptr1 = (*t)->right;
	if (ptr1->b == plus)
	{			// single RR rotation
	  (*t)->right = ptr1->left;
	  ptr1->left = (*t);
	  (*t)->b = null;
	  (*t) = ptr1;
	}
	else
	{			// double RL rotation
	  ptr2 = ptr1->left;
	  ptr1->left = ptr2->right;
	  ptr2->right = ptr1;
	  (*t)->right = ptr2->left;
	  ptr2->left = (*t);
	  if (ptr2->b == plus)
	    (*t)->b = minus;
	  else
	    (*t)->b = null;
	  if (ptr2->b == minus)
	    ptr1->b = plus;
	  else
	    ptr1->b = null;
	  (*t) = ptr2;
	}
	(*t)->b = null;
	h = FALSE;		// tree rebalanced !!
	break;
      }
    return r;
  }
  else return 1;		// number already in tree : ((*t)->nr == n)
};

int baltree::treeremove(treelink** t, long n)
{
  treelink* ptr;

  if (*t == 0)
    return 1;			// number not in tree
  else if ((*t)->nr > n)
  {
    int r = treeremove(&((*t)->left),n);
    if (h == TRUE)
      balanceleft(&(*t));
    return r;
  }
  else if ((*t)->nr < n)
  {
    int r = treeremove(&((*t)->right),n);
    if (h == TRUE)
      balanceright(&(*t));
    return r;
  }
  else
  {				// found : ((*t)->nr == n)
    ptr = (*t);
    if (ptr->right == 0)
    {
      (*t) = ptr->left;
      h = TRUE;
      delete ptr;
    }
    else if (ptr->left == 0)
    {
      (*t) = ptr->right;
      h = TRUE;
      delete ptr;
    }
    else 
    {
      treehelpremove(&(ptr->left),&ptr);
      if (h == TRUE)
	balanceleft(&(*t));
    }
    return 0;
  }
};

void baltree::treehelpremove(treelink** t, treelink** ptr)
{
  if ((*t)->right != 0)
  {
    treehelpremove(&((*t)->right),&(*ptr));
    if (h == TRUE)
      balanceright(&(*t));
  }
  else
  {
    (*ptr)->nr = (*t)->nr;
    (*ptr)->e = (*t)->e;
    (*ptr) = (*t);
    (*t) = (*t)->left;
    h = TRUE;
    delete (*ptr);
  }
};

void baltree::balanceleft(treelink** t)
{
  treelink *ptr1, *ptr2;
  bal bal1, bal2;
  
  switch ((*t)->b)
  {
  case minus:
    (*t)->b = null; 
    break;
  case null:
    (*t)->b = plus;
    h = FALSE;
    break;
  case plus:			// rebalance tree
    ptr1 = (*t)->right;
    bal1 = ptr1->b;
    if (bal1 >= null)
    {				// single RR rotation
      (*t)->right = ptr1->left;
      ptr1->left = (*t);
      if (bal1 == null)
      {
	(*t)->b = plus;
	ptr1->b = minus;
	h = FALSE;
      }
      else
      {
	(*t)->b = null;
	ptr1->b = null;
      }
      (*t) = ptr1;
    }
    else
    {				// double RL rotation
      ptr2 = ptr1->left;
      bal2 = ptr2->b;
      ptr1->left = ptr2->right;
      ptr2->right = ptr1;
      (*t)->right = ptr2->left;
      ptr2->left = (*t);
      if (bal2 == plus)
	(*t)->b = minus;
      else
	(*t)->b = null;
      if (bal2 == minus)
	ptr1->b = plus;
      else
	ptr1->b = null;
      (*t) = ptr2;
      ptr2->b = null;
    }
  }
};

void baltree::balanceright(treelink** t)
{
  treelink *ptr1, *ptr2;
  bal bal1, bal2;

  switch ((*t)->b)
  {
  case plus:
    (*t)->b = null; 
    break;
  case null:
    (*t)->b = minus;
    h = FALSE;
    break;
  case minus:			// rebalance tree
    ptr1 = (*t)->left;
    bal1 = ptr1->b;
    if (bal1 <= null)
    {				// single LL rotation
      (*t)->left = ptr1->right;
      ptr1->right = (*t);
      if (bal1 == null)
      {
	(*t)->b = minus;
	ptr1->b = plus;
	h = FALSE;
      }
      else
      {
	(*t)->b = null;
	ptr1->b = null;
      }
      (*t) = ptr1;
    }
    else
    {				// double LR rotation
      ptr2 = ptr1->right;
      bal2 = ptr2->b;
      ptr1->right = ptr2->left;
      ptr2->left = ptr1;
      (*t)->left = ptr2->right;
      ptr2->right = (*t);
      if (bal2 == minus)
	(*t)->b = plus;
      else
	(*t)->b = null;
      if (bal2 == plus)
	ptr1->b = minus;
      else
	ptr1->b = null;
      (*t) = ptr2;
      ptr2->b = null;
    }
  }
};

ent baltree::treesearch(treelink* t, long n)
{
  if (t == 0)			// element not in tree
    return 0;
  else if (t->nr == n)
    return t->e;
  else if (t->nr > n)
    return treesearch(t->left,n);
  else
    return treesearch(t->right,n);
};

void baltree::treeclear(treelink** t)
{
  if (*t != 0)
  {
    treeclear(&((*t)->left));
    treeclear(&((*t)->right));
    delete *t;
  }
};


void baltree::treeinorder(treelink* t)        // til test
{
  if (t != 0)
  {
    treeinorder(t->left);
    cerr << "nummer = " << t->nr << "\n";
    treeinorder(t->right);
  }
};

void baltree::treepreorder(treelink* t)        // til test
{
  if (t != 0)
  {
    cerr << "nummer = " << t->nr << "\n";
    treepreorder(t->left);
    treepreorder(t->right);
  }
};

void baltree::treecount(treelink* t)
{
  if (t != 0)
  {
    treecount(t->left);
    number++;
    treecount(t->right);
  }
};
