/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

#ifdef SUN3
#include <stddef.h>
#else
#define _stddef_h
#include <bool.h>
#endif

#include <errno.h>
#include <fcntl.h>              
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include <stream.h>
#include <String.h>

#include "../../config/hb_config.hh"
#include "../ncb_config.h"
#include "block4a.hh"

#include "../../block3/MainEventLock.hh" // block3 def

extern int debug;		// the debug option
extern int hb_ncb_error;	// the global error int
extern int uniqfd;		// the uniq file des.
extern EventLock block3;	
extern char *getuserbynum(int);


/*******************************************************************
** hb_isfree() --- tell if the client slot is free
**
** output: TRUE if free, FALSE if not
*******************************************************************/

int hb_client::hb_isfree()
{
  if (used)
    return FALSE;
  return TRUE;
}


/*******************************************************************
** hb_connect() --- connect a client (make read/write ports)
**
** input: The client number
** output: TRUE if all went okay, FALSE (see hb_ncb_error) else
*******************************************************************/

int hb_client::hb_connect(int number)
{
  struct sockaddr addr;
  int filedes;
  
  if((!(filedes = makeserversock(0)))) // make the write socket
    return FALSE;
  int port = tellportnum(filedes);
  write(uniqfd, &port, INTSIZE);
  int addrsize = sizeof(addr);
  while((writefd = accept(filedes, &addr, &addrsize)) < 0)
    addrsize = sizeof(addr);
  close(filedes);
  if (debug)
    cerr << "connect: the writeport is: `" << port << "'";
  
  if(!(filedes = makeserversock(0))) // make the read socket
    return FALSE;
  port = tellportnum(filedes);
  write(uniqfd, &port, INTSIZE);
  addrsize = sizeof(addr);
  while((readfd = accept(filedes, &addr, &addrsize)) < 0)
    addrsize = sizeof(addr);
  close(filedes);
  if (debug)
    cerr << " readport: `" << port << "'";

  if(!(filedes = makeserversock(0))) // make the event socket
    return FALSE;
  port = tellportnum(filedes);
  write(uniqfd, &port, INTSIZE);
  addrsize = sizeof(addr);
  while((eventfd = accept(filedes, &addr, &addrsize)) < 0)
    addrsize = sizeof(addr);
  close(filedes);
  if (debug)
    cerr << " and eventport: `" << port << "'\n";

  char c;			// read the username
  username = "";		// make sure it's clean
  read(readfd, &c, 1);
  while (c != '\0')
  {
    username += c;
    read(readfd, &c, 1);
  }
  username += '\0';		// make sure it's null terminated

  clientnum = number;		// add the client number
  
  if (debug)
    cerr << "connect: The username is: `" << username << \
      "' and clinetnum: `" << clientnum << "'\n";

  close(uniqfd);
  used = TRUE;
  (void) block3.Connect(clientnum);
  return TRUE;
}


/*******************************************************************
** makeserversock() --- creates an internet socket
**
** input: port number desired, or 0 for a random one
** output: file descriptor of socket, or negative error
*******************************************************************/

int hb_client::makeserversock(int port)
{
  struct sockaddr_in server;
  
  int sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0)
  {
    hb_ncb_error = 3;
    return FALSE;
  }
  bzero(&server, sizeof(server));
  server.sin_family = AF_INET;
  server.sin_addr.s_addr = INADDR_ANY;
  server.sin_port = htons(port);
  
  int x = bind(sock, &server, sizeof(server));
  if (x < 0)
  {
    close(sock);
    hb_ncb_error = 7;
    return FALSE;
  }
  listen(sock, 5);
  
  if (fcntl(sock, F_SETFL, FASYNC) < 0) 
  {
    hb_ncb_error = 6;
    return FALSE;
  }
  return sock; 
}


/*******************************************************************
** tellportnum() --- returns the internet port number for a socket
**
** input: file descriptor of the socket
** output: inet port number, or FALSE
*******************************************************************/

int hb_client::tellportnum(int filedes)
{
  struct  sockaddr_in address;
  
  int length = sizeof(address);
  int err = getsockname(filedes, ((struct sockaddr*)&address), &length);
  if (err < 0)
  {
    hb_ncb_error = 8;
    return FALSE;
  }
  return ntohs(address.sin_port);
}


/*******************************************************************
** hb_read_message() --- check, parse, and send message
**
*******************************************************************/

int hb_client::hb_read_message()
{
  char *buf;
  extern int errno;
  
  if (!used)			// are there a client on this slot
    return TRUE;		// NO

  int func;
  int readret;
  
  if (fcntl(readfd, F_SETFL, FASYNC+FNDELAY) < 0) // non blocking
  {
    hb_ncb_error = 6;
    return FALSE;
  }

  if ((readret=read(readfd,&func,INTSIZE)) == -1) // have you something to say
    return TRUE;		// NO

  if (readret < 4)
    func = DISCONNECT;
  
  if (fcntl(readfd, F_SETFL, FASYNC) < 0) // blocking
  {
    hb_ncb_error = 6;
    return FALSE;
  }

  if(debug)
    cerr << "hb_read_message (" << username << ") : ";

  switch(func)
  {
    int arg1, arg2, arg3, arg4;	// vars to hold arguments
    long larg,*mlarg;		// long argument mlarg magnus
    int ret;			// return value
    int *intptr;
    int ok = OK;		// a ok value (see ../ncb_config.h)
    
  case WRITE:
    read(readfd, &arg1, LONGSIZE);	// ent_no
    read(readfd, &arg2, INTSIZE);	// key
    receivesok(&buf, &larg);
    ret = block3.Write(clientnum, arg1, arg2, buf, larg);
    if (toggel_read_buffer == 1)
    {
      char *newarea;
      char *tmpptr;
      int tmp_buf_size;

      tmp_buf_size = network_buf_size + (1 * INTSIZE);
      newarea = new char[tmp_buf_size];
      tmpptr = newarea;
      memcpy (tmpptr, network_buffer, network_buf_size);
      tmpptr += network_buf_size;
      memcpy (tmpptr, &ret, INTSIZE);
      delete network_buffer;
      network_buffer = newarea;
      network_buf_size = tmp_buf_size;
      if (debug)
	cerr << "WRITE: Buffering output ...\n";
    }
    else 
    {
      char *out;
      out = new char[12];
      write(writefd, &ret, INTSIZE);
      if (debug)
	cerr << "WRITE(" << arg1 << ", " << arg2 << ", " << 
          strncpy(out,buf,10) << ", " <<
	  larg << ")\n";
      delete out;
    }
    break;
    
  case READ:
    read(readfd, &arg1, LONGSIZE);	// ent_no
    read(readfd, &arg2, INTSIZE);	// key
    ret = block3.Read(clientnum, arg1, arg2, &buf, &larg);
    if (toggel_read_buffer == 1)
    {
      char *newarea;
      char *tmpptr;
      int tmp_buf_size;
      if (ret >= 0) 
      {
	tmp_buf_size = network_buf_size + larg + (2 * INTSIZE);
	newarea = new char[tmp_buf_size];
	tmpptr = newarea;
	memcpy (tmpptr, network_buffer, network_buf_size);
	tmpptr += network_buf_size;
	memcpy (tmpptr, &ret, INTSIZE);
	tmpptr += INTSIZE;
	memcpy (tmpptr, &larg, INTSIZE);
	tmpptr += INTSIZE;
	memcpy (tmpptr, buf, larg);
      }
      else
      {
	tmp_buf_size = network_buf_size + INTSIZE;
	newarea = new char[tmp_buf_size];
	tmpptr = newarea;
	memcpy (tmpptr, network_buffer, network_buf_size);
	tmpptr += network_buf_size;
	memcpy (tmpptr, &ret, INTSIZE);
      }
      delete network_buffer;
      network_buffer = newarea;
      network_buf_size = tmp_buf_size;
      if (debug)
	cerr << "READ: Buffering output ...\n";      
    }
    else 
    {
      char *out;
      out = new char[12];
      write(writefd, &ret, INTSIZE);
      if (ret >= 0)
	sendsok(buf, larg);
      if (debug)
	cerr << "READ(" << arg1 << ", " << arg2 << ", " << \
	  ", " << strncpy(out,buf,10) << ", " << larg << ")\n";
      delete out;
    }
    delete buf;			// delete the buffer !
    break;

// THE NEXT TWO FUNCTIONS ARE NOT IMPLEMENTED !!!!
// ===============================================
//
//  case EWRITE:
//    read(readfd, &arg1, LONGSIZE);	// ent_no
//    receivestring(&buf);
//    ret = block3.EWrite(clientnum, arg1, buf);
//    write(writefd, &ret, INTSIZE);
//    if (debug)
//      cerr << "EWRITE(" << arg1 << ", " << arg2 << ")\n";
//    break;
//
//  case EREAD:
//    read(readfd, &arg1, LONGSIZE);	// ent_no
//    ret = block3.ERead(clientnum, arg1, &buf);
//    write(writefd, &ret, INTSIZE);
//    if (ret >= 0)
//      sendstring(buf);
//    // delete *buf ????
//    if (debug)
//      cerr << "EREAD(" << arg1 << ", " << arg2 << ")\n";
//    break;


  case CREATE_NODE:
    ret = block3.CreateNode(clientnum, &larg);
    write(writefd, &ret, INTSIZE);
    if (ret >= 0)
      write(writefd, &larg, LONGSIZE);
    if (debug)
      cerr << "CREATENODE(" << larg << ")\n";
    break;

  case DELETE:
    read(readfd, &arg1, LONGSIZE);	// ent_no
    ret = block3.Delete(clientnum, arg1);
    write(writefd, &ret, INTSIZE);
    if (debug)
      cerr << "DELETE(" << arg1 << ")\n";
    break;

  case LINK:
    read(readfd, &larg, LONGSIZE);	// From
    read(readfd, &arg1, LONGSIZE);	// To
    ret = block3.Link(clientnum, &larg, arg1);
    write(writefd, &ret, INTSIZE);
    if (ret >= 0)
      write(writefd, &larg, LONGSIZE);
    if (debug)
      cerr << "LINK(" << larg << ", " << arg1 << ")\n";
    break;

  case MOVELINK:
    read(readfd, &arg1, LONGSIZE);	// Linkno
    read(readfd, &arg2, LONGSIZE);	// NewNode
    ret = block3.MoveLink(clientnum, arg1, arg2);
    write(writefd, &ret, INTSIZE);
    if (debug)
      cerr << "MOVELINK(" << arg1 << ", " << arg2 << ")\n";
    break;

  case REMOVELINK:
    read(readfd, &arg1, LONGSIZE);	// ent_no
    read(readfd, &arg2, LONGSIZE);	// link
    ret = block3.RemoveLink(clientnum, arg1, arg2);
    write(writefd, &ret, INTSIZE);
    if (debug)
      cerr << "REMOVELINK(" << arg1 << ", " << arg2 << ")\n";
    break;

  case EVENT:
    read(readfd, &arg2, LONGSIZE);	// ent_no
    read(readfd, &arg3, INTSIZE);	// operation
    read(readfd, &arg4, INTSIZE);	// key
    ret = block3.Event(clientnum, arg2, arg3, arg4);
    write(writefd, &ret, INTSIZE);
    if (debug)
      cerr << "EVENT(" << clientnum << ", " << arg2 << ", " << arg3 << \
	", " << arg4 << ")\n";
    break;

  case UNEVENT:
    read(readfd, &arg2, LONGSIZE);	// ent_no
    read(readfd, &arg3, INTSIZE);	// operation
    read(readfd, &arg4, INTSIZE);	// key
    ret = block3.UnEvent(clientnum, arg2, arg3, arg4);
    write(writefd, &ret, INTSIZE);
    if (debug)
      cerr << "UNEVENT(" << clientnum << ", " << arg2 << ", " \
	<< arg3 << ", " << arg4 << ")\n";
    break;

  case SHOWEVENT:
    read(readfd, &arg1, LONGSIZE);	// ent_no
    read(readfd, &arg2, INTSIZE);	// operation
    read(readfd, &arg3, INTSIZE);	// key
    ret = block3.ShowEvent(clientnum, &intptr, arg1, arg2, arg3);
    write(writefd, &ret, INTSIZE);
    if (ret >= 0)
    {
      usernamebuf = "";
      while(*intptr != -1)
      {
	usernamebuf += getuserbynum(*intptr);
	usernamebuf += "\n";
	intptr++;
      }
      char *chstr;
      chstr = (char *) usernamebuf;
      sendsok(chstr,strlen(chstr));
    }
    if (debug)
      cerr << "SHOWEVENT(" << arg1 << ", " << arg2 << ", " \
	<< arg3 << ")\n";
    break;

  case LOCK:
    read(readfd, &arg1, LONGSIZE);	// ent_no
    read(readfd, &arg2, INTSIZE);	// key
    ret = block3.Lock(clientnum, arg1, arg2);
    write(writefd, &ret, INTSIZE);
    if (debug)
      cerr << "LOCK(" << clientnum << ", " << arg1 << ", " << arg2  << ")\n";
    break;

  case UNLOCK:
    read(readfd, &arg1, LONGSIZE);	// ent_no
    read(readfd, &arg2, INTSIZE);	// key
    ret = block3.UnLock(clientnum, arg1, arg2);
    write(writefd, &ret, INTSIZE);
    if (debug)
      cerr << "UNLOCK(" << clientnum << ", " << arg1 << ", " << arg2 << ")\n";
    break;

  case SHOWLOCK:
    read(readfd, &arg1, LONGSIZE);	// ent_no
    read(readfd, &arg2, INTSIZE);	// key
    ret = block3.ShowLock(clientnum, &arg3, arg1, arg2);
    write(writefd, &ret, INTSIZE);
    if (ret >= 0)
    {
      usernamebuf = "";
      char *chstr;
      usernamebuf = getuserbynum(arg3);
      chstr = (char *) usernamebuf;
      sendsok(chstr,strlen(chstr));
    }
    if (debug)
      cerr << "SHOWLOCK(" << arg1 << ", " << arg2 << ")\n";
    break;

  case BROWSER:
    read(readfd, &arg1, INTSIZE);	// type
    ret = block3.Browse(clientnum, arg1, &mlarg, &larg); // magnus
    write(writefd, &ret, INTSIZE);
    if (ret >= 0)
      sendsok((char*)mlarg, (4*larg));  // magnus
    if (debug)
      cerr << "BROWSE(" << arg1 << ")\n";
    delete mlarg;			// delete the buffer ! magnus
    break;
    
  case TOGGEL_READ_BUFFER:
    if (toggel_read_buffer == 0)
    {
      if (debug)
	cerr << "TOGGEL_READ_BUFFER is ON (buffering)\n";
      toggel_read_buffer = 1;
    }
    else
    {
      toggel_read_buffer = 0;
      if (debug)
	cerr << "TOGGEL_READ_BUFFER: sending! ...\n";
      write(writefd, network_buffer, network_buf_size);
      network_buf_size = 0;
      delete network_buffer;
      network_buffer = NULL;
    }    
    break;

  case EOF:
  case DISCONNECT:
  default:
    used = FALSE;		// no client
    username = "";		// no username
    close(readfd);
    write(writefd, &ok, INTSIZE);	// send the ok signal
    close(writefd);
    close(eventfd);
    network_buf_size = 0;
    toggel_read_buffer = 0;
    if (network_buffer != NULL)
      delete network_buffer;
    (void) block3.Disconnect(clientnum);
    if (debug)
      cerr << "DISCONNECT" << "\n";
    break;
  }
  
  return TRUE;
}


/*******************************************************************
** hb_SendEvent() --- send an event to a user
*******************************************************************/

int hb_client::hb_SendEvent(char *ExecUsername, long ent_no, \
			      int operation, int key)
{
  char i='\0';

  int size = (strlen(ExecUsername) + 13);
  char str[size];
  char *strp = &str[0];

  memcpy(strp, ExecUsername, strlen(ExecUsername));
  strp += strlen(ExecUsername);
  memcpy(strp, &i, 1);
  strp += 1;
  memcpy(strp, &ent_no, LONGSIZE);
  strp += LONGSIZE;
  memcpy(strp, &operation, INTSIZE);
  strp += INTSIZE;
  memcpy(strp, &key, INTSIZE);
  
  write(eventfd, &str[0], size);
    
  if (debug)
    cerr << "SENDEVENT: from: " << ExecUsername << ", to: " << username << \
      ", ent_no: " << ent_no << ", op: " << operation << ", key: " << \
	key << "\n";
  return TRUE;
}


/*******************************************************************
** sendsok() --- send on the write-socket-port
**
** input: a pointer to a string, and the length
** output: True if all went okay
*******************************************************************/

int hb_client::sendsok(char *str, long length)
{
  int j;
  char *tmp = str;

  write(writefd, &length, LONGSIZE); // send the length

  if (debug)
    cerr << "Sending " << length << " bytes,";
  
  int put = write(writefd, tmp, length);
  if (put != length)
    return FALSE;

  if (debug)
    cerr << " done!\n";
  
  return TRUE;
}


/*******************************************************************
** receivesok() --- receive on the read-socket-port
**
** input: a pointer to a string, and a pointer to a length
** output: True if all went okay
*******************************************************************/

int hb_client::receivesok(char **str, long *len)
{
  int length;
  char *tmp;
  
  read(readfd, &length, LONGSIZE);	// read the size
  *len = length;			// return the length
  
  *str = tmp = new char[length];	// allocate mem

  if (debug)
    cerr << "Receiveing " << length << " bytes ";
  
  while (length > 0)
  {
    int got = read(readfd, tmp, length); // read all there is room for
    length -= got;
    tmp += got;
    if (debug)
      cerr << ".";
  }
  if (debug)
    cerr << " done!\n";
  
  return TRUE;
}



 
