/*******************************************************************
**
** HyperBase was designed and implemented by:
**
**	Uffe Kock Wiil 		(kock@iesd.auc.dk)
**	Claus Bo Nielsen 	(cbn@cci.dk)
**	Carsten Ruseng Jakobsen (ruseng@sun.com)
**	Finn Soelvsten
**	Per Magnus Petersen
**	Poul Larsen
**	Hans Mejdahl Jeppesen
**
** at The University of Aalborg in Denmark autumn 1989, and is provided
** for unrestricted use provided that this legend is included on all
** tape media and as a part of the software program in whole or part.
** Users may copy or modify HyperBase without charge, but are not
** authorized to license or distribute it to anyone else except as part
** of a product or program developed by the user.
**  
** HyperBase IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING
** THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A
** PARTICULAR PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR
** TRADE PRACTICE.
**  
** HyperBase is provided with no support and without any obligation on
** the part of the authors, to assist in its use, correction,
** modification or enhancement.
** 
** THE AUTHORS SHALL HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT
** OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY HyperBase OR ANY PART
** THEREOF.
** 
** In no event will the authors and/or The University of Aalborg be
** liable for any lost revenue or profits or other special, indirect and
** consequential damages, even if the authors and/or The University of
** Aalborg has been advised of the possibility of such damages.
** 
** Please address all correspondence to:
** 
** Uffe Kock Wiil
** Department of Computer Science,
** The University of Aalborg,      Email:  kock@iesd.auc.dk
** Fredrik Bajers Vej 7E,          Phone:  + 45 98 15 42 11 (Ext 5051)
** DK-9220 Aalborg, Denmark.       Fax:    + 45 98 15 81 29
**
*******************************************************************/

/*******************************************************************
** Class hb_client --- the network interface (one for each client)
*******************************************************************/

class hb_client
{
public:
  int used = FALSE;		// used = TRUE if this client slot is used
  int readfd;			// the file descriptor for the read socket
  int writefd;			//  -    -    -   -     -   -  write  -
  int eventfd;			//  -    -    -   -     -   -  event  -
  int clientnum;                // the client number

  String username="";		// the username for the client
  String buffer;
  String usernamebuf;
  
  char *network_buffer = NULL;		// the network buffer
  int network_buf_size = 0;
  int toggel_read_buffer = 0;	// the TRUE/FALSE toggle network buffer
  
  int makeserversock(int);	// make a socket to the client
  int tellportnum(int);		// give me the socket port number
  int sendsok(char*, long);	// send a string on the write socket
  int receivesok(char**, long*);// receive a string

  char *hb_the_username()       { return ((char *) username); };
  int hb_the_read_fd()          { return readfd; };
  int hb_isfree();		// tell me the value of !used
  int hb_connect(int);		// make the read and write ports
  int hb_send_message();	// send a message to the client
  int hb_read_message();	// parse the message and call block 3
  int hb_SendEvent(char*, long, int, int); // send an event
};










