/* Runtime support functions/definititions for G++.
   Copyright 1991, 1992 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, if you link this file with files
   compiled with GCC to produce an executable, this does not cause
   the resulting executable to be covered by the GNU General Public License.
   This exception does not however invalidate any other reasons why
   the executable file might be covered by the GNU General Public License.  */

extern "C" {
#include "init_main.h"
}

#ifndef DONT_HAVE_SETJMP
#ifdef L_eh
/* Library code for programs which use -fhandle-exceptions.
   Note: do *not* compile this with -fhandle-exceptions.  */

struct ExceptionHandler;

extern "C" {

#include "/usr/include/setjmp.h"

void __eprintf ( char * string, ...);
volatile void abort();

void __raise_exception (void **addr, void *id) { *addr = id;}
void __unhandled_exception (char *filename, int lineno) { abort ();}

}

struct
ExceptionHandler
{
    ExceptionHandler *prev;
    jmp_buf handler;
    void *name;
    void *parameters;
    ExceptionHandler ();
    ExceptionHandler (int first);
    ~ExceptionHandler ();
};

//
// First ExceptionHandler (statically initialized)
//
ExceptionHandler EHS (42);

//
// Pointer to the most recent ExceptionHandler
//
ExceptionHandler *exceptionHandlerStack = &EHS;


ExceptionHandler::ExceptionHandler (int)
//
// Push FIRST ExceptionHandler
// (the argument is only used to distinguish from the other constructor)
//
{
    // 
    // Here we simulate a `try' statement (and hope we don't get screwed up,
    // when we longjmp to a already exited function).
    //
    if (setjmp (EHS.handler))
	{
	    __eprintf ("unhandled exception, aborting...\n");
	    abort ();
	}
}

ExceptionHandler::ExceptionHandler ()
//
// Push ExceptionHandler
//
{
      this->prev = exceptionHandlerStack;
      exceptionHandlerStack = this;
}

ExceptionHandler::~ExceptionHandler ()
//
// Pop ExceptionHandler
//
{
    exceptionHandlerStack = this->prev;
}

#endif /* L_eh */
#endif /* DONT_HAVE_SETJMP */
