#include "funcs.h"

TYPE_RET							
_DEFUN(acosh, (xa),
       TYPE_ARG xa)				
{							
  TYPE t;		
TYPE x = xa;				
							
  if(!finite(x))			                	
  {							
    return __matherror(SNAME, x, 0.0, DOMAIN, x);	
  }							
  if (x < 0) 
  {						
    return __matherror(SNAME, x, 0.0, DOMAIN, infinity());
  }							
  /* return log1p(x) + log(2) if x is large */		
  if(x > 1e20)
  {							
    t = log1p (x) + M_LN2LO; 				
    return t + M_LN2HI ;					
  } 							
							
  if (x < 1.0) {						
      return __matherror(SNAME, x, 0.0, DOMAIN, infinity());
    }							
  t= sqrt(x - 1.0 );					
  return log1p ( t * ( t + sqrt( x+1.0)));		
}

