/*
FUNCTION
        <<atan2>>, <<atan2f>>---Arctangent of y/x

INDEX
   atan2
INDEX
   atan2f

ANSI_SYNOPSIS
        #include <math.h>
        double atan2(double <[y]>,double <[x]>);
        float atan2f(float <[y]>,float <[x]>);

TRAD_SYNOPSIS
        #include <math.h>
        double atan2(<[y]>,<[x]>);
        double <[y]>;
        double <[x]>;

        float atan2f(<[y]>,<[x]>);
        float <[y]>;
        float <[x]>;

DESCRIPTION

<<atan2>> computes the inverse tangent (Arctan) of <[y]>/<[x]>. 
<<atan2>> produces the correct result even for angles near 
@ifinfo
pi/2 or -pi/2 
@end ifinfo
@tex
$\pi/2$ or $-\pi/2$
@end tex
(that is, when <[x]> is near 0). 

<<atan2f>> is identical to <<atan2>>, save that it takes and returns
<<float>>. 

RETURNS
<<atan2>> and <<atan2f>> return a value in radians, in the range of 
@ifinfo
-pi to pi.
@end ifinfo
@tex
$-\pi$ to $\pi$.
@end tex

If both <[x]> and <[y]> are 0.0, <<atan2>> causes a <<DOMAIN>> error.

You can modify error handling for these functions using <<matherr>>.

PORTABILITY
<<atan2>> is ANSI C.  <<atan2f>> is an extension.


*/



#include "mathimpl.h"


TYPE_RET
_DEFUN(atan2,( arg_1 ,arg_2),
       TYPE_ARG arg_1 _AND
       TYPE_ARG arg_2)
{

  if( arg_1+arg_2 == arg_1) 
  {
    if(arg_1 >= 0.0) return M_PI_2;
    if(arg_1 == 0.0) return 0;
  
    return -M_PI_2;
  }
  
  else if(arg_2 <0.)
   if(arg_1 >= 0.)
    return M_PI - _satan(-arg_1/arg_2);
   else
    return -M_PI + _satan(arg_1/arg_2);
  else if(arg_1>0)
   return _satan(arg_1/arg_2);
  return -_satan(-arg_1/arg_2);

}
  
