#include "funcs.h"

TYPE_RET
_DEFUN(cosh ,(x),
       TYPE_ARG x)
{
  TYPE y, w, z;

  if (!finite(x)) 
  {
    return __matherror(SNAME, x, 0.0, DOMAIN, x);
  }

  if( x > TYPE_MAX_EXP)
  {		        					  
    return __matherror(SNAME, x, 0.0, OVERFLOW, TYPE_MAX);
  }		        					  
  		        					  
		        					  
  if( x < TYPE_MIN_EXP)
  {		        					  
    return __matherror(SNAME, x, 0.0 , UNDERFLOW, 0.0);		  
  }								  
	
	
  y = fabs(x);

  if (y > 1.0) 
  {
    w = y - 0.6931610107421875000;
    z = exp(w);
    if (w < 19.95)
     z += 0.24999308500451499336 / z;
    z += 0.13830277879601902638e-4 * z;
  } 
  else
  {
    z = exp(y);
    z = z*0.5 + 0.5/z;
  }
  return z;
}
