#include "funcs.h"

static TYPE_RET
_DEFUN(NAME,(x, jint),                                           
       TYPE_ARG x _AND						    
       int jint)							    
{								    
  TYPE result;							    
#define thresh .46875				   
  TYPE  d_1;						   	    
								    
  TYPE xden, xnum;						    
  int i;							    
  TYPE y, del, ysq;						    
								    
  y = x < 0 ? -x : x;
								    
  if (y <= thresh) 						    
  {								    
    /*  Evaluate  erf  for  |X| <= 0.46875 */			    
								    
    ysq = 0.0;							    
    if (y > XSMALL)
    {					    
	ysq = y * y;						    
      }								    
    xnum = a[4] * ysq;						    
    xden = ysq;							    
    for (i = 0; i <3 ; ++i) 
    {					    
	xnum = (xnum + a[i]) * ysq;				    
	xden = (xden + b[i]) * ysq;				    
      }								    
								    
    result = x * (xnum + a[3]) / (xden + b[3]);			    
    if (jint != 0) 
    {						    
	result = 1.0 - result;					    
      }								    
    if (jint == 2) 
    {						    
	result = exp(ysq) * result;				    
      }								    
    return result;						    
    								    
  }								    
  else if (y <= 4.0) 						    
  {								    
    xnum = c[8] * y;						    
    xden = y;							    
    for (i = 0; i < 7; ++i)
    {					    
	xnum = (xnum + c[i]) * y;				    
	xden = (xden + d[i]) * y;				    
      }								    
    result = (xnum + c[7]) / (xden + d[7]);			    
    if (jint != 2) 
    {						    
	d_1 = y * 16.0;						    
	ysq = d_int(d_1) / 16.0;				    
	del = (y - ysq) * (y + ysq);				    
	result = exp(-ysq * ysq) * exp(-del) * result;	    
      }								    
								    
								    
  } 								    
  else 								    
  {								    
    /*  Evaluate  erfc  for |X| > 4.0 */			    
    result = 0.0;						    
    if (y >= XBIG) {					    
	if (jint != 2 || y >= XMAX) {			    
	    goto L300;						    
	  }							    
	if (y >= XHUGE) {					    
	    result = M_SQRTPI / y;			            
	    goto L300;						    
	  }							    
      }								    
    ysq = 1.0 / (y * y);					    
    xnum = p[5] * ysq;						    
    xden = ysq;							    
    for (i = 1; i <= 4; ++i) 					    
	{							    
	xnum = (xnum + p[i - 1]) * ysq;				    
	xden = (xden + q[i - 1]) * ysq;				    
      }								    
    result = ysq * (xnum + p[4]) / (xden + q[4]);		    
    result = (M_SQRTPI - result) / y;				    
    if (jint != 2) {						    
	d_1 = y * 16.0;						    
	ysq = d_int(d_1) / 16.0;				    
	del = (y - ysq) * (y + ysq);				    
	result = exp(-ysq * ysq) * exp(-del) * result;	    
      }								    
  }								    
								    
  /*  Fix up for negative argument, erf, etc. */		    
 L300:								    
  if (jint == 0) 						    
  {								    
    result = 0.5 - result + 0.5;				    
    if (x < 0.0) 						    
    {								    
      result = -(result);					    
    }								    
  }								    
  else if (jint == 1) 						    
  {								    
    if (x < 0.0) 						    
    {								    
      result = 2.0 - result;					    
    }								    
  } else 							    
  {								    
    if (x < 0.0) 						    
    {								    
      if (x < XNEG)
      {								    
	result = TYPE_MAX;
      } 							    
      else 							    
      {								    
	d_1 = x * 16.0;						    
	ysq = d_int(d_1) / 16.0;				    
	del = (x - ysq) * (x + ysq);				    
	y = exp(ysq * ysq) * exp(del);			    
	result = y + y - result;				    
      }								    
    }								    
  }								    
  return result;						    
} 								    
								     
