#include <stdio.h>
#include "mathimpl.h"




double _DEFUN(__matherror,(name, arg1, arg2, type, ret),
	     char *name _AND
	     double arg1 _AND
	     double arg2 _AND
	     int type _AND
	     double ret)
{
  struct exception exp;
  exp.name = name;
  exp.type = type;
  exp.arg1 = arg1;
  exp.arg2 = arg2;
  if (matherr(&exp)) 
  {
    return exp.retval;
  }
  
  switch(exp.type)
  {
  case SING:    
    errno = EDOM;

    fflush(stdout);
    fprintf(stderr, "%s(%g): SING error\n",
	    name, 
	    arg1);

    return ret;

  case DOMAIN: 

    errno = EDOM;

    fflush(stdout);
    fprintf(stderr, "%s(%g): DOMAIN error\n",
	    name, 
	    arg1);
    return ret;
    
  case OVERFLOW:
    errno = ERANGE;
    return ret;
    
  case UNDERFLOW:
    errno = ERANGE;
    return ret;

  case TLOSS:
    return ret;

  case PLOSS:
    return ret;
  }

  return ret;
  
}

