/*
 * floor and ceil
 * 	from pete housels posting
 */

/*
FUNCTION
<<floor>>, <<floorf>>, <<ceil>>, <<ceilf>>---floor and ceiling
INDEX
	floor
INDEX
	floorf
INDEX
	ceil
INDEX
	ceilf

ANSI_SYNOPSIS
	#include <math.h>
	double floor(double <[x]>);
        float floorf(float <[x]>);
        double ceil(double <[x]>);
        float ceilf(float <[x]>);

TRAD_SYNOPSIS
	#include <math.h>
        double floor(<[x]>)
	double <[x]>;
        float floorf(<[x]>) 
	float <[x]>;
        double ceil(<[x]>) 
	double <[x]>;
        float ceilf(<[x]>) 
	float <[x]>;

DESCRIPTION
<<floor>> and <<floorf>> find 
@tex
$\lfloor x \rfloor$, 
@end tex
the nearest integer less than or equal to <[x]>.
<<ceil>> and <<ceilf>> find 
@tex
$\lceil x\rceil$,
@end tex
the nearest integer greater than or equal to <[x]>.

RETURNS
<<floor>> and <<ceil>> return the integer result as a double.
<<floorf>> and <<ceilf>> return the integer result as a float.

PORTABILITY
<<floor>> and <<ceil>> are ANSI.
<<floorf>> and <<ceilf>> are extensions.


*/


#include <math.h>

double
_DEFUN(floor,(x),double x)
{
	double	fract;
	double ipart;

	fract = modf(x, &ipart);

	if (fract < 0.0)
		return ipart - 1.0;
	else
		return ipart;
}


double
_DEFUN(ceil,(x),double x)
{
	return(-floor(-x));
}



_FLOAT_RET
_DEFUN(floorf,(x),_FLOAT_ARG x)
{
	float	fract;
	float ipart;

	fract = modff(x, &ipart);

	if (fract < 0.0)
		return ipart - 1.0;
	else
		return ipart;
}


_FLOAT_RET
_DEFUN(ceilf,(x),_FLOAT_ARG x)
{
	return(-floorf(-x));
}
