/*
FUNCTION
	<<log2>>, <<log2f>>---base 2 logarithms

INDEX
log2
INDEX
log2f

ANSI_SYNOPSIS
	#include <math.h>
	double log2(double <[x]>);
	float log2f(float <[x]>);

TRAD_SYNOPSIS
	#include <math.h>
	double log2(<[x]>)
	double <[x]>;

	float log2f(<[x]>)
	float <[x]>;

DESCRIPTION
<<log2>> returns the base 2 logarithm of <[x]>.
It is implemented as <<log(<[x]>) / log(2)>>.

<<log2f>> is identical, other than taking and returning floats.

RETURNS
<<log2>> and <<log2f>> return the calculated value. 

See the description of <<log>> for information about errors.

PORTABILITY
<<log2>> and <<log2f>> are extensions to ANSI C.
*/

#include "mathimpl.h"




double
_DEFUN(log2,(x),double x)
{
	return log(x) / M_LOG2_E;
}

_FLOAT_RET
_DEFUN(log2f,(x),_FLOAT_ARG x)
{
  float r,s;
  r  =  logf(x);
  s = r /  M_LOG2_E;
  return s;
}



	

