#include "funcs.h"

TYPE_RET
_DEFUN(sqrt,(xa),
       TYPE_ARG xa)
{
  TYPE f, y;
  TYPE x = xa;
  
  int n;

  if (!finite(x)) 
   return __matherror(SNAME, x, 0.0, DOMAIN, x);
	

  if (x == 0.0)
   return x;


  if (x < 0.0) 
  {
      return __matherror(SNAME, x, 0.0, DOMAIN, infinity());
    }
  f = frexp(x, &n);

  y = 1.0558462 + (0.29508515 * f) - (0.59905340 / (f + 0.70710678));
  y = (y + f/y);
  y = ldexp(y,-2) + f/y;	/* Swift calc saves divide */
  y = ldexp(y + f/y, -1);	/* Approx is good so only need 3 its max */

  if (n&1) 
  {
    y *= 0.70710678118654752440; /* Handle odd power */
    n++;			/* Fix exponent */
  }
  f = ldexp(y, n/2);

  f = 0.5 * (f + (x / f));
  f = 0.5 * (f + (x / f));
  f = 0.5 * (f + (x / f));
/*  f = 0.5 * (f + (x / f));
  f = 0.5 * (f + (x / f));*/

  return f;
  
}
