.\" -*- nroff -*-
.\" ---------------------------------------------------------------------------
.\"    man page for send_pr (by Heinz G. Seidl, hgs@cygnus.com)
.\"
.\"    This file is part of the Problem Report Management System (PRMS)
.\"    Copyright 1992 Cygnus Support
.\"
.\"    This program is free software; you can redistribute it and/or
.\"    modify it under the terms of the GNU General Public
.\"    License as published by the Free Software Foundation; either
.\"    version 2 of the License, or (at your option) any later version.
.\"
.\"    This program is distributed in the hope that it will be useful,
.\"    but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\"    General Public License for more details.
.\"
.\"    You should have received a copy of the GNU Library General Public
.\"    License along with this program; if not, write to the Free
.\"    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
.\"
.\"    $Id: send_pr.man,v 1.1 1992/05/28 17:56:36 zoo Exp $
.\" ---------------------------------------------------------------------------
.so defines.man
.nh
.TH SEND_PR 1 \\*(Dt \\*(Vs
.SH NAME
send_pr \- send problem report (PR) to \*(Ss
.SH SYNOPSIS
.na
.B send_pr
.OP \-v
.OP \-t mail-address
.OP \-f problem-report
.OP \-p
.OP \-P
.\".OP \-s sendmail-path
.OP \-request-id
.OP \-F
.ad
.SH DESCRIPTION
.B send_pr
is a tool for \*(Css to submit 
.I problem reports 
.RB ( PRs )
to \*(Ss.
Other users of free software maintained by \*(Ss are also welcome to
use 
.B send_pr
to advise \*(Ss of any problems with our software.
.LP
.B send_pr
invokes an editor on a problem report form (after trying to fill
in some fields with reasonable default values). After you exit the
editor, 
.B send_pr 
sends the filled out form to the
.I problem report management system 
.RB ( PRMS )
at \*(Ss.  The filled out form is checked for a \fIcustomer-id\fR and a
recognized \fIcategory\fR, and all comment fields are removed.  If an
error is detected, the problem report is left in a temporary file named
`\|\c
.BI /tmp/pbad nnnn\c
\&\|' (where \fInnnn\fP is replaced by your process ID).
The program used to send the PR is
.BR sendmail (8).
.LP
At \*(Ss, the PR is assigned a unique number and is stored in the
PRMS database according to its category and customer-id. PRMS
automatically replies with an acknowledgement, citing the category and
the PR number.
.LP
To ensure that a PR is handled promptly, it must contain your (unique)
\fIcustomer-id\fR and one of the available \fIcategories\fR to identify the
problem area.  The
.B send_pr
form at your site should already be customized with your customer-id (running
`\|\fBinstall_cid\fP \fIcustomer-id\fP\|' to accomplish this is the last
step in \*(Ss installation procedures).  
If this hasn't been done, look for your customer-id in the cover
letter from \*(Ss that came with your software release.  You can also
request your customer-id from \*(Ss by invoking 
.B send_pr
with the 
.B \-request\-id 
option. Other users of free software may use the customer-id `\|\c
.BR net \|'.
The categories available for PRs are listed below.
.LP
The more precise your problem description and the more complete your
information, the faster your support team at \*(Ss can solve
your problems. This man page describes the information we need, and
the most useful way for you to organize it.
.SH OPTIONS
.TP
.B \-v
Display the 
.B send_pr
version number.
.TP
.BI \-t " mail-address"
.br
Mail address at \*(Ss for problem reports.
.br
default:
.BR \*(Ma
.TP
.BI \-f " problem-report"
Use this option to specify a file  (\fIproblem-report\fP) where you
have already filled out a problem report.  
.B send_pr
sends the contents of the file without invoking the editor.
If 
.I problem-report
is
.BR `\|\-\|' ,
then
.B send_pr
reads from standard input.
.TP
.B \-p 
print the empty, internal problem-report form on standard output (and
don't send anything).  You can use this to generate forms to FAX to
Cygnus Support if electronic mail doesn't get through, or to get a
blank form for further customizing (which you can later select with
the environment variable PR_FORM).
.TP
.B \-P
print the form specified by the environment variable PR_FORM or the empty,
internal problem-report form on standard output (and don't send anything).
.\".TP
.\".BI \-s " sendmail-path"
.\"Specifies a pathname for the sendmail command.
.\".br
.\"default:
.\".BR /usr/lib .
.TP
.B \-request\-id
sends mail to \*(Ss Support with a request for your customer-id. If you are
not a \*(Ss Support customer, please use the (pseudo) customer-id `\|\c
.BR net \|'.
.TP
.B \-F
allows you to submit a PR with customer-id 
.B unknown
and with unrecognized categories (should be used only for testing).
.PP
Note: Please use 
.B send_pr
whenever possible, rather than mailing bugreports directly.  Using
both the form and the filter program helps ensure all necessary
information will reach \*(Ss.
.SH ENVIRONMENT
The environment variable 
.B EDITOR
specifies which editor to invoke on the form.
.br
default:
.BR vi .
.sp
If the environment variable 
.B PR_FORM
is set, then its value is used as the file name of the template for
your problem-report editing session.  You can use this to start with a
partially filled-in form (for example, a form with the identification fields
already completed).
.SH "HOW TO FILL OUT A PROBLEM REPORT"
Problem reports have to be in a particular form, so that a program can manage
them. The fields we use are described in detail below.  Additionally,
please remember 
the following guidelines:
.IP \(bu 3m 
each PR needs a valid 
.I customer-id 
and 
.IR category .
.IP \(bu 3m 
describe only 
.B one problem
with 
.BR "one PR" .
.IP \(bu 3m
For follow-up mail, use the same subject line as the one in the automatic
acknowledgent. It consists of category, PR number and the original synopsis
line. This allows \*(Ss Support to relate several mail messages to a
particular PR and to record them automatically.
.IP \(bu 3m 
Please try to be as accurate as possible in the subject and/or synopsis line.
For example, use a sentence of the form 
.br
``with input/command-line 
.I foo
component 
.I xyz 
produces/causes/outputs 
.IR bar ''.
.br
The subject and the synopsis line are not confidential. That is because
open-bugs lists are compiled from them. Please avoid confidential information there.
.IP \(bu 3m
You don't need to delete the comment lines while editing the PR form;
this is done by  
.BR send_pr .
Simply put your information before or after the comment.
.\" 
.\" Get the description of the PR form from the file pr_form.{man,5}
.\" 
.nr PR 1		\" PR == 1 indicates `send_pr'
.so pr_form.man
.SH HOW TO SUBMIT TESTCASES, CODE, etc
.PP
If you have code, data or other information on how to repeat a
problem, but it does not conveniently fit into the
.B >How\-To\-Repeat: 
field, then you can transfer those files via
.I "anonymous ftp"
to 
.BR \*(Sm .
When you send the PR, 
.I mention 
that you will submit further information via ftp.  Wait for the confirmation
of the PR, then 
.I ftp 
to \*(Sm using the
.B anonymous 
account. Change into the directory
.BR private/PR-data .
Create a new directory with the name \fBp\fInnnnnnn\fR, where \fInnnnnnn\fR is
the number of the PR you obtained with the confirmation. Put your files into
that directory. Send mail to the \fBReply-To\fR e-mail address of the
confirmation message to confirm the file transfer (please don't send a
new PR for this purpose).
.SH FILES
.ta \w'/tmp/pbad$$  'u
/tmp/p$$	copy of PR used in editing session
.br
/tmp/pf$$	copy of empty PR form, for testing purposes
.br
/tmp/pbad$$	file for rejected PRs
.if !\n(PR==1 \{.
.SH SEE ALSO
.BR prms (1),
.BR file_pr (1),
.BR query_pr (1),
.BR report_pr (1)
.\}
.SH EMACS USER INTERFACE
.\" FIXME! Part of *WHAT* distribution?  We no longer distribute
.\" Emacs, so presumably the send_pr distrib?  Then don't we need to
.\" tell people how to *load* it into their Emacs, for this to have
.\" any use at all?
An EMACS user interface for 
.B send_pr
with completion of field values is part of the distribution (invoked with
.BR "M-x send-pr" ).
See the file
.B send_pr.els
for configuration and installation information.
.SH INSTALLATION AND CONFIGURATION
There are many ways in which 
.B send_pr 
can be customized to the specific needs of a \*(Cs. As mentioned above, at
least the
.B customer-id
should be set before 
.B send_pr
can be used at the \*(Cs.
You can change (patch) the customer-id used by an already installed 
.B send_pr
script, by running an auxiliary script: `\|\c
.B install_cid
.IR customer-id \|'.
If there is a need for additional configuration or customization, then you
can create a 
.I site specific makefile fragment
in the
.B send_pr
source directory, and re-make and re-install 
.BR send_pr .
Please see the 
.B README
file in the source directory for details of how to do this.
If the configuration options provided by macros in the site specific
makefile fragment are not sufficient, you can still modify the
.B send_pr
source.
All the variables which can be modified at the \*(Cs are described in
a clearly marked ``customizeable section'' of 
.BR send_pr . 
.SH AUTHOR
Heinz G. Seidl (Cygnus Support)
.SH COPYING
Copyright (c) 1992 Cygnus Support
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.

