.TH mailbox 1 "17 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
mailbox \- incoming mail display
.SH SYNOPSIS
\fBmailbox\fP [ options ] [ font=\fIname\fP ] [ mailbox=\fIpath\fP ]
.SH DESCRIPTION
\fIMailbox\fP is a monitor of incoming mail.  It can indicate the arrival of
new mail in three ways:  by highlighting a ``flag'', by displaying the sender
and subject of new mail in a window, or by sounding the workstation
bell. Any of these may optionally be turned off.
.PP
The mailbox window's behaviour and placement can be controlled with the
following options:
.TP
\fBfont=\fIname\fP\fP
Use font \fIname\fP for the text and flag.
.TP
\fBmailbox=\fIpath\fP\fP
Check the file \fIpath\fP for incoming mail (default is constructed by
appending the user's login name to the path /usr/spool/mail)
.TP
\fBpos=\fIx,y\fP\fP
Position the lower left corner at (\fIx\fP,\fIy\fP) relative to the
screen lower left corner (default is to place with the mouse).
.TP
\fBrows=\fIr\fP\fP
Make the window high enough to show the
most recent \fIr\fP mail headers (default is 4).
.TP
\fBcols=\fIc\fP\fP
Make the window wide enough to display \fIc\fP characters (default 45).
.TP
\fBsize=\fIw,h\fP\fP
Set the width of the window to \fIw\fP pixels and the height to \fIh\fP pixels.
This option overrides the \fIrows\fP and \fIcols\fP options.
.TP
\fBdelay=\fIN\fP\fP
Check the mailbox file every \fIN\fP seconds (default is 60 seconds).
.TP
\fBnoflag\fP
Don't display the ``flag'' (banner).
.TP
\fBnotext\fP
Don't display the ``text'' (headers) of incoming mail.
Note that only one of the options \fInoflag\fP and \fInotext\fP can be used.
.TP
\fBcount\fP
Display a count of the number of unread mail items in the flag (default is
for the flag to contain ``Mail'' or ``M'', depending on space).
.TP
\fBsilent\fP
Don't ring the workstation bell when new mail arrives.
.TP
.B "new"
.ns
.TP
.B "unread"
Only display new (never seen), or unread (never read) mail.
The default is to show all mail in the mailbox.
.SH "SEE ALSO"
mail(1)
