.TH Font 3I "1 August 1988" "InterViews" "InterViews Reference Manual"
.SH NAME
Font \- text font for a painter
.SH SYNOPSIS
.B #include <InterViews/font.h>
.SH DESCRIPTION
A font defines the representation of characters on the screen.
The global variable ``stdfont''
is a small, fixed-width font that Painter(3I)
operations use by default.
.SH PUBLIC OPERATIONS
.TP
.B "Font(const char* str)"
.ns
.TP
.B "Font(const char* str, int length)"
Construct a font named by the given string or substring.
.TP
.B "int Baseline()"
Return the font's baseline in pixels.
.TP
.B "boolean FixedWidth()"
Return whether the font contains fixed width characters.
.TP
.B "int Height()"
Return the font's height in pixels.
.TP
.B "int Index(const char* string, int offset, boolean between)"
.ns
.TP
.B "int Index(const char* string, int len, int offset, boolean between)"
Return the index in a string or substring of the character
that would be \fIoffset\fP pixels from the left
if the string were displayed.
If \fIbetween\fP is \fIfalse\fP, the index of the character that contains
\fIoffset\fP is returned;
otherwise the index of the character following the between-character space
that is nearest \fIoffset\fP is returned.  In either case a
negative offset will return an
index of zero and an offset beyond the end of the string or substring will
return an index equal to the length of the string.
.TP
.B "int Width(const char* string)"
.ns
.TP
.B "int Width(const char* string, int len)"
Return the width in pixels that the string or substring
would have if it were displayed in this font.
.TP
.B "boolean Valid()"
Return whether the font is meaningful.
.SH SEE ALSO
Painter(3I)
