.TH StringPool 3I "15 August 1988" "InterViews" "InterViews Reference Manual"
.SH NAME
StringPool \- store strings in large chunks
.SH SYNOPSIS
.B #include <InterViews/strpool.h>
.SH DESCRIPTION
A string pool is an area for character storage.
Because strings in a pool cannot be independently deallocated,
it is generally faster to allocate them than to use
\fInew\fP in C++ or \fImalloc\fP in C.
.SH PUBLIC OPERATIONS
.TP
.B "StringPool(int size = 800)"
Construct a string pool.  The size is used to allocate contiguous blocks
of storage.
When one block is consumed,
another block is allocated from the operating system.
The default block size will fit in a small page (1024-byte).
.TP
.B "~StringPool()"
Free the storage associated with the string pool.
.TP
.B "char* Append(const char*, int)"
Add a string of a given length to a pool.
Append does not add a null to terminate strings in the pool;
if desired, null-termination must be performed explicitly by the caller.
.SH "SEE ALSO"
malloc(3)
