.TH TextDisplay 3I "23 May 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
TextDisplay \- unstructured text display
.SH SYNOPSIS
.B #include <InterViews/textdisplay.h>
.SH DESCRIPTION
A TextDisplay manages and displays an array of lines of text.
Operations are provided to insert and delete lines, to insert and
delete text within a line, and to scroll the display.  TextDisplays
are typically used to implement interactors that require non-trivial
display of unstructured text.
.PP
The array is addressed by a line number and an index into the line.
Text can be inserted or deleted at arbitrary positions.
The display is automatically updated following modifications to the
text or when scrolling.  Each character in the array has an associated
text style.  Operations are provided to apply, add, or remove
font styles to a range of the text.  TextDisplay can be
used with both constant-width and proportionally-spaced fonts and
with arbitrary geometric transformations.
.SH PUBLIC OPERATIONS
.TP
.B "TextDisplay()"
.ns
.TP
.B "~TextDisplay()"
Create or destroy a TextDisplay.
.TP
.B "void Resize(Coord xmin, Coord ymin, Coord xmax, Coord ymax, int lineheight, int tabwidth)"
Specify dimension information for the display.  Lines of text that
fall completely inside the specified region will be displayed with
baselines separated by \fIlineheight\fP.  TextDisplay will not draw
outside the specified region.  Tab characters in the text will cause
the following character to be positioned an integral multiple of
\fItabwidth\fP from the beginning of the line.
.TP
.B "void Redraw(Painter*, Canvas*, Coord left, Coord bottom, Coord right, Coord top)"
Redraw a region of the display using the specified Painter and
Canvas.  The Painter specifies the font, colors, and transformation
to use when drawing the text.
.TP
.B "void Scroll(int line, Coord x, Coord y)"
Scroll the display so that line \fIline\fP is positioned with its
lower-left corner at (\fIx\fP, \fIy\fP).  There are no restrictions on
the arguments: it is possible to scroll the display so that no lines
are visible.
.TP
.B "void InsertLinesAfter(int line, int count)"
.ns
.TP
.B "void InsertLinesBefore(int line, int count)"
.ns
.TP
.B "void DeleteLinesAfter(int line, int count)"
.ns
.TP
.B "void DeleteLinesBefore(int line, int count)"
Insert or delete whole lines of text.  Line \fIline\fP is not affected
by the operation.  Other lines will move up or down to accommodate the
changes.  Newly inserted lines are blank.  The specified line need not
refer to an existing line.
.TP
.B "void InsertText(int line, int index, const char*, int count)"
.ns
.TP
.B "void DeleteText(int line, int index, int count)"
.ns
.TP
.B "void ReplaceText(int line, const char*, int count)"
Modify the text within line \fIline\fP.  InsertText and DeleteText
will cause the following characters on the line to move to accommodate
the changes.  ReplaceText replaces the entire text of the line.  If
the specified line is non-existent, a new line will be created.
.TP
.B "void Style(int line1, int index1, int line2, int index2, int style)"
.ns
.TP
.B "void AddStyle(int line1, int index1, int line2, int index2, int style)"
.ns
.TP
.B "void RemoveStyle(int line1, int index1, int line2, int index2, int style)"
Modify the styling of a range of text. Style replaces any existing
style; AddStyle adds style \fIstyle\fP in addition to any existing
styles; RemoveStyle removes style \fIstyle\fP without affecting other
existing styles.  Styles are specified as any combination of the
constants Plain, Boldface, Underlined, and Reversed.
.TP
.B "void CaretStyle(int style)"
.ns
.TP
.B "void Caret(int line, int index)"
Control the shape and position of a caret.  Valid caret styles are
currently NoCaret and BarCaret.  TextDisplay does not automatically
adjust the position of the caret following insertions and deletions.
.TP
.B "int LineNumber(Coord y)"
.ns
.TP
.B "int LineIndex(int line, Coord x)"
Map x and y display coordinates into line and index text coordinates.
LineNumber returns the number of the line that contains the specified
vertical position \fIy\fP.  LineIndex returns the index into line
\fIline\fP that best corresponds to the specified horizontal position
\fIx\fP.
.TP
.B "Coord Base(int line)"
.ns
.TP
.B "Coord Top(int line)"
.ns
.TP
.B "Coord Left(int line, int index)"
.ns
.TP
.B "Coord Right(int line, int index)"
Map line and index text coordinates into x and y display coordinates.
The return values define a bounding box for the character specified by
\fIline\fP and \fIindex\fP.
.SH SEE ALSO
Painter(2I), Canvas(2I)
