.TH WorldView 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
WorldView \- manipulate root scene
.SH SYNOPSIS
.B #include <InterViews/worldview.h>
.SH DESCRIPTION
.B WorldView
is a class for writing window managers that manipulate a root scene.
The operations manipulate objects of type \fBRemoteInteractor\fP, which
are interactors that exist in a different address space
than the window manager.
Typically,
a subclass of \fBWorldView\fP is defined that
handles input events according to a particular window manager style.
.SH PUBLIC OPERATIONS
.TP
.B "WorldView(World*, Sensor*, Painter*)"
Define a worldview interactor associated with a given world, and pass
the sensor and painter to the interactor constructor.
.TP
.B "RemoteInteractor Find(Coord x, Coord y)"
Return the interactor under the given (absolute) coordinates.
.TP
.B "RemoteInteractor Choose(Cursor*, boolean waitforup = true)"
Interactively choose an interactor by changing the cursor
to the given one and waiting for a button to be pressed.
If \fIwaitforup\fP is true, then wait until the button is released
before returning.
.TP
.B "virtual void InsertRemote(RemoteInteractor)"
Handle a request from an application (process)
to insert an interactor into the root scene.
The default operation is a nop.
.TP
.B "virtual void ChangeRemote(RemoteInteractor, Coord left, Coord top, int w, int h"
Handle a request from an application (process)
to change an interactor's canvas to the specified position and size.
The default operation is simply to perform a Change operation
with the given parameters.
.TP
.B "void Move(RemoteInteractor, Coord left, Coord top)"
.ns
.TP
.B "void Change(RemoteInteractor, Coord left, Coord top, int w, int h)"
The Move operation sets the interactors position given the upper left corner.
Change both moves and resizes the interactor.
.TP
.B "void Raise(RemoteInteractor)"
Raise the interactor's canvas to be above all others on the screen.
.TP
.B "void Lower(RemoteInteractor)"
Lower the interactor's canvas to be below all others on the screen.
.TP
.B "void Focus(RemoteInteractor)"
Set input focus to the interactor.
If nil is passed, the input focus is based on the location of
the pointing device.
.TP
.B "RemoteInteractor GetFocus()"
Return the current interactor that has input focus (or nil if none).
.TP
.B "void GetList(RemoteInteractor*&, int&)"
Return all the top-level interactors and a count of how many there are.
The space for the list is automatically allocated.
.TP
.B "void FreeList(RemoteInteractor*)"
Free the space allocated by a GetList call.
.TP
.B "void GetInfo(RemoteInteractor, Coord& x1, Coord& y1, Coord& x2, Coord& y2)"
Get the current position of an interactor.
.TP
.B "RemoteInteractor GetIcon(RemoteInteractor)"
Gets the icon for the specified Interactor.  If the argument Interactor is
an icon, then GetIcon gets the original Interactor.
.TP
.B "void AssignIcon(RemoteInteractor i, RemoteInteractor icon)"
Associate \fIicon\fP as the icon interactor for \fIi\fP.
.TP
.B "void UnassignIcon(RemoteInteractor)"
Remove the icon association for the given interactor.
.TP
.B "char* GetName(RemoteInteractor)"
Returns the name of the Interactor (as set by Scene::SetIcon(const char*)).
.TP
.B "RedrawAll()"
Force all the interactors on the screen to redraw themselves.
.SH PROTECTED OPERATIONS
.TP
.B "void GrabMouse(Cursor*)"
.ns
.TP
.B "void UngrabMouse()"
Get or release control of the pointing device.
GrabMouse will wait until the device is available and then sets
the cursor to the given cursor.
.TP
.B "boolean GrabButton(unsigned mask, Cursor*)"
.ns
.TP
.B "void UngrabButton(unsigned mask)"
Get or release control of a button or set of buttons.
The cursor is used when the button is pressed.
GrabButton returns \fIfalse\fP if the button is not available.
The button mask is defined by the constants in ``<InterViews/Xlib.h>''.
.TP
.B "void Lock()"
.ns
.TP
.B "void Unlock()"
Get or release exclusive access to the server.
While locked, the server will ignore other clients.
.TP
.B "void ClearInput()"
Discard any pending input events.
.TP
.B "void MoveMouse(Coord x, Coord y)"
Set the pointing device position to the given screen coordinates.
.SH SEE ALSO
Interactor(3I), Scene(3I)
